/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.packaging.dialogs;

import com.ibm.team.build.common.BuildItemFactory;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.common.model.IBuildRequest;
import com.ibm.team.build.common.model.IBuildRequestParams;
import com.ibm.team.build.internal.ui.dialogs.RequestBuildDialog;
import com.ibm.team.enterprise.build.client.packaging.IPackagingClient;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.rcp.ui.WorkItemUI;
import java.util.Arrays;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;

public class RequestPackagingDialog
extends RequestBuildDialog {
    IWorkItemHandle wiHandle;
    Boolean openSummaryWorkItem;

    public RequestPackagingDialog(Shell parentShell, IBuildDefinitionHandle buildDefinitionHandle) {
        super(parentShell, buildDefinitionHandle);
    }

    protected IBuildRequest requestBuild(ITeamRepository teamRepository, IBuildDefinitionHandle buildDefinitionHandle, IBuildProperty[] newAndModifiedBuildProperties, IBuildProperty[] deletedBuildProperties, boolean allowDuplicateRequests, IProgressMonitor monitor) throws IllegalArgumentException, TeamRepositoryException {
        IPackagingClient packagingClient;
        IWorkItemHandle wiHandle;
        IBuildRequestParams params = BuildItemFactory.createBuildRequestParams();
        params.setBuildDefinition(buildDefinitionHandle);
        params.getNewOrModifiedBuildProperties().addAll(Arrays.asList(newAndModifiedBuildProperties));
        params.getDeletedBuildProperties().addAll(Arrays.asList(deletedBuildProperties));
        params.setAllowDuplicateRequests(allowDuplicateRequests);
        params.setPersonalBuild(this.fIsPersonalBuild);
        if (this.fHandlingEngine != null) {
            params.getPotentialHandlers().add(this.fHandlingEngine);
        }
        if ((wiHandle = (packagingClient = (IPackagingClient)teamRepository.getClientLibrary(IPackagingClient.class)).createPackage(buildDefinitionHandle, newAndModifiedBuildProperties, monitor)) != null && this.getSummaryWorkItemPropertyValue(newAndModifiedBuildProperties).booleanValue()) {
            UIJob job = new UIJob(""){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    IWorkbenchPage activePage = window != null ? window.getActivePage() : null;
                    WorkItemUI.openEditor((IWorkbenchPage)activePage, (Object)wiHandle);
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
        return null;
    }

    Boolean getSummaryWorkItemPropertyValue(IBuildProperty[] newAndModifiedBuildProperties) {
        IBuildProperty[] iBuildPropertyArray = newAndModifiedBuildProperties;
        int n = newAndModifiedBuildProperties.length;
        int n2 = 0;
        while (n2 < n) {
            IBuildProperty property = iBuildPropertyArray[n2];
            if (property.getName().equals("team.package.common.openSummaryWorkItem")) {
                return Boolean.parseBoolean(property.getValue());
            }
            ++n2;
        }
        return false;
    }
}

