/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.mvs.packaging.toolkit.shiplist;

import com.ibm.jzos.PdsDirectory;
import com.ibm.team.enterprise.packaging.toolkit.shiplist.AbstractFilterXMLShipList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FilterXMLShipList
extends AbstractFilterXMLShipList {
    public FilterXMLShipList(String shipListPath, String excludeListPath, boolean isZOS) throws Exception {
        super(shipListPath, excludeListPath, isZOS);
    }

    public FilterXMLShipList(String shipListPath, String excludeListPath, String filteredShipListPath, boolean isZOS) throws Exception {
        super(shipListPath, excludeListPath, filteredShipListPath, isZOS);
    }

    @Override
    protected String getSystemContainerType() {
        return "PDS";
    }

    @Override
    protected String getSystemResourceType() {
        return "PDSMember";
    }

    protected String getSequentialContainerType() {
        return "sequential";
    }

    @Override
    public final List<String> getContainerResources(String container) {
        ArrayList<String> pdsmembers = new ArrayList<String>();
        String os = System.getProperty("os.name").toLowerCase(Locale.US);
        if (os.equals("z/os") || os.equals("os/390")) {
            PdsDirectory pds;
            try {
                pds = new PdsDirectory("//'" + container + "'");
            }
            catch (IOException e) {
                e.printStackTrace();
                return pdsmembers;
            }
            for (PdsDirectory.MemberInfo info : pds) {
                pdsmembers.add(info.getName());
            }
        } else {
            pdsmembers = new ArrayList();
            int i = 0;
            while (i < 10) {
                pdsmembers.add("PDSMBR" + i);
                ++i;
            }
        }
        return pdsmembers;
    }

    @Override
    public final List<String> resolveContainerResources(String container, String[] resource) {
        ArrayList<String> filteredResources = new ArrayList<String>();
        List<String> allResources = this.getContainerResources(container);
        Pattern resourceMatcher = Pattern.compile(resource[0].replaceAll("\\*", ".*"));
        for (String retrievedResource : allResources) {
            Matcher matchedResourceName = resourceMatcher.matcher(retrievedResource);
            if (!matchedResourceName.matches()) continue;
            filteredResources.add(retrievedResource);
        }
        return filteredResources;
    }

    @Override
    public final List<String> resolveContainer(String container) {
        ArrayList<String> containerNames = new ArrayList<String>();
        containerNames.add(container);
        return containerNames;
    }
}

