/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.mvs.packaging.taskdefs;

import com.ibm.team.enterprise.packaging.common.util.CreateShiplistUtil;
import com.ibm.team.enterprise.packaging.taskdefs.Messages;
import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;

public class RemoveHfsFromShipListTask
extends Task {
    private String fileName;
    public final String POSIX_SEPARATOR = "/";

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void execute() throws BuildException {
        Project proj = this.getProject();
        if (this.fileName == null || this.fileName.trim().isEmpty()) {
            throw new BuildException(Messages.ConvertShipListToUcdTask_MissingFileName);
        }
        File inputFile = new File(this.fileName);
        String tempOutputFileName = String.valueOf(this.fileName) + ".temp";
        File tempOutputFile = new File(tempOutputFileName);
        String outputCCSID = "UTF-8";
        String fileSystem = proj.getProperty("team.package.common.filesystem");
        if ("zos".equals(fileSystem)) {
            outputCCSID = "IBM-1047";
        }
        if (!inputFile.exists()) {
            throw new BuildException("The package manifest was not found: " + this.fileName);
        }
        try {
            CreateShiplistUtil.removeHfsContainersFromManifest((File)inputFile, (File)tempOutputFile, (String)outputCCSID);
            inputFile.delete();
            tempOutputFile.renameTo(inputFile);
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }
}

