/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.mvs.packaging.taskdefs;

import com.ibm.team.mvs.packaging.taskdefs.Messages;
import com.ibm.team.mvs.packaging.toolkit.shiplist.MergeXMLShipLists;
import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.eclipse.osgi.util.NLS;

public class MergeXMLShipListsTask
extends Task {
    protected String baseDir;

    public void setBaseDir(String baseDir) {
        this.baseDir = baseDir;
    }

    public void execute() throws BuildException {
        Project proj = this.getProject();
        String workItemOption = proj.getProperty("team.package.common.workitem.option");
        if (workItemOption != null && workItemOption.length() != 0 && Boolean.parseBoolean(workItemOption)) {
            File shipListFile;
            String shipListPath = proj.getProperty("shiplist");
            String mergeShipListPath = proj.getProperty("mergeshiplist");
            if (!(shipListPath != null && shipListPath.length() != 0 || (shipListPath = proj.getProperty("team.package.zos.optional.shiplistFilePath")) != null && shipListPath.length() != 0)) {
                return;
            }
            if (mergeShipListPath == null || mergeShipListPath.length() == 0) {
                mergeShipListPath = proj.getProperty("team.package.zos.shiplistFilePath");
                proj.log(NLS.bind((String)Messages.MergeXMLShipListsTask_MERGE_SHIPLIST_FILE_INFO_MSG, (Object)mergeShipListPath), 0);
            }
            if (!(shipListFile = new File(shipListPath)).exists()) {
                proj.log(NLS.bind((String)Messages.MergeXMLShipListsTask_OPTIONAL_SHIP_LIST_DOES_NOT_EXIST_INFO_MSG, (Object)shipListFile.getAbsolutePath()), 0);
                return;
            }
            try {
                String isZOSString = proj.getProperty("isZOSFileSystem");
                boolean isZOS = false;
                if (isZOSString != null) {
                    isZOS = Boolean.parseBoolean(isZOSString);
                }
                new MergeXMLShipLists(mergeShipListPath, shipListPath, isZOS);
            }
            catch (Exception e) {
                throw new BuildException(e.getMessage(), (Throwable)e);
            }
        }
    }
}

