/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.mvs.packaging.taskdefs;

import com.ibm.team.mvs.packaging.taskdefs.Messages;
import com.ibm.team.mvs.packaging.toolkit.shiplist.FilterXMLShipList;
import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.eclipse.osgi.util.NLS;

public class FilterXMLShipListTask
extends Task {
    protected String baseDir;

    public void setBaseDir(String baseDir) {
        this.baseDir = baseDir;
    }

    public void execute() throws BuildException {
        Project proj = this.getProject();
        String workItemOption = proj.getProperty("team.package.common.workitem.option");
        if (workItemOption != null && workItemOption.length() != 0 && Boolean.parseBoolean(workItemOption)) {
            File shipListFile;
            String shipListPath = proj.getProperty("shiplist");
            String excludeListPath = proj.getProperty("excludelist");
            if (shipListPath == null || shipListPath.length() == 0) {
                shipListPath = proj.getProperty("team.package.zos.shiplistFilePath");
            }
            if (excludeListPath == null || excludeListPath.length() == 0) {
                excludeListPath = proj.getProperty("team.package.common.excludeFilePath");
            }
            if (!(shipListFile = new File(shipListPath)).exists()) {
                proj.log(Messages.FilterXMLShipListTask_SHIP_LIST_FILE_DOES_NOT_EXIST_ERROR_MSG, 0);
                return;
            }
            if (excludeListPath != null && !"".equals(excludeListPath)) {
                File excludeFile = new File(excludeListPath);
                if (!excludeFile.exists()) {
                    throw new BuildException(NLS.bind((String)Messages.FilterXMLShipListTask_EXCLUDE_FILE_DOES_NOT_EXIST_ERROR_MSG, (Object)excludeListPath));
                }
                try {
                    String isZOSString = proj.getProperty("isZOSFileSystem");
                    boolean isZOS = false;
                    if (isZOSString != null) {
                        isZOS = Boolean.parseBoolean(isZOSString);
                    }
                    new FilterXMLShipList(shipListPath, excludeListPath, isZOS);
                }
                catch (Exception e) {
                    throw new BuildException(e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

