/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.luw.packaging.taskdefs;

import com.ibm.team.enterprise.automation.hfs.HFSUtil;
import com.ibm.team.enterprise.automation.manifest.Container;
import com.ibm.team.enterprise.automation.manifest.Manifest;
import com.ibm.team.enterprise.automation.manifest.ManifestReader;
import com.ibm.team.enterprise.automation.manifest.ManifestWriter;
import com.ibm.team.enterprise.automation.manifest.Resource;
import com.ibm.team.enterprise.packaging.hfs.PackageHFSFilesTask;
import com.ibm.team.enterprise.packaging.toolkit.util.CheckPackagingVersions;
import com.ibm.team.luw.packaging.taskdefs.Messages;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.eclipse.osgi.util.NLS;

public class GenerateLUWManifestTask
extends Task {
    private static String SLASH = "/";
    protected HashMap<String, HashSet<String>> DirectoryToResourceNameMapping = new HashMap();
    protected HashMap<String, HashSet<Resource>> DirectoryToResourceMapping = new HashMap();

    public void addExcludeFilesToFileSet(FileSet fileset, String excludeFilePath) throws Exception {
        File excludeFile = new File(excludeFilePath);
        if (excludeFile.exists()) {
            Manifest excludeManifest = ManifestReader.getInstance().getManifest(excludeFile);
            List containers = excludeManifest.getContainers();
            for (Container container : containers) {
                if (container.getType().equals("directory")) {
                    Iterator iter = container.getResourcesIterator();
                    while (iter.hasNext()) {
                        Resource resource = (Resource)iter.next();
                        fileset.createExclude().setName(String.valueOf(container.getName()) + SLASH + resource.getName());
                    }
                    continue;
                }
                this.getProject().log(Messages.GenerateLUWManifestTask_INCORRECT_EXCLUDE_FILE_FORMAT_ERROR_MSG);
            }
        } else {
            throw new BuildException(NLS.bind((String)com.ibm.team.enterprise.packaging.hfs.Messages.PackageHFSFilesTask_EXCLUDE_FILE_DOES_NOT_EXIST_ERROR_MSG, (Object)excludeFilePath));
        }
    }

    public void recursivelyCollectFileInformation(String directory, String filename) {
        File file = new File(String.valueOf(directory) + SLASH + filename);
        if (file.exists()) {
            if (file.isFile()) {
                HashSet<Object> resourceNames;
                if (this.DirectoryToResourceNameMapping.containsKey(directory)) {
                    resourceNames = this.DirectoryToResourceNameMapping.get(directory);
                } else {
                    resourceNames = new HashSet();
                    this.DirectoryToResourceNameMapping.put(directory, resourceNames);
                }
                if (!resourceNames.contains(filename)) {
                    HashSet<Object> resources;
                    Resource fileResource = new Resource();
                    fileResource.setName(filename);
                    Calendar cal = Calendar.getInstance();
                    cal.setTimeInMillis(file.lastModified());
                    fileResource.setLastModifiedTimestamp(cal.getTime().toString());
                    fileResource.setType("file");
                    if (this.DirectoryToResourceMapping.containsKey(directory)) {
                        resources = this.DirectoryToResourceMapping.get(directory);
                    } else {
                        resources = new HashSet();
                        this.DirectoryToResourceMapping.put(directory, resources);
                    }
                    resources.add(fileResource);
                    resourceNames.add(filename);
                }
                return;
            }
            File[] listedFiles = file.listFiles();
            if (listedFiles.length == 0) {
                return;
            }
            File[] fileArray = listedFiles;
            int n = listedFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File listedFile = fileArray[n2];
                this.recursivelyCollectFileInformation(String.valueOf(directory) + SLASH + filename, listedFile.getName());
                ++n2;
            }
        } else {
            this.getProject().log(NLS.bind((String)Messages.GenerateLUWManifestTask_FILE_NOT_FOUND_ERROR_MSG, (Object)(String.valueOf(directory) + SLASH + filename)));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() throws BuildException {
        Project proj = this.getProject();
        String packageDir = proj.getProperty("team.package.common.package.dir");
        String packagShipListFile = proj.getProperty("team.package.common.shiplistFilePath");
        try {
            File buildRootFile = new File(proj.getProperty("team.package.luw.buildRoot.dir"));
            String buildRootDir = buildRootFile.getCanonicalPath();
            File shiplistManifestFile = new File(packagShipListFile);
            if (!shiplistManifestFile.exists()) throw new BuildException(NLS.bind((String)com.ibm.team.enterprise.packaging.hfs.Messages.PackageHFSFilesTask_SHIP_LIST_FILE_DOES_NOT_EXIST_ERROR_MSG, (Object)packagShipListFile));
            if (CheckPackagingVersions.isDefinitionVersionGreaterThan30(proj)) {
                String[] resolvedFiles;
                Manifest shiplistManifest = ManifestReader.getInstance().getManifest(shiplistManifestFile);
                List shiplistContainers = shiplistManifest.getContainers();
                FileSet fileset = new FileSet();
                fileset.setProject(proj);
                fileset.setDir(buildRootFile);
                Date timestamp = PackageHFSFilesTask.getTimestampFromBuildRequest(this);
                for (Container container : shiplistContainers) {
                    if (!container.getType().equals("directory")) throw new BuildException(Messages.GenerateLUWManifestTask_INCORRECT_SHIP_LIST_FORMAT_LUW_CONTAINER_MUST_BE_DIRECTORY_ERROR_MSG);
                    Iterator iter = container.getResourcesIterator();
                    while (iter.hasNext()) {
                        Resource resource = (Resource)iter.next();
                        fileset.createInclude().setName(String.valueOf(container.getName()) + SLASH + resource.getName());
                    }
                }
                String excludeFilePath = proj.getProperty("team.package.common.excludeFilePath");
                if (excludeFilePath != null && excludeFilePath.trim().length() > 0) {
                    this.addExcludeFilesToFileSet(fileset, excludeFilePath);
                }
                DirectoryScanner ds = fileset.getDirectoryScanner(fileset.getProject());
                String[] stringArray = resolvedFiles = ds.getIncludedFiles();
                int n = resolvedFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    String resolvedFile = stringArray[n2];
                    int lastIndexofSlash = resolvedFile.lastIndexOf(SLASH);
                    if (lastIndexofSlash != -1) {
                        HFSUtil.collectFileInformation((String)(String.valueOf(buildRootDir) + SLASH + resolvedFile.substring(0, lastIndexofSlash)), (String)resolvedFile.substring(lastIndexofSlash + 1), (Date)timestamp, this.DirectoryToResourceMapping, (Project)proj, null);
                    } else {
                        HFSUtil.collectFileInformation((String)buildRootDir, (String)resolvedFile, (Date)timestamp, this.DirectoryToResourceMapping, (Project)proj, null);
                    }
                    ++n2;
                }
                if (this.DirectoryToResourceMapping.keySet().size() <= 0) throw new BuildException(Messages.GenerateLUWManifestTask_NOTHING_TO_PACKAGE_ERROR_MSG);
                String zipCompatibleShipListFileName = String.valueOf(packageDir) + File.separator + "packageManifest.asLUWFileSet";
                proj.setProperty("team.package.luw.temp.convertedShipListFile", zipCompatibleShipListFileName);
                PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(zipCompatibleShipListFileName), "UTF-8")));
                Manifest packageManifest = new Manifest();
                packageManifest.setType("MANIFEST_LIST");
                Set<String> containerNames = this.DirectoryToResourceMapping.keySet();
                for (String containerName : containerNames) {
                    if (!containerName.startsWith(String.valueOf(buildRootDir) + SLASH)) continue;
                    Container container = new Container();
                    container.setType("directory");
                    container.setName(containerName.substring(buildRootDir.length() + 1));
                    HashSet<Resource> resources = this.DirectoryToResourceMapping.get(containerName);
                    for (Resource resource : resources) {
                        container.addResource(resource);
                        out.println(String.valueOf(container.getName()) + SLASH + resource.getName());
                    }
                    packageManifest.addContainer(container);
                }
                ManifestWriter.getInstance().write(new File(String.valueOf(packageDir) + File.separator + "packageManifest.xml"), packageManifest);
                out.flush();
                out.close();
                return;
            } else {
                BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(shiplistManifestFile)));
                String zipCompatibleShipListFileName = String.valueOf(packageDir) + File.separator + "packageManifest.asLUWFileSet";
                proj.setProperty("team.package.luw.temp.convertedShipListFile", zipCompatibleShipListFileName);
                PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(zipCompatibleShipListFileName), "UTF-8")));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    out.println(line);
                }
                out.flush();
                out.close();
                reader.close();
                FileSet fileset = new FileSet();
                fileset.setIncludesfile(new File(packagShipListFile));
                fileset.setProject(proj);
                fileset.setDir(buildRootFile);
                String[] files = GenerateLUWManifestTask.getFileNames(fileset);
                PrintWriter out2 = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(String.valueOf(packageDir) + File.separator + "package.mf"), "UTF-8")));
                int i = 0;
                while (i < files.length) {
                    out2.println(files[i]);
                    ++i;
                }
                out2.flush();
                out2.close();
            }
            return;
        }
        catch (Exception e) {
            throw new BuildException(e.getMessage(), (Throwable)e);
        }
    }

    protected static final String[] getFileNames(FileSet fs) {
        DirectoryScanner ds = fs.getDirectoryScanner(fs.getProject());
        String[] directories = ds.getIncludedDirectories();
        String[] filesPerSe = ds.getIncludedFiles();
        String[] files = new String[directories.length + filesPerSe.length];
        System.arraycopy(directories, 0, files, 0, directories.length);
        System.arraycopy(filesPerSe, 0, files, directories.length, filesPerSe.length);
        return files;
    }

    protected static final String[] getDirectories(FileSet fs) {
        DirectoryScanner ds = fs.getDirectoryScanner(fs.getProject());
        String[] directories = ds.getIncludedDirectories();
        return directories;
    }
}

