/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.luw.packaging.taskdefs;

import com.ibm.team.enterprise.automation.manifest.Container;
import com.ibm.team.enterprise.automation.manifest.Manifest;
import com.ibm.team.enterprise.automation.manifest.ManifestReader;
import com.ibm.team.enterprise.automation.manifest.Resource;
import com.ibm.team.luw.packaging.taskdefs.Messages;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;

public class ConvertManifestToLUWAntFileSetTask
extends Task {
    protected String includesFile;
    protected String baseDir;

    public void execute() throws BuildException {
        Project proj = this.getProject();
        String packageShipListFileName = this.includesFile == null ? proj.getProperty("team.package.common.shiplistFilePath") : this.includesFile;
        File manifestFile = new File(packageShipListFileName);
        if (this.baseDir == null) {
            this.baseDir = proj.getProperty("team.package.common.packageRoot.dir");
        }
        String zipCompatibleShipListFileName = String.valueOf(this.baseDir) + File.separator + manifestFile.getName() + ".asLUWFileSet";
        proj.setProperty("team.package.luw.temp.convertedShipListFile", zipCompatibleShipListFileName);
        try {
            PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(zipCompatibleShipListFileName), "UTF-8")));
            ManifestReader mr = ManifestReader.getInstance();
            if (manifestFile.exists()) {
                Manifest mf = mr.getManifest(manifestFile);
                List containers = mf.getContainers();
                for (Container c : containers) {
                    if (!c.getType().equalsIgnoreCase("directory")) continue;
                    String folder = c.getName();
                    Iterator iter = c.getResourcesIterator();
                    while (iter.hasNext()) {
                        Resource resourceFilter = (Resource)iter.next();
                        if (!resourceFilter.getType().equalsIgnoreCase("file") && !resourceFilter.getType().equalsIgnoreCase("directory")) continue;
                        out.println(String.valueOf(folder) + File.separator + resourceFilter.getName());
                    }
                }
            }
            out.flush();
            out.close();
        }
        catch (Exception e) {
            throw new BuildException(Messages.ConvertManifestToLUWAntFileSetTask_UNABLE_TO_CONVERT_MANIFEST_TO_ZIP_FILE_SET_ERROR_MSG, (Throwable)e);
        }
    }

    public void setIncludesFile(String includesFile) {
        this.includesFile = includesFile;
    }

    public void setBaseDir(String baseDir) {
        this.baseDir = baseDir;
    }
}

