/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.luw.packaging.taskdefs;

import com.ibm.team.luw.packaging.taskdefs.Messages;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.eclipse.osgi.util.NLS;

public class CheckLUWContainerMappingsTask
extends Task {
    public void execute() throws BuildException {
        this.checkRestoreMappingPath();
    }

    private void checkRestoreMappingPath() {
        File packageDir;
        String packageDirPath;
        File restoreMappingFile;
        Project proj = this.getProject();
        String restoreMappingPath = proj.getProperty("team.package.common.restoreMappingPath");
        if (restoreMappingPath != null && restoreMappingPath.length() > 0 && (restoreMappingFile = new File(restoreMappingPath)).exists() && (packageDirPath = proj.getProperty("team.package.common.package.dir")) != null && packageDirPath.length() > 0 && (packageDir = new File(packageDirPath)).exists()) {
            String fileName = restoreMappingFile.getName();
            try {
                this.copyFile(restoreMappingFile.getAbsolutePath(), String.valueOf(packageDir.getAbsolutePath()) + "/" + fileName);
            }
            catch (IOException e) {
                throw new BuildException(NLS.bind((String)Messages.CheckLUWContainerMappingsTask_FAILED_TO_COPY_RESTORE_MAPPING_FILE_ERROR_MSG, (Object)packageDirPath), (Throwable)e);
            }
        }
    }

    private void copyFile(String sourcePath, String targetPath) throws IOException {
        int len;
        FileInputStream in = new FileInputStream(sourcePath);
        FileOutputStream out = new FileOutputStream(targetPath);
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }
}

