/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.ibmi.packaging.taskdefs;

import com.ibm.team.ibmi.packaging.taskdefs.Messages;
import com.ibm.team.ibmi.packaging.toolkit.shiplist.MergeXMLShipLists;
import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.eclipse.osgi.util.NLS;

public class IBMiMergeXMLShipListTask
extends Task {
    protected String baseDir;

    public void setBaseDir(String baseDir) {
        this.baseDir = baseDir;
    }

    public void execute() throws BuildException {
        File shipListFile;
        Project proj = this.getProject();
        String shipListPath = proj.getProperty("shiplist");
        String mergeShipListPath = proj.getProperty("mergeshiplist");
        if (!(shipListPath != null && shipListPath.length() != 0 || (shipListPath = proj.getProperty("team.package.common.includeFilePath")) != null && shipListPath.length() != 0)) {
            return;
        }
        if (mergeShipListPath == null || mergeShipListPath.length() == 0) {
            mergeShipListPath = proj.getProperty("team.package.common.workItemFilePath");
            proj.log(NLS.bind((String)Messages.IBMiMergeXMLShipListTask_MERGE_SHIP_LIST_FILE_PATH_INFO_MSG, (Object)mergeShipListPath), 0);
        }
        if (!(shipListFile = new File(shipListPath)).exists()) {
            proj.log(NLS.bind((String)Messages.IBMiMergeXMLShipListTask_OPTIONAL_SHIP_LIST_FILE_DOES_NOT_EXIST_ERROR_MSG, (Object)shipListFile.getAbsolutePath()), 0);
            return;
        }
        try {
            new MergeXMLShipLists(mergeShipListPath, shipListPath, false);
        }
        catch (Exception e) {
            throw new BuildException(e.getMessage(), (Throwable)e);
        }
    }
}

