/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.packaging.toolkit.shiplist;

import com.ibm.team.enterprise.automation.manifest.Manifest;
import com.ibm.team.enterprise.automation.manifest.ManifestReader;
import com.ibm.team.enterprise.automation.manifest.ManifestWriter;
import com.ibm.team.enterprise.packaging.toolkit.shiplist.AbstractShipListTransformer;
import java.io.File;
import java.util.Map;

public abstract class AbstractXMLShipListTransformer
extends AbstractShipListTransformer {
    protected final String ASTERIX_CHAR = "*";

    public AbstractXMLShipListTransformer(String shipListPath, String referenceListPath, String outputShipListPath, boolean isZOS) throws Exception {
        super(shipListPath, referenceListPath, outputShipListPath, isZOS);
    }

    public AbstractXMLShipListTransformer(String shipListPath, String referenceListPath, boolean isZOS) throws Exception {
        this(shipListPath, referenceListPath, shipListPath, isZOS);
    }

    @Override
    protected final void formatShipList() {
        try {
            File tempFile = new File(String.valueOf(this.outputShipList.getAbsolutePath()) + ".tmp");
            Manifest manifest = ManifestReader.getInstance().getManifest(this.outputShipList);
            String encoding = "UTF-8";
            if (this.isZOS) {
                encoding = "IBM-1047";
            }
            ManifestWriter.getInstance().write(tempFile, encoding, manifest);
            if (!this.outputShipList.delete()) {
                return;
            }
            tempFile.renameTo(this.outputShipList);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
    }

    protected String getContainerType(String containerName, Map<String, String> typeMap) {
        String type = typeMap.get(containerName);
        if (type == null) {
            type = this.getSystemContainerType();
        }
        return type;
    }

    protected String getResourceType(String containerType) {
        if ("directory".equalsIgnoreCase(containerType)) {
            return "file";
        }
        return this.getSystemResourceType();
    }

    protected abstract String getSystemResourceType();

    protected abstract String getSystemContainerType();
}

