/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.packaging.toolkit.shiplist;

import com.ibm.team.scm.common.internal.util.XMLUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class AbstractShipListTransformer {
    protected File shipList = null;
    protected File referenceList = null;
    protected File outputShipList = null;
    protected boolean isZOS = false;
    protected final String RESOURCE_ELEMENT_NAME = "name";
    protected final String CONTAINER_ELEMENT_NAME = "name";
    protected final String ROOT_MARKUP = "manifest";
    protected final String CONTAINER_MARKUP = "container";
    protected final String RESOURCE_MARKUP = "resource";
    protected final String DELETED_MARKUP = "deleted";
    protected HashMap<String, List<String>> referenceTable;
    protected HashMap<String, String> referenceTypeMap;
    protected final String RESOURCE_TYPE = "type";
    protected final String CONTAINER_TYPE = "type";

    public AbstractShipListTransformer(String shipListPath, String referenceListPath, String outputShipListPath, boolean isZOS) throws Exception {
        this.isZOS = isZOS;
        this.shipList = new File(shipListPath);
        this.referenceList = new File(referenceListPath);
        this.outputShipList = new File(outputShipListPath);
        this.referenceTable = new HashMap();
        this.referenceTypeMap = new HashMap();
        this.buildReferenceResources();
        Document docShipList = null;
        DocumentBuilderFactory docBldrFactory = XMLUtil.getSecureDocumentBuilderFactory();
        docBldrFactory.setIgnoringElementContentWhitespace(true);
        docBldrFactory.setCoalescing(true);
        docBldrFactory.setIgnoringComments(true);
        DocumentBuilder docBldr = docBldrFactory.newDocumentBuilder();
        docShipList = docBldr.parse(new FileInputStream(this.shipList));
        this.updateShipList(docShipList);
        this.saveFilteredFile(docShipList);
    }

    public AbstractShipListTransformer(String shipListPath, String referenceListPath, boolean isZOS) throws Exception {
        this(shipListPath, referenceListPath, shipListPath, isZOS);
    }

    protected final void removeNode(Document doc, Node node) throws TransformerFactoryConfigurationError, TransformerException {
        Node parent = node.getParentNode();
        parent.removeChild(node);
    }

    protected final void saveFilteredFile(Document document) throws TransformerFactoryConfigurationError, TransformerException {
        this.saveFilteredFile(document, true);
    }

    protected final void saveFilteredFile(Document document, boolean format) throws TransformerFactoryConfigurationError, TransformerException {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "3");
        DOMSource source = new DOMSource(document);
        StreamResult result = new StreamResult(this.outputShipList);
        transformer.transform(source, result);
        if (format) {
            this.formatShipList();
        }
    }

    protected final void markNodeForRemoval(Document docShipList, Node node) {
        Attr attribute = docShipList.createAttribute("DELETE");
        node.getAttributes().setNamedItem(attribute);
    }

    protected final void removeContainerNode(Document docShipList, Node containerNode) throws TransformerException {
        NodeList resources = containerNode.getChildNodes();
        int j = 0;
        while (j < resources.getLength()) {
            this.removeNode(docShipList, resources.item(j));
            ++j;
        }
        this.removeNode(docShipList, containerNode);
    }

    protected final void addIBMiResourceToParentNode(Document docShipList, String member, Node parent, String tag, String type, String IBMiType) {
        Element newChild = docShipList.createElement(tag);
        newChild.setAttribute("name", member);
        newChild.setAttribute("type", type);
        if (!"".equals(IBMiType)) {
            newChild.setAttribute("IBMiType", IBMiType);
        }
        parent.appendChild(newChild);
    }

    protected final void appendResourcesToNode(Document docShipList, List<String> members, Node node, String tag, String type) {
        int j = 0;
        while (j < members.size()) {
            this.appendResourceToNode(docShipList, members.get(j), node, tag, type);
            ++j;
        }
    }

    protected final Element appendContainerToNode(Document docShipList, String member, Node node, String tag, String type) {
        Element newChild = docShipList.createElement(tag);
        newChild.setAttribute("name", member);
        newChild.setAttribute("type", type);
        node.getParentNode().appendChild(newChild);
        return newChild;
    }

    protected final Element appendContainerToParentNode(Document docShipList, String member, Node parentNode, String tag, String type) {
        Element newChild = docShipList.createElement(tag);
        newChild.setAttribute("name", member);
        newChild.setAttribute("type", type);
        parentNode.appendChild(newChild);
        return newChild;
    }

    protected final Element appendDeletedToNode(Document docShipList, Node node) {
        Element newChild = docShipList.createElement("deleted");
        node.appendChild(newChild);
        return newChild;
    }

    protected final Element addContainerToNode(Document docShipList, String member, Node node, String tag, String type) {
        Element newChild = docShipList.createElement(tag);
        newChild.setAttribute("name", member);
        newChild.setAttribute("type", type);
        node.getParentNode().appendChild(newChild);
        return newChild;
    }

    protected final void appendResourceToNode(Document docShipList, String member, Node node, String tag, String type) {
        if (type.equals("IBMiObject")) {
            Element newChild = docShipList.createElement(tag);
            if (member.contains(".")) {
                String[] sa = member.split("[.]");
                newChild.setAttribute("name", sa[0]);
                newChild.setAttribute("type", type);
                newChild.setAttribute("IBMiType", sa[1]);
            } else {
                newChild.setAttribute("name", member);
                newChild.setAttribute("type", type);
            }
            node.getParentNode().appendChild(newChild);
        } else {
            Element newChild = docShipList.createElement(tag);
            newChild.setAttribute("name", member);
            newChild.setAttribute("type", type);
            node.getParentNode().appendChild(newChild);
        }
    }

    protected final void addResourcesToNode(Document docShipList, List<String> resources, Node node, String tag, String type) {
        int j = 0;
        while (j < resources.size()) {
            this.addResourceToNode(docShipList, resources.get(j), node, tag, type);
            ++j;
        }
    }

    protected final void addResourceToNode(Document docShipList, String resource, Node node, String tag, String type) {
        if (type.equals("IBMiObject")) {
            Element newChild = docShipList.createElement(tag);
            if (resource.contains(".")) {
                String[] sa = resource.split("[.]");
                newChild.setAttribute("name", sa[0]);
                newChild.setAttribute("type", type);
                newChild.setAttribute("IBMiType", sa[1]);
            } else {
                newChild.setAttribute("name", resource);
                newChild.setAttribute("type", type);
            }
            node.appendChild(newChild);
        } else {
            Element newChild = docShipList.createElement(tag);
            newChild.setAttribute("name", resource);
            newChild.setAttribute("type", type);
            node.appendChild(newChild);
        }
    }

    protected abstract void formatShipList();

    protected abstract void updateShipList(Document var1) throws ParserConfigurationException, IOException, SAXException, TransformerFactoryConfigurationError, TransformerException;

    protected abstract void buildReferenceResources() throws ParserConfigurationException, SAXException, IOException;
}

