/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.packaging.toolkit.shiplist;

import com.ibm.team.enterprise.packaging.toolkit.shiplist.AbstractXMLShipListTransformer;
import com.ibm.team.scm.common.internal.util.XMLUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class AbstractMergeXMLShipLists
extends AbstractXMLShipListTransformer {
    protected HashMap<String, List<String>> deletionReferenceTable;
    protected HashMap<String, String> deletionContainerTypeMap;
    private static final List<String> SEQUENTIAL_INDICATOR = new ArrayList<String>();

    public AbstractMergeXMLShipLists(String shipListPath, String referenceListPath, boolean isZOS) throws Exception {
        super(shipListPath, referenceListPath, isZOS);
    }

    public AbstractMergeXMLShipLists(String shipListPath, String referenceListPath, String mergedShipListPath, boolean isZOS) throws Exception {
        super(shipListPath, referenceListPath, mergedShipListPath, isZOS);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void updateShipList(Document docShipList) throws ParserConfigurationException, IOException, SAXException, TransformerFactoryConfigurationError, TransformerException {
        Node resourceNode;
        Node nonDeletionContainer;
        List<Object> deletedResources;
        void var6_7;
        NodeList nodes = docShipList.getChildNodes();
        NodeList containerNodes = docShipList.getElementsByTagName("container");
        HashMap<String, Object> deletedContainers = new HashMap<String, Object>();
        HashMap<String, Node> containers = new HashMap<String, Node>();
        boolean bl = false;
        while (var6_7 < containerNodes.getLength()) {
            Node container = containerNodes.item((int)var6_7);
            String containerName = container.getAttributes().getNamedItem("name").getNodeValue();
            if (container.getParentNode().getNodeName().equals("deleted")) {
                deletedContainers.put(containerName, container);
            } else {
                containers.put(containerName, container);
            }
            ++var6_7;
        }
        for (Map.Entry entry : deletedContainers.entrySet()) {
            boolean addingAsteriskDeletion;
            String currentContainerName = (String)entry.getKey();
            String currentContainerType = this.getContainerType(currentContainerName, this.deletionContainerTypeMap);
            Node container = (Node)entry.getValue();
            NodeList resourceList = container.getChildNodes();
            deletedResources = new ArrayList(resourceList.getLength());
            int i2 = 0;
            while (i2 < resourceList.getLength()) {
                Node item;
                if (resourceList.item(i2).getNodeName().equals("resource") && (item = resourceList.item(i2).getAttributes().getNamedItem("name")) != null) {
                    String resource = item.getNodeValue();
                    deletedResources.add(resource);
                }
                ++i2;
            }
            boolean bl2 = addingAsteriskDeletion = this.deletionReferenceTable.get(currentContainerName) != null && this.deletionReferenceTable.get(currentContainerName).contains("*");
            if (addingAsteriskDeletion || deletedResources.contains("*")) {
                this.referenceTable.remove(currentContainerName);
                this.deletionReferenceTable.remove(currentContainerName);
                nonDeletionContainer = (Node)containers.get(currentContainerName);
                if (nonDeletionContainer != null) {
                    this.removeContainerNode(docShipList, nonDeletionContainer);
                    containers.remove(currentContainerName);
                }
                NodeList kids = container.getChildNodes();
                int l = 0;
                while (l < kids.getLength()) {
                    resourceNode = kids.item(l);
                    if (resourceNode.getNodeName().equals("resource")) {
                        this.removeNode(docShipList, resourceNode);
                    }
                    ++l;
                }
                this.addResourceToNode(docShipList, "*", container, "resource", this.getResourceType(currentContainerType));
                continue;
            }
            if (this.deletionReferenceTable.containsKey(currentContainerName)) {
                List<String> toAdd = this.deletionReferenceTable.get(currentContainerName);
                Iterator<String> it = toAdd.iterator();
                while (it.hasNext()) {
                    String resource = it.next();
                    if (!deletedResources.contains(resource)) {
                        deletedResources.add(resource);
                        continue;
                    }
                    it.remove();
                }
                this.addResourcesToNode(docShipList, toAdd, container, "resource", this.getResourceType(currentContainerType));
                this.deletionReferenceTable.remove(currentContainerName);
            }
            this.removeResourcesFromContainer(deletedResources, currentContainerName, this.referenceTable, containers, docShipList);
        }
        Set<String> set = this.deletionReferenceTable.keySet();
        Iterator<String> it = set.iterator();
        while (it.hasNext()) {
            Node lastDeletedContainer;
            nodes = docShipList.getChildNodes();
            Node lastDeleted = null;
            NodeList deletedNodes = docShipList.getElementsByTagName("deleted");
            if (deletedNodes.getLength() > 0) {
                lastDeleted = deletedNodes.item(deletedNodes.getLength() - 1);
            }
            if (lastDeleted == null) {
                lastDeleted = this.appendDeletedToNode(docShipList, nodes.item(0));
                lastDeletedContainer = null;
            } else {
                NodeList deletedContainerNodes = lastDeleted.getChildNodes();
                lastDeletedContainer = deletedContainerNodes.item(deletedContainerNodes.getLength() - 1);
            }
            String containerName = it.next();
            deletedResources = this.deletionReferenceTable.get(containerName);
            String containerType = this.getContainerType(containerName, this.deletionContainerTypeMap);
            lastDeletedContainer = lastDeletedContainer != null ? this.appendContainerToNode(docShipList, containerName, lastDeletedContainer, "container", containerType) : this.appendContainerToParentNode(docShipList, containerName, lastDeleted, "container", containerType);
            if (deletedResources.contains("*")) {
                this.addResourceToNode(docShipList, "*", lastDeletedContainer, "resource", this.getResourceType(containerType));
                this.referenceTable.remove(containerName);
                nonDeletionContainer = (Node)containers.get(containerName);
                if (nonDeletionContainer == null) continue;
                this.removeContainerNode(docShipList, nonDeletionContainer);
                containers.remove(containerName);
                continue;
            }
            this.addResourcesToNode(docShipList, deletedResources, lastDeletedContainer, "resource", this.getResourceType(containerType));
            this.removeResourcesFromContainer(deletedResources, containerName, this.referenceTable, containers, docShipList);
        }
        for (Map.Entry entry : containers.entrySet()) {
            String currentContainerName = (String)entry.getKey();
            Node container = (Node)entry.getValue();
            if (!this.referenceTable.containsKey(currentContainerName)) continue;
            List resourcesToMerge = (List)this.referenceTable.get(currentContainerName);
            String currentContainerType = this.getContainerType(currentContainerName, this.referenceTypeMap);
            NodeList resourceList = container.getChildNodes();
            ArrayList<String> currentResources = new ArrayList<String>(resourceList.getLength());
            int i3 = 0;
            while (i3 < resourceList.getLength()) {
                Node item;
                if (resourceList.item(i3).getNodeName().equals("resource") && (item = resourceList.item(i3).getAttributes().getNamedItem("name")) != null) {
                    String resource = item.getNodeValue();
                    currentResources.add(resource);
                }
                ++i3;
            }
            if (resourcesToMerge.contains("*") || currentResources.contains("*")) {
                int l = 0;
                while (l < container.getChildNodes().getLength()) {
                    resourceNode = container.getChildNodes().item(l);
                    if (resourceNode.getNodeName().equals("resource")) {
                        this.removeNode(docShipList, resourceNode);
                    }
                    ++l;
                }
                this.addResourceToNode(docShipList, "*", container, "resource", this.getResourceType(currentContainerType));
            } else {
                resourcesToMerge.removeAll(currentResources);
                if (!resourcesToMerge.isEmpty()) {
                    this.addResourcesToNode(docShipList, resourcesToMerge, container, "resource", this.getResourceType(currentContainerType));
                }
            }
            this.referenceTable.remove(currentContainerName);
        }
        Set set2 = this.referenceTable.keySet();
        it = set2.iterator();
        while (it.hasNext()) {
            nodes = docShipList.getChildNodes();
            containerNodes = docShipList.getElementsByTagName("container");
            Node lastNonDeletedContainer = null;
            int i4 = containerNodes.getLength() - 1;
            while (i4 >= 0 && lastNonDeletedContainer == null) {
                Node node = containerNodes.item(i4);
                if (node != null && !node.getParentNode().getNodeName().equals("deleted")) {
                    lastNonDeletedContainer = node;
                }
                --i4;
            }
            String containerName = it.next();
            List resources = (List)this.referenceTable.get(containerName);
            String containerType = this.getContainerType(containerName, this.referenceTypeMap);
            lastNonDeletedContainer = lastNonDeletedContainer != null ? this.appendContainerToNode(docShipList, containerName, lastNonDeletedContainer, "container", containerType) : this.appendContainerToParentNode(docShipList, containerName, nodes.item(0), "container", containerType);
            this.addResourcesToNode(docShipList, resources, lastNonDeletedContainer, "resource", this.getResourceType(containerType));
        }
    }

    private void removeResourcesFromContainer(List<String> resourcesToRemove, String containerName, Map<String, List<String>> refTable, Map<String, Node> nonDeletionContainers, Document docShipList) throws TransformerException {
        Node container;
        List<String> resources;
        if (refTable != null && (resources = refTable.get(containerName)) != null && resourcesToRemove != SEQUENTIAL_INDICATOR) {
            resources.removeAll(resourcesToRemove);
            if (resources.isEmpty()) {
                refTable.remove(containerName);
            }
        }
        if (nonDeletionContainers != null && (container = nonDeletionContainers.get(containerName)) != null) {
            if ("sequential".equals(container.getAttributes().getNamedItem("type").getNodeValue())) {
                this.removeContainerNode(docShipList, container);
                nonDeletionContainers.remove(containerName);
            } else {
                NodeList kids = container.getChildNodes();
                int i = 0;
                while (i < kids.getLength()) {
                    Node item;
                    if (kids.item(i).getNodeName().equals("resource") && (item = kids.item(i).getAttributes().getNamedItem("name")) != null && resourcesToRemove.contains(item.getNodeValue())) {
                        this.removeNode(docShipList, kids.item(i));
                        --i;
                    }
                    ++i;
                }
                boolean hasResources = false;
                int i2 = 0;
                while (i2 < kids.getLength()) {
                    if (kids.item(i2).getNodeName().equals("resource")) {
                        hasResources = true;
                        break;
                    }
                    ++i2;
                }
                if (!hasResources) {
                    this.removeContainerNode(docShipList, container);
                    nonDeletionContainers.remove(containerName);
                }
            }
        }
    }

    @Override
    protected void buildReferenceResources() throws ParserConfigurationException, SAXException, IOException {
        this.deletionReferenceTable = new HashMap();
        this.deletionContainerTypeMap = new HashMap();
        DocumentBuilder docBldr = XMLUtil.getSecureDocumentBuilderFactory().newDocumentBuilder();
        Document shipListDocument = docBldr.parse(this.referenceList);
        NodeList containers = shipListDocument.getElementsByTagName("container");
        int i = 0;
        while (i < containers.getLength()) {
            Node container = containers.item(i);
            String containerName = container.getAttributes().getNamedItem("name").getNodeValue();
            String containerType = container.getAttributes().getNamedItem("type").getNodeValue();
            if ("sequential".equals(containerType)) {
                if (container.getParentNode().getNodeName().equals("deleted")) {
                    this.deletionReferenceTable.put(containerName, SEQUENTIAL_INDICATOR);
                    this.deletionContainerTypeMap.put(containerName, containerType);
                } else {
                    this.referenceTable.put(containerName, SEQUENTIAL_INDICATOR);
                    this.referenceTypeMap.put(containerName, containerType);
                }
            } else {
                NodeList resources = container.getChildNodes();
                ArrayList<String> listOfResources = new ArrayList<String>();
                int j = 0;
                while (j < resources.getLength()) {
                    if (resources.item(j).getNodeName().equals("resource")) {
                        String resourceName = resources.item(j).getAttributes().getNamedItem("name").getNodeValue();
                        if (resources.item(j).getAttributes().getNamedItem("type").getNodeValue().equals("IBMiObject")) {
                            Node IBMitypeNode = resources.item(j).getAttributes().getNamedItem("IBMiType");
                            if (IBMitypeNode != null && !IBMitypeNode.getNodeValue().equals("*")) {
                                listOfResources.add(String.valueOf(resourceName.toUpperCase()) + "." + IBMitypeNode.getNodeValue().toUpperCase());
                            } else {
                                listOfResources.add(resourceName.toUpperCase());
                            }
                        } else {
                            listOfResources.add(resourceName);
                        }
                    }
                    ++j;
                }
                if (listOfResources.size() > 0) {
                    if (container.getParentNode().getNodeName().equals("deleted")) {
                        this.deletionReferenceTable.put(containerName, listOfResources);
                        this.deletionContainerTypeMap.put(containerName, containerType);
                    } else {
                        this.referenceTable.put(containerName, listOfResources);
                        this.referenceTypeMap.put(containerName, containerType);
                    }
                }
            }
            ++i;
        }
        Document docShipList = docBldr.parse(this.shipList);
        containers = docShipList.getElementsByTagName("container");
        int i2 = 0;
        while (i2 < containers.getLength()) {
            Node container = containers.item(i2);
            String containerName = container.getAttributes().getNamedItem("name").getNodeValue();
            boolean isDeletedContainer = container.getParentNode().getNodeName().equals("deleted");
            if (this.referenceTable.get(containerName) != null || isDeletedContainer && this.deletionReferenceTable.get(containerName) != null) {
                NodeList resources = container.getChildNodes();
                ArrayList<String> listOfResources = new ArrayList<String>();
                int j = 0;
                while (j < resources.getLength()) {
                    if (resources.item(j).getNodeName().equals("resource")) {
                        String resourceName = resources.item(j).getAttributes().getNamedItem("name").getNodeValue();
                        if (resources.item(j).getAttributes().getNamedItem("type").getNodeValue().equals("IBMiObject")) {
                            Node IBMitypeNode = resources.item(j).getAttributes().getNamedItem("IBMiType");
                            if (IBMitypeNode != null && !IBMitypeNode.getNodeValue().equals("*")) {
                                listOfResources.add(String.valueOf(resourceName.toUpperCase()) + "." + IBMitypeNode.getNodeValue().toUpperCase());
                            } else {
                                listOfResources.add(resourceName.toUpperCase());
                            }
                        } else {
                            listOfResources.add(resourceName);
                        }
                    }
                    ++j;
                }
                if (this.referenceTable.get(containerName) != null) {
                    List references = (List)this.referenceTable.get(containerName);
                    int k = 0;
                    while (k < references.size()) {
                        if (listOfResources.contains(references.get(k))) {
                            references.remove(references.get(k));
                            --k;
                        }
                        ++k;
                    }
                }
                if (isDeletedContainer && this.deletionReferenceTable.get(containerName) != null) {
                    List<String> references = this.deletionReferenceTable.get(containerName);
                    int k = 0;
                    while (k < references.size()) {
                        if (listOfResources.contains(references.get(k))) {
                            references.remove(references.get(k));
                            --k;
                        }
                        ++k;
                    }
                }
            }
            ++i2;
        }
    }
}

