/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.packaging.toolkit.shiplist;

import com.ibm.team.enterprise.packaging.toolkit.shiplist.AbstractXMLShipListTransformer;
import com.ibm.team.enterprise.packaging.toolkit.shiplist.EnterpriseSystemContainerResources;
import com.ibm.team.scm.common.internal.util.XMLUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class AbstractFilterXMLShipList
extends AbstractXMLShipListTransformer
implements EnterpriseSystemContainerResources {
    private static final Map<String, List<String>> excludeResContainingAsterixToResolvedResources = new HashMap<String, List<String>>();
    private static final List<String> SEQUENTIAL_INDICATOR = new ArrayList<String>();

    public AbstractFilterXMLShipList(String shipListPath, String excludeListPath, boolean isZOS) throws Exception {
        super(shipListPath, excludeListPath, isZOS);
    }

    public AbstractFilterXMLShipList(String shipListPath, String excludeListPath, String filteredShipListPath, boolean isZOS) throws Exception {
        super(shipListPath, excludeListPath, filteredShipListPath, isZOS);
    }

    protected void replaceWithResolvedContainers(Node containerNode, List<String> resolvedContainerNames, Document docShipList) throws TransformerException {
        NodeList resources = containerNode.getChildNodes();
        for (String resolvedContainerName : resolvedContainerNames) {
            Element newContainerNode = this.addContainerToNode(docShipList, resolvedContainerName, containerNode, "container", this.getSystemContainerType());
            int j = 0;
            while (j < resources.getLength()) {
                if (resources.item(j).getNodeName().equals("resource") && resources.item(j).getAttributes().getNamedItem("name") != null) {
                    Node IBMiTypeNode = resources.item(j).getAttributes().getNamedItem("IBMiType");
                    if (IBMiTypeNode != null) {
                        this.addIBMiResourceToParentNode(docShipList, resources.item(j).getAttributes().getNamedItem("name").getNodeValue(), newContainerNode, "resource", this.getSystemResourceType(), resources.item(j).getAttributes().getNamedItem("IBMiType").getNodeValue());
                    } else {
                        this.addIBMiResourceToParentNode(docShipList, resources.item(j).getAttributes().getNamedItem("name").getNodeValue(), newContainerNode, "resource", this.getSystemResourceType(), "");
                    }
                }
                ++j;
            }
        }
        this.markNodeForRemoval(docShipList, containerNode);
    }

    protected void removeNodesMarkesForRemoval(Document docShipList) throws TransformerException {
        NodeList nodes = docShipList.getChildNodes();
        NodeList childNodes = nodes.item(0).getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            if (this.removeNodesMarkesForRemoval(childNodes.item(i), docShipList)) {
                --i;
            }
            ++i;
        }
    }

    protected boolean removeNodesMarkesForRemoval(Node node, Document docShipList) throws TransformerException {
        String nodeName = node.getNodeName();
        if (nodeName.equals("container")) {
            if (node.getAttributes().getNamedItem("DELETE") != null) {
                this.removeNode(docShipList, node);
                return true;
            }
            if ("sequential".equals(node.getAttributes().getNamedItem("type").getNodeValue())) {
                return false;
            }
            int resourceCount = 0;
            NodeList resources = node.getChildNodes();
            int j = 0;
            while (j < resources.getLength()) {
                if (resources.item(j).getNodeName().equals("resource")) {
                    if (resources.item(j).getAttributes().getNamedItem("DELETE") != null) {
                        this.removeNode(docShipList, resources.item(j));
                        --j;
                    } else {
                        ++resourceCount;
                    }
                }
                ++j;
            }
            if (resourceCount == 0) {
                this.removeNode(docShipList, node);
                return true;
            }
        } else if (nodeName.equals("deleted")) {
            NodeList childNodes = node.getChildNodes();
            int i = 0;
            while (i < childNodes.getLength()) {
                if (this.removeNodesMarkesForRemoval(childNodes.item(i), docShipList)) {
                    --i;
                }
                ++i;
            }
        }
        return false;
    }

    @Override
    protected void updateShipList(Document docShipList) throws ParserConfigurationException, IOException, SAXException, TransformerFactoryConfigurationError, TransformerException {
        NodeList nodes = docShipList.getChildNodes();
        NodeList childNodes = nodes.item(0).getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            this.processNode(childNodes.item(i), docShipList);
            ++i;
        }
        this.removeNodesMarkesForRemoval(docShipList);
    }

    protected void processNode(Node node, Document docShipList) throws TransformerException {
        block12: {
            String nodeName;
            block11: {
                nodeName = node.getNodeName();
                if (!nodeName.equals("container")) break block11;
                String currentContainerName = node.getAttributes().getNamedItem("name").getNodeValue();
                if (node.getAttributes().getNamedItem("type").getNodeValue().equals("IBMiLibrary")) {
                    List<String> resolvedContainerNames = this.resolveContainer(currentContainerName);
                    if (resolvedContainerNames.size() > 1) {
                        this.replaceWithResolvedContainers(node, resolvedContainerNames, docShipList);
                        return;
                    }
                    if (resolvedContainerNames.size() != 1) {
                        this.markNodeForRemoval(docShipList, node);
                        return;
                    }
                    node.getAttributes().getNamedItem("name").setNodeValue(resolvedContainerNames.get(0));
                    currentContainerName = node.getAttributes().getNamedItem("name").getNodeValue();
                }
                if (!this.referenceTable.containsKey(currentContainerName)) break block12;
                List resourcesToExclude = (List)this.referenceTable.get(currentContainerName);
                if (resourcesToExclude == SEQUENTIAL_INDICATOR || resourcesToExclude.contains("*")) {
                    this.markNodeForRemoval(docShipList, node);
                } else {
                    NodeList resources = node.getChildNodes();
                    int j = 0;
                    while (j < resources.getLength()) {
                        if (resources.item(j).getNodeName().equals("resource") && resources.item(j).getAttributes().getNamedItem("name") != null) {
                            if (resources.item(j).getAttributes().getNamedItem("type").getNodeValue().equals("IBMiObject")) {
                                this.updateShiplistByResourceNameAndType(resources.item(j), currentContainerName, resourcesToExclude, docShipList);
                            } else {
                                this.updateShiplistByResourceName(resources.item(j), currentContainerName, resourcesToExclude, docShipList);
                            }
                        }
                        ++j;
                    }
                }
                break block12;
            }
            if (nodeName.equals("deleted")) {
                NodeList childNodes = node.getChildNodes();
                int i = 0;
                while (i < childNodes.getLength()) {
                    this.processNode(childNodes.item(i), docShipList);
                    ++i;
                }
            }
        }
    }

    protected void updateShiplistByResourceName(Node resourceNode, String currentContainerName, List<String> resourcesToExclude, Document docShipList) throws TransformerException {
        ArrayList<String> resourcesToExcludeContainingAsterix = new ArrayList<String>();
        String resource = resourceNode.getAttributes().getNamedItem("name").getNodeValue();
        for (String res : resourcesToExclude) {
            if (!res.contains("*")) continue;
            resourcesToExcludeContainingAsterix.add(res);
        }
        if (!resource.contains("*")) {
            boolean removeResource;
            if (resourcesToExclude.contains(resource)) {
                this.markNodeForRemoval(docShipList, resourceNode);
            } else if (resourcesToExcludeContainingAsterix.size() > 0 && (removeResource = this.isResourcePartofExcludeResourceContainingAsterix(currentContainerName, resourcesToExcludeContainingAsterix, excludeResContainingAsterixToResolvedResources, resource))) {
                this.markNodeForRemoval(docShipList, resourceNode);
            }
        } else {
            List<String> allResources = resource.equals("*") ? this.getContainerResources(currentContainerName) : this.resolveContainerResources(currentContainerName, new String[]{resource});
            ArrayList<String> filteredResources = new ArrayList<String>();
            int k = 0;
            while (k < allResources.size()) {
                String containerResource = allResources.get(k);
                if (!resourcesToExclude.contains(containerResource) && !this.isResourcePartofExcludeResourceContainingAsterix(currentContainerName, resourcesToExcludeContainingAsterix, excludeResContainingAsterixToResolvedResources, containerResource)) {
                    filteredResources.add(containerResource);
                }
                ++k;
            }
            if (filteredResources.size() > 0) {
                this.appendResourcesToNode(docShipList, filteredResources, resourceNode, "resource", this.getSystemResourceType());
                this.markNodeForRemoval(docShipList, resourceNode);
            } else if (filteredResources.size() == 0) {
                this.markNodeForRemoval(docShipList, resourceNode);
            }
        }
    }

    private boolean isResourcePartofExcludeResourceContainingAsterix(String currentContainerName, List<String> resourcesToExcludeContainingAsterix, Map<String, List<String>> excludeResContainingAsterixToResolvedResources, String resource) {
        for (String res : resourcesToExcludeContainingAsterix) {
            List<String> allResources;
            if (excludeResContainingAsterixToResolvedResources.containsKey(res)) {
                allResources = excludeResContainingAsterixToResolvedResources.get(res);
            } else {
                allResources = this.resolveContainerResources(currentContainerName, new String[]{res});
                excludeResContainingAsterixToResolvedResources.put(res, allResources);
            }
            for (String resolvedRes : allResources) {
                if (!resource.equals(resolvedRes)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isResourceWithTypePartofExcludeResourceContainingAsterix(String currentContainerName, List<String> resourcesToExcludeContainingAsterix, Map<String, List<String>> excludeResContainingAsterixToResolvedResources, String resource, String type) {
        for (String fullRes : resourcesToExcludeContainingAsterix) {
            List<String> allResources;
            String[] sa = fullRes.split("[.]");
            String excludeRes = sa[0];
            String excludeType = sa[1];
            if (excludeResContainingAsterixToResolvedResources.containsKey(fullRes)) {
                allResources = excludeResContainingAsterixToResolvedResources.get(fullRes);
            } else {
                allResources = this.resolveContainerResources(currentContainerName, new String[]{excludeRes, excludeType});
                excludeResContainingAsterixToResolvedResources.put(fullRes, allResources);
            }
            for (String resolvedRes : allResources) {
                sa = resolvedRes.split("[.]");
                String resName = sa[0];
                String resType = sa[1];
                if (!resName.equals(resource) || !resType.equals(type)) continue;
                return true;
            }
        }
        return false;
    }

    protected void updateShiplistByResourceNameAndType(Node resourceNode, String currentContainerName, List<String> resourcesToExclude, Document docShipList) throws TransformerException {
        String resource = resourceNode.getAttributes().getNamedItem("name").getNodeValue().toUpperCase();
        Node IBMitypeNode = resourceNode.getAttributes().getNamedItem("IBMiType");
        ArrayList<String> resourcesToExcludeContainingAsterix = new ArrayList<String>();
        for (String res : resourcesToExclude) {
            if (!res.contains("*")) continue;
            resourcesToExcludeContainingAsterix.add(res);
        }
        if (!resource.contains("*") && IBMitypeNode != null && !IBMitypeNode.getNodeValue().equals("*")) {
            boolean removeResource;
            if (resourcesToExclude.contains(String.valueOf(resource) + "." + IBMitypeNode.getNodeValue().toUpperCase()) || resourcesToExclude.contains("*." + IBMitypeNode.getNodeValue().toUpperCase()) || resourcesToExclude.contains(resource)) {
                this.markNodeForRemoval(docShipList, resourceNode);
            } else if (resourcesToExcludeContainingAsterix.size() > 0 && (removeResource = this.isResourceWithTypePartofExcludeResourceContainingAsterix(currentContainerName, resourcesToExcludeContainingAsterix, excludeResContainingAsterixToResolvedResources, resource, IBMitypeNode.getNodeValue()))) {
                this.markNodeForRemoval(docShipList, resourceNode);
            }
        } else {
            List<String> allResources = IBMitypeNode != null ? this.resolveContainerResources(currentContainerName, new String[]{resource, IBMitypeNode.getNodeValue()}) : this.resolveContainerResources(currentContainerName, new String[]{resource, "*"});
            ArrayList<String> filteredResources = new ArrayList<String>();
            int k = 0;
            while (k < allResources.size()) {
                String containerResource = allResources.get(k);
                String[] sa = containerResource.split("[.]");
                String containerResourceName = sa[0];
                String containerResourceType = sa[1];
                if (!(resourcesToExclude.contains(containerResource) || resourcesToExclude.contains(containerResourceName) || resourcesToExclude.contains("*." + containerResourceType))) {
                    filteredResources.add(containerResource);
                }
                ++k;
            }
            if (filteredResources.size() > 0) {
                this.appendResourcesToNode(docShipList, filteredResources, resourceNode, "resource", this.getSystemResourceType());
                this.markNodeForRemoval(docShipList, resourceNode);
            } else if (filteredResources.size() == 0) {
                this.markNodeForRemoval(docShipList, resourceNode);
            }
        }
    }

    @Override
    protected void buildReferenceResources() throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory docBldrFactory = XMLUtil.getSecureDocumentBuilderFactory();
        DocumentBuilder docBldr = docBldrFactory.newDocumentBuilder();
        Document shipListDocument = docBldr.parse(this.referenceList);
        NodeList containers = shipListDocument.getElementsByTagName("container");
        int i = 0;
        while (i < containers.getLength()) {
            Node container = containers.item(i);
            String containerName = container.getAttributes().getNamedItem("name").getNodeValue();
            String containerType = container.getAttributes().getNamedItem("type").getNodeValue();
            if ("sequential".equals(containerType)) {
                this.referenceTable.put(containerName, SEQUENTIAL_INDICATOR);
            } else if (!"directory".equalsIgnoreCase(containerType)) {
                NodeList resources = container.getChildNodes();
                List<String> resolvedContainerNames = this.resolveContainer(containerName);
                for (String resolvedContainerName : resolvedContainerNames) {
                    ArrayList<String> listOfResources = new ArrayList<String>();
                    int j = 0;
                    while (j < resources.getLength()) {
                        if (resources.item(j).getNodeName().equals("resource")) {
                            String resourceName = resources.item(j).getAttributes().getNamedItem("name").getNodeValue();
                            if (resources.item(j).getAttributes().getNamedItem("type").getNodeValue().equals("IBMiObject")) {
                                Node IBMitypeNode = resources.item(j).getAttributes().getNamedItem("IBMiType");
                                if (IBMitypeNode != null && !IBMitypeNode.getNodeValue().equals("*")) {
                                    listOfResources.add(String.valueOf(resourceName.toUpperCase()) + "." + IBMitypeNode.getNodeValue().toUpperCase());
                                } else {
                                    listOfResources.add(resourceName.toUpperCase());
                                }
                            } else {
                                listOfResources.add(resourceName);
                            }
                        }
                        ++j;
                    }
                    if (listOfResources.size() <= 0) continue;
                    this.referenceTable.put(resolvedContainerName, listOfResources);
                }
            }
            ++i;
        }
    }
}

