/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.packaging.toolkit.manifest;

import com.ibm.team.enterprise.automation.manifest.Container;
import com.ibm.team.enterprise.automation.manifest.Manifest;
import com.ibm.team.enterprise.automation.manifest.Resource;
import com.ibm.team.enterprise.packaging.toolkit.manifest.AbstractManifestMerger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.Project;

public class ManifestPropertyMerger
extends AbstractManifestMerger {
    private String attributesToProperties;

    @Override
    public Project getAntProject() {
        return this.antProject;
    }

    @Override
    public void setAntProject(Project antProject) {
        this.antProject = antProject;
    }

    public ManifestPropertyMerger(Project project, String inputFileName, String inputPropertiesFileName, String outputFileName, String outputCodePage, String attributesToProperties) {
        super(project, inputFileName, inputPropertiesFileName, outputFileName, outputCodePage);
        this.setAttributesToProperties(attributesToProperties);
        this.execute();
    }

    public String getAttributesToProperties() {
        return this.attributesToProperties;
    }

    public void setAttributesToProperties(String attributesToProperties) {
        this.attributesToProperties = attributesToProperties;
    }

    @Override
    protected Manifest mergeManifest(Manifest inputManifest, Manifest inputPropertyManifest) {
        Manifest outputPropertyManifest = new Manifest();
        outputPropertyManifest.setType("MANIFEST_SHIPLIST");
        List inputContainers = inputManifest.getContainers();
        for (Container container : inputContainers) {
            Container outputContainer = new Container(container);
            Container propertyContainer = this.findEquivalentContainer(container, inputPropertyManifest);
            if (propertyContainer != null) {
                outputContainer.setProperties(this.mergeProperties(container.getProperties(), propertyContainer.getProperties()));
            }
            Iterator resourceIterator = container.getResourcesIterator();
            while (resourceIterator.hasNext()) {
                Resource inputResource = (Resource)resourceIterator.next();
                Resource outputResource = new Resource(inputResource);
                HashMap<String, String> resourceProperties = this.findProperties(inputPropertyManifest, outputContainer, outputResource);
                outputResource.setProperties(this.mergeProperties(inputResource.getProperties(), resourceProperties));
                outputContainer.addResourceWithProperties(outputResource);
            }
            outputPropertyManifest.addContainer(outputContainer);
        }
        return outputPropertyManifest;
    }

    private HashMap<String, String> findProperties(Manifest inputPropertyManifest, Container container, Resource resource) {
        HashMap<String, String> resourceProperties = this.findExactMatchProperties(inputPropertyManifest, container, resource);
        return resourceProperties;
    }

    private HashMap<String, String> findExactMatchProperties(Manifest inputPropertyManifest, Container container, Resource resource) {
        HashMap<String, String> resourceProperties = new HashMap<String, String>();
        Resource exactMatchResource = this.findExactMatch(inputPropertyManifest, container, resource);
        if (exactMatchResource != null) {
            resourceProperties.putAll(exactMatchResource.getProperties());
        }
        return resourceProperties;
    }

    HashMap<String, String> createAttributeTable() {
        HashMap<String, String> attributesForProperties = null;
        String attributesString = this.getAttributesToProperties();
        if (attributesString != null && !attributesString.trim().isEmpty()) {
            attributesForProperties = new HashMap<String, String>();
            List<String> attributes = Arrays.asList(attributesString.split(","));
            for (String attribute : attributes) {
                attributesForProperties.put(attribute, attribute);
            }
        }
        return attributesForProperties;
    }

    private HashMap<String, String> mergeProperties(Map<String, String> originalProperties, Map<String, String> additionalProperties) {
        HashMap<String, String> mergedProperties = new HashMap<String, String>(originalProperties);
        for (Map.Entry<String, String> entry : additionalProperties.entrySet()) {
            if (mergedProperties.containsKey(entry.getKey())) continue;
            mergedProperties.put(entry.getKey(), entry.getValue());
        }
        return mergedProperties;
    }
}

