/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.packaging.toolkit.manifest;

import com.ibm.team.enterprise.automation.manifest.Container;
import com.ibm.team.enterprise.automation.manifest.Manifest;
import com.ibm.team.enterprise.automation.manifest.Resource;
import com.ibm.team.enterprise.packaging.toolkit.manifest.AbstractManifestMerger;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.Project;

public class ManifestAdditiveMerger
extends AbstractManifestMerger {
    public ManifestAdditiveMerger(Project project, String inputFileName, String inputPropertiesFileName, String outputFileName, String outputCodePage) {
        super(project, inputFileName, inputPropertiesFileName, outputFileName, outputCodePage);
        this.execute();
    }

    @Override
    protected Manifest mergeManifest(Manifest primaryInputManifest, Manifest secondaryInputManifest) {
        Manifest outputManifest = new Manifest();
        outputManifest.setType("MANIFEST_SHIPLIST");
        List primaryInputContainers = primaryInputManifest.getContainers();
        List secondaryInputContainers = secondaryInputManifest.getContainers();
        this.mergeContainers(primaryInputContainers, secondaryInputContainers, outputManifest, false);
        List primaryDeletedContainers = primaryInputManifest.getDeletedContainers();
        List secondaryDeletedContainers = secondaryInputManifest.getDeletedContainers();
        this.mergeContainers(primaryDeletedContainers, secondaryDeletedContainers, outputManifest, true);
        return outputManifest;
    }

    private void mergeContainers(List<Container> primaryInputContainers, List<Container> secondaryInputContainers, Manifest outputManifest, boolean isDeleted) {
        Iterator resourceIterator;
        Container outputContainer;
        for (Container container : primaryInputContainers) {
            outputContainer = new Container(container);
            resourceIterator = outputContainer.getResourcesIterator();
            while (resourceIterator.hasNext()) {
                Resource outputResource = (Resource)resourceIterator.next();
                if (!outputResource.getName().contains("*")) continue;
                outputContainer.removeResource(outputResource);
            }
            if (!outputContainer.hasResources() || outputContainer.getType() == "sequential") continue;
            if (isDeleted) {
                outputManifest.addDeletedContainer(outputContainer);
                continue;
            }
            outputManifest.addContainer(outputContainer);
        }
        for (Container container : secondaryInputContainers) {
            outputContainer = this.findEquivalentContainer(container, outputManifest, isDeleted);
            if (outputContainer == null) {
                outputContainer = new Container(container);
                if (isDeleted) {
                    outputManifest.addDeletedContainer(container);
                    continue;
                }
                outputManifest.addContainer(outputContainer);
                continue;
            }
            resourceIterator = container.getResourcesIterator();
            while (resourceIterator.hasNext()) {
                Resource secondaryInputResource = (Resource)resourceIterator.next();
                Resource matchingResource = this.findExactMatch(outputManifest, outputContainer, secondaryInputResource, isDeleted);
                if (matchingResource != null) continue;
                outputContainer.addResourceWithProperties(secondaryInputResource);
            }
        }
    }
}

