/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.packaging.toolkit.manifest;

import com.ibm.team.enterprise.packaging.toolkit.manifest.Messages;
import com.ibm.team.scm.common.internal.util.XMLUtil;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class ConvertToPDSMemberList {
    private final String ROOT_MARKUP = "file";
    private final String PDS_MARKUP = "sourcePDS";
    private final String PDSMEMBER_MARKUP = "sourceMember";
    private final String RESOURCE_SEPARATOR = ".";
    private final String ASTERIX_CHAR = "*";
    public List<String> listOfMembers = new ArrayList<String>();

    public ConvertToPDSMemberList(File packageShipList) {
        if (packageShipList.exists() && packageShipList.canRead()) {
            try {
                FileInputStream fstream = new FileInputStream(packageShipList);
                DataInputStream in = new DataInputStream(fstream);
                boolean hasPDSMarkup = false;
                try (BufferedReader br = new BufferedReader(new InputStreamReader(in));){
                    String strLine;
                    DocumentBuilderFactory docBldrFactory = XMLUtil.getSecureDocumentBuilderFactory();
                    docBldrFactory.setIgnoringElementContentWhitespace(true);
                    docBldrFactory.setCoalescing(true);
                    docBldrFactory.setIgnoringComments(true);
                    DocumentBuilder docBldr = docBldrFactory.newDocumentBuilder();
                    while ((strLine = br.readLine()) != null) {
                        if (strLine.contains("file")) continue;
                        String currentPDSName = "";
                        String currentPDSMemberName = "";
                        InputSource is = new InputSource(new StringReader(strLine));
                        Document doc = docBldr.parse(is);
                        Element element = doc.getDocumentElement();
                        String tag = element.getNodeName();
                        if (tag.equals("sourcePDS")) {
                            hasPDSMarkup = true;
                            currentPDSName = element.getTextContent();
                            continue;
                        }
                        if (tag.equals("sourceMember")) {
                            String member;
                            if (!hasPDSMarkup) {
                                System.err.println(Messages.ConvertToPDSMemberList_INVALID_SHIP_LIST_MISSING_REF_TO_PDS_ERROR_MSG);
                                continue;
                            }
                            if (currentPDSMemberName.equals("*") || this.listOfMembers.contains(member = this.getFullPDSMemberName(currentPDSName, currentPDSMemberName))) continue;
                            this.listOfMembers.add(member);
                            continue;
                        }
                        System.err.println(Messages.ConvertToPDSMemberList_INVALID_TAG_IN_SHIP_LIST_FILE_ERROR_MSG);
                    }
                    in.close();
                }
            }
            catch (Exception e) {
                System.err.println(NLS.bind((String)Messages.ConvertToPDSMemberList_ERROR_CONVERTING_TO_PDS_ERROR_MSG, (Object)e.getMessage()));
                e.printStackTrace();
            }
        } else {
            System.err.println(Messages.ConvertToPDSMemberList_CANNOT_READ_SHIP_LIST_FILE_ERROR_MSG);
        }
    }

    private String getFullPDSMemberName(String pdsName, String memberName) {
        return String.valueOf(pdsName) + "." + memberName;
    }
}

