/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.packaging.toolkit.manifest;

import com.ibm.team.enterprise.automation.manifest.BuildMapInputGroup;
import com.ibm.team.enterprise.automation.manifest.Container;
import com.ibm.team.enterprise.automation.manifest.Input;
import com.ibm.team.enterprise.automation.manifest.Manifest;
import com.ibm.team.enterprise.automation.manifest.ManifestReader;
import com.ibm.team.enterprise.automation.manifest.ManifestWriter;
import com.ibm.team.enterprise.automation.manifest.Resource;
import com.ibm.team.enterprise.packaging.toolkit.manifest.Messages;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractManifestMerger {
    protected String primaryInputFileName;
    protected String secondaryInputFileName;
    protected String outputFileName;
    protected String outputCodepage;
    protected Project antProject;
    protected boolean MERGE_DEBUG = false;

    public Project getAntProject() {
        return this.antProject;
    }

    public void setAntProject(Project antProject) {
        this.antProject = antProject;
    }

    public AbstractManifestMerger(Project project, String inputFileName, String inputPropertiesFileName, String outputFileName, String outputCodePage) {
        this.setPrimaryInputFileName(inputFileName);
        this.setSecondaryInputFileName(inputPropertiesFileName);
        this.setOutputFileName(outputFileName);
        this.setOutputCodepage(this.outputCodepage);
        this.setAntProject(project);
    }

    public String getOutputCodepage() {
        return this.outputCodepage;
    }

    public void setOutputCodepage(String outputCodepage) {
        this.outputCodepage = outputCodepage;
    }

    public String getSecondaryInputFileName() {
        return this.secondaryInputFileName;
    }

    public void setSecondaryInputFileName(String inputPropertiesFileName) {
        this.secondaryInputFileName = inputPropertiesFileName;
    }

    public String getPrimaryInputFileName() {
        return this.primaryInputFileName;
    }

    public void setPrimaryInputFileName(String fileName) {
        this.primaryInputFileName = fileName;
    }

    public String getOutputFileName() {
        return this.outputFileName;
    }

    public void setOutputFileName(String fileName) {
        this.outputFileName = fileName;
    }

    public void execute() throws BuildException {
        String debugManifest = this.antProject.getProperty("team.package.common.debugManifestMerge");
        if (debugManifest != null && !debugManifest.isEmpty()) {
            this.MERGE_DEBUG = true;
        }
        if (this.primaryInputFileName == null || this.outputFileName == null || this.secondaryInputFileName == null || this.primaryInputFileName.trim().isEmpty() || this.outputFileName.trim().isEmpty() || this.secondaryInputFileName.trim().isEmpty()) {
            throw new BuildException(Messages.ManifestPropertyMerger_INVALID_MANIFEST_FILENAME);
        }
        File primaryInputFile = new File(this.primaryInputFileName);
        if (primaryInputFile.exists()) {
            File outputFile = new File(this.outputFileName);
            Manifest primaryInputManifest = this.getManifest(primaryInputFile);
            this.logManifest(primaryInputManifest, "===PrimaryInputManifest: " + this.primaryInputFileName + " ===");
            Manifest secondaryInputManifest = null;
            File secondaryInputFile = new File(this.secondaryInputFileName);
            if (secondaryInputFile.exists()) {
                secondaryInputManifest = this.getManifest(secondaryInputFile);
                this.logManifest(secondaryInputManifest, "===secondaryInputManifest: " + this.secondaryInputFileName + " ===");
            }
            Manifest outputManifest = this.mergeManifest(primaryInputManifest, secondaryInputManifest);
            this.logManifest(outputManifest, "===OutputManifest: " + this.outputFileName + " ===");
            try {
                ManifestWriter.getInstance().write(outputFile, this.getCodepage(), outputManifest);
            }
            catch (Exception e) {
                throw new BuildException(NLS.bind((String)Messages.ManifestPropertyMerger_WRITING_PROPERTY_MANIFEST_ERROR_MSG, (Object)this.outputFileName));
            }
        }
    }

    protected abstract Manifest mergeManifest(Manifest var1, Manifest var2);

    protected Container findEquivalentContainer(Container container, Manifest manifest, boolean isDeleted) {
        if (isDeleted) {
            return this.findEquivalentDeletedContainer(container, manifest);
        }
        return this.findEquivalentContainer(container, manifest);
    }

    protected Container findEquivalentContainer(Container container, Manifest manifest) {
        List containers = manifest.getContainers();
        return this.findEquivalentContainer(container, containers);
    }

    protected Container findEquivalentDeletedContainer(Container container, Manifest manifest) {
        List deletedContainers = manifest.getDeletedContainers();
        return this.findEquivalentContainer(container, deletedContainers);
    }

    protected Container findEquivalentContainer(Container container, List<Container> containers) {
        for (Container secondaryContainer : containers) {
            if (!secondaryContainer.getName().equals(container.getName()) || !secondaryContainer.getType().equals(container.getType())) continue;
            return secondaryContainer;
        }
        return null;
    }

    protected Resource findExactMatch(Manifest manifest, Container container, Resource resource, boolean isDeleted) {
        if (isDeleted) {
            return this.findExactDeletedMatch(manifest, container, resource);
        }
        return this.findExactMatch(manifest, container, resource);
    }

    protected Resource findExactMatch(Manifest manifest, Container container, Resource resource) {
        List manifestContainers = manifest.getContainers();
        return this.findExactMatch(manifestContainers, container, resource);
    }

    protected Resource findExactDeletedMatch(Manifest manifest, Container container, Resource resource) {
        List manifestContainers = manifest.getDeletedContainers();
        return this.findExactMatch(manifestContainers, container, resource);
    }

    protected Resource findExactMatch(List<Container> manifestContainers, Container container, Resource resource) {
        for (Container manifestContainer : manifestContainers) {
            if (!container.getName().equals(manifestContainer.getName())) continue;
            Iterator resourceIterator = manifestContainer.getResourcesIterator();
            while (resourceIterator.hasNext()) {
                Resource manifestResource = (Resource)resourceIterator.next();
                if (!manifestResource.getName().equals(resource.getName())) continue;
                return manifestResource;
            }
        }
        return null;
    }

    protected void debugLog(String message) {
        this.antProject.log(message);
    }

    private void logManifest(Manifest manifest, String title) {
        if (!this.MERGE_DEBUG) {
            return;
        }
        List containers = manifest.getContainers();
        this.debugLog("*********************************************");
        this.debugLog(title);
        this.debugLog("*********************************************");
        for (Container container : containers) {
            this.debugLog("+ Container: " + container.getName());
            BuildMapInputGroup containerBuildMapInputGroup = container.getBuildMapInputGroup();
            if (containerBuildMapInputGroup == null) {
                this.debugLog("+  Container Buildmap inputs: NONE");
            } else {
                this.debugLog("+  Container Buildmap inputs: BuildMap URL " + containerBuildMapInputGroup.getUrl());
                List inputs = containerBuildMapInputGroup.getInputs();
                if (inputs != null) {
                    for (Input input : inputs) {
                        this.debugLog("+   Input:" + input.getName());
                    }
                }
            }
            Map containerProperties = container.getProperties();
            for (Map.Entry entry : containerProperties.entrySet()) {
                this.debugLog("++ Container Property: " + (String)entry.getKey() + "=" + (String)entry.getValue());
            }
            Iterator resourceIterator = container.getResourcesIterator();
            while (resourceIterator.hasNext()) {
                Resource resource = (Resource)resourceIterator.next();
                if (resource.getIbmiType() == null || resource.getIbmiType().isEmpty()) {
                    this.debugLog("+++ Resource: " + resource.getName() + " Type: " + resource.getType());
                } else {
                    this.debugLog("+++ Resource: " + resource.getName() + " Type: " + resource.getType() + " IBMiType: " + resource.getIbmiType());
                }
                BuildMapInputGroup resourceBuildMapInputGroup = resource.getBuildMapInputGroup();
                if (containerBuildMapInputGroup == null) {
                    this.debugLog("++++ Resource Buildmap inputs: NONE");
                } else {
                    this.debugLog("+  Resource Buildmap inputs: BuildMap URL " + resourceBuildMapInputGroup.getUrl());
                    List inputs = resourceBuildMapInputGroup.getInputs();
                    if (inputs != null) {
                        for (Input input : inputs) {
                            this.debugLog("+   Input:" + input.getName());
                        }
                    }
                }
                Map resourceProperties = resource.getProperties();
                for (Map.Entry entry : resourceProperties.entrySet()) {
                    this.debugLog("++++ Resource Property: " + (String)entry.getKey() + "=" + (String)entry.getValue());
                }
            }
            this.debugLog("*********************************************");
        }
    }

    private String getCodepage() {
        if (this.getOutputCodepage() == null || this.getOutputCodepage().trim().isEmpty()) {
            return "UTF-8";
        }
        return this.getOutputCodepage();
    }

    protected Manifest getManifest(File manifestFile) throws BuildException {
        try {
            return ManifestReader.getInstance().getManifest(manifestFile);
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }
}

