/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.packaging.toolkit;

import com.ibm.team.enterprise.automation.common.helper.ShipListFileNameHelper;
import com.ibm.team.enterprise.packaging.toolkit.Messages;
import java.io.File;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;

public class PackageCleanupListener
implements BuildListener {
    public void buildStarted(BuildEvent event) {
    }

    public void buildFinished(BuildEvent event) {
        Project proj = event.getProject();
        String packageRootDir = proj.getProperty("team.package.common.packageRoot.dir");
        String packageDefUUID = proj.getProperty("team.deploy.packageDefinitionUUID");
        String isConcurrentSafeProperty = proj.getProperty("team.package.common.isConcurrentSafe");
        boolean isConcurrentSafe = false;
        if (isConcurrentSafeProperty != null && isConcurrentSafeProperty.equals("true")) {
            isConcurrentSafe = true;
        }
        String packageLabel = proj.getProperty("buildLabel");
        String wiShiplist = ShipListFileNameHelper.constructShiplistName((ShipListFileNameHelper.Type)ShipListFileNameHelper.Type.WORKITEM, (ShipListFileNameHelper.Phase)ShipListFileNameHelper.Phase.AGENT_INIT, (boolean)isConcurrentSafe, (String)packageRootDir, (String)packageDefUUID, (String)packageLabel);
        String includeShipList = ShipListFileNameHelper.constructShiplistName((ShipListFileNameHelper.Type)ShipListFileNameHelper.Type.INCLUDE, (ShipListFileNameHelper.Phase)ShipListFileNameHelper.Phase.AGENT_INIT, (boolean)isConcurrentSafe, (String)packageRootDir, (String)packageDefUUID, (String)packageLabel);
        String excludeShipList = ShipListFileNameHelper.constructShiplistName((ShipListFileNameHelper.Type)ShipListFileNameHelper.Type.INCLUDE, (ShipListFileNameHelper.Phase)ShipListFileNameHelper.Phase.AGENT_INIT, (boolean)isConcurrentSafe, (String)packageRootDir, (String)packageDefUUID, (String)packageLabel);
        String restoreMapping = ShipListFileNameHelper.constructShiplistName((ShipListFileNameHelper.Type)ShipListFileNameHelper.Type.INCLUDE, (ShipListFileNameHelper.Phase)ShipListFileNameHelper.Phase.AGENT_INIT, (boolean)isConcurrentSafe, (String)packageRootDir, (String)packageDefUUID, (String)packageLabel);
        File file = new File(wiShiplist);
        if (file.exists()) {
            proj.log(Messages.PackageCleanupListener_CLEANING_UP_WORK_ITEM_SHIPLIST_LOG_MSG);
            file.delete();
        }
        if ((file = new File(includeShipList)).exists()) {
            proj.log(Messages.PackageCleanupListener_CLEANING_UP_INCLUDE_SHIP_LIST_FILE_LOG_MSG);
            file.delete();
        }
        if ((file = new File(excludeShipList)).exists()) {
            proj.log(Messages.PackageCleanupListener_CLEANING_UP_EXCLUDE_SHIP_LIST_FILE_LOG_MSG);
            file.delete();
        }
        if ((file = new File(restoreMapping)).exists()) {
            proj.log(Messages.PackageCleanupListener_CLEANING_UP_RESTORE_MAPPING_FILE_LOG_MSG);
            file.delete();
        }
        if (event.getException() != null) {
            File packageDir;
            String packageLocation = proj.getProperty("team.package.common.package.dir");
            proj.log("package.dir = " + packageLocation);
            if (packageLocation != null && packageLocation.trim().length() > 0 && (packageDir = new File(packageLocation)).exists()) {
                proj.log(Messages.PackageCleanupListener_CLEANING_UP_PACKAGE_DIR_LOG_MSG);
                this.recursiveDelete(packageDir);
            }
        }
    }

    protected void recursiveDelete(File file) {
        if (file.isDirectory()) {
            File[] files;
            File[] fileArray = files = file.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File childFile = fileArray[n2];
                this.recursiveDelete(childFile);
                ++n2;
            }
        }
        file.delete();
    }

    public void targetStarted(BuildEvent event) {
    }

    public void targetFinished(BuildEvent event) {
    }

    public void taskStarted(BuildEvent event) {
    }

    public void taskFinished(BuildEvent event) {
    }

    public void messageLogged(BuildEvent event) {
    }
}

