/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.packaging.taskdefs;

import com.ibm.team.build.ant.task.AbstractTeamBuildTask;
import com.ibm.team.enterprise.automation.common.util.PropertyParser;
import com.ibm.team.enterprise.build.client.packaging.IPackagingClient;
import com.ibm.team.enterprise.packaging.taskdefs.Messages;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import java.util.LinkedList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.eclipse.osgi.util.NLS;

public class RetrieveChildrenWorkItemsTask
extends AbstractTeamBuildTask {
    public static final String TASK_NAME = "RetrieveChildrenWorkItemsTask";
    public static final String PARENT_WORKITEMS_ATTRIBUTE = "parentWorkItems";
    public static final String PARENT_WORKITEM_UUIDS_ATTRIBUTE = "parentWorkItemUUIDs";
    public static final String OUTPUT_WORKITEMS_PROPERTY_NAME = "outputWorkItemsProperty";
    public static final String OUTPUT_WORKITEM_UUIDS_PROPERTY_NAME = "outputWorkItemUUIDsProperty";
    String fParentWorkItems = null;
    String fParentWorkItemUUIDs = null;
    String fOutputWorkItemsProperty = null;
    String fOutputWorkItemUUIDsProperty = null;
    String fOutputWorkItemsPropertyValue = null;
    String fOutputWorkItemUUIDsPropertyValue = null;

    protected void collectAntAttributes(List antAttributes) {
        antAttributes.add(new AbstractTeamBuildTask.AntAttribute(PARENT_WORKITEMS_ATTRIBUTE, this.fParentWorkItems, false));
        antAttributes.add(new AbstractTeamBuildTask.AntAttribute(PARENT_WORKITEM_UUIDS_ATTRIBUTE, this.fParentWorkItemUUIDs, false));
        antAttributes.add(new AbstractTeamBuildTask.AntAttribute(OUTPUT_WORKITEMS_PROPERTY_NAME, this.fOutputWorkItemsProperty, false));
        antAttributes.add(new AbstractTeamBuildTask.AntAttribute(OUTPUT_WORKITEM_UUIDS_PROPERTY_NAME, this.fOutputWorkItemUUIDsProperty, false));
    }

    protected void doExecute() throws Exception {
        this.validateAttributes();
        IWorkItemHandle[] parentWorkItemHandles = this.getWorkItemHandles(this.fParentWorkItems, this.fParentWorkItemUUIDs);
        IPackagingClient packagingClient = (IPackagingClient)this.getTeamRepository().getClientLibrary(IPackagingClient.class);
        this.fOutputWorkItemUUIDsPropertyValue = packagingClient.getChildrenWorkItems(parentWorkItemHandles);
        if (this.fOutputWorkItemUUIDsPropertyValue.isEmpty()) {
            if (this.fParentWorkItemUUIDs != null) {
                throw new BuildException(NLS.bind((String)Messages.RequestPackagingBuildTask_INVALID_ATTRIBUTE_WITH_VALUE, (Object[])new Object[]{TASK_NAME, PARENT_WORKITEM_UUIDS_ATTRIBUTE, this.fParentWorkItemUUIDs}));
            }
            throw new BuildException(NLS.bind((String)Messages.RequestPackagingBuildTask_INVALID_ATTRIBUTE_WITH_VALUE, (Object[])new Object[]{TASK_NAME, PARENT_WORKITEMS_ATTRIBUTE, this.fParentWorkItems}));
        }
        if (this.fOutputWorkItemUUIDsProperty != null) {
            this.setOutputWorkItemUUIDsPropertyValue();
        }
        if (this.fOutputWorkItemsProperty != null) {
            this.setOutputWorkItemsPropertyValue();
        }
    }

    private void validateAttributes() {
        if (this.fParentWorkItems == null && this.fParentWorkItemUUIDs == null) {
            throw new BuildException(NLS.bind((String)Messages.RequestPackagingBuildTask_MUST_SPECIFY_ATTRIBUTE_A_OR_B, (Object[])new Object[]{TASK_NAME, PARENT_WORKITEMS_ATTRIBUTE, PARENT_WORKITEM_UUIDS_ATTRIBUTE}));
        }
        if (this.fParentWorkItems != null && this.fParentWorkItemUUIDs != null) {
            throw new BuildException(NLS.bind((String)Messages.RequestPackagingBuildTask_CONFLICTING_TASK_ATTRIBUTES, (Object[])new Object[]{TASK_NAME, PARENT_WORKITEMS_ATTRIBUTE, PARENT_WORKITEM_UUIDS_ATTRIBUTE}));
        }
        if (this.fOutputWorkItemsProperty == null && this.fOutputWorkItemUUIDsProperty == null) {
            throw new BuildException(NLS.bind((String)Messages.RequestPackagingBuildTask_MUST_SPECIFY_ATTRIBUTE_A_OR_B, (Object[])new Object[]{TASK_NAME, OUTPUT_WORKITEMS_PROPERTY_NAME, OUTPUT_WORKITEM_UUIDS_PROPERTY_NAME}));
        }
        if (this.fParentWorkItems != null && !PropertyParser.isValidIntList((String)this.fParentWorkItems)) {
            throw new BuildException(NLS.bind((String)Messages.RequestPackagingBuildTask_INVALID_ATTRIBUTE_WITH_VALUE, (Object[])new Object[]{TASK_NAME, PARENT_WORKITEMS_ATTRIBUTE, this.fParentWorkItems}));
        }
    }

    IWorkItemHandle[] getWorkItemHandles(String parentWorkItems, String parentWorkItemUUIDs) {
        IWorkItemHandle[] workItemHandles = null;
        if (parentWorkItemUUIDs != null) {
            workItemHandles = PropertyParser.toWorkItemHandles((String)parentWorkItemUUIDs);
            if (workItemHandles == null) {
                throw new BuildException(NLS.bind((String)Messages.RequestPackagingBuildTask_INVALID_ATTRIBUTE_WITH_VALUE, (Object[])new Object[]{TASK_NAME, PARENT_WORKITEM_UUIDS_ATTRIBUTE, this.fParentWorkItemUUIDs}));
            }
        } else {
            List parentWorkItemNumbers = PropertyParser.toWorkItemNumbers((String)parentWorkItems);
            List workItemHandleList = null;
            try {
                IWorkItemClient workItemClient = (IWorkItemClient)this.getTeamRepository().getClientLibrary(IWorkItemClient.class);
                workItemHandleList = workItemClient.findWorkItemsById(parentWorkItemNumbers, this.getProgressMonitor());
                workItemHandles = workItemHandleList.toArray(new IWorkItemHandle[workItemHandleList.size()]);
            }
            catch (TeamRepositoryException e) {
                throw new BuildException(NLS.bind((String)Messages.RequestPackagingBuildTask_INVALID_ATTRIBUTE_WITH_VALUE, (Object[])new Object[]{TASK_NAME, PARENT_WORKITEMS_ATTRIBUTE, this.fParentWorkItems}), (Throwable)e);
            }
        }
        return workItemHandles;
    }

    private void setOutputWorkItemUUIDsPropertyValue() {
        this.getProject().setProperty(this.fOutputWorkItemUUIDsProperty, this.fOutputWorkItemUUIDsPropertyValue);
    }

    private void setOutputWorkItemsPropertyValue() throws Exception {
        IWorkItemClient workItemClient;
        IWorkItemHandle[] workItemHandles = PropertyParser.toWorkItemHandles((String)this.fOutputWorkItemUUIDsPropertyValue);
        LinkedList<Integer> workItemNumbers = new LinkedList<Integer>();
        try {
            workItemClient = (IWorkItemClient)this.getTeamRepository().getClientLibrary(IWorkItemClient.class);
        }
        catch (TeamRepositoryException e) {
            this.log("Workitem id could not be retrieved", e, 0);
            throw e;
        }
        IWorkItemHandle[] iWorkItemHandleArray = workItemHandles;
        int n = workItemHandles.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkItemHandle wiHandle = iWorkItemHandleArray[n2];
            IWorkItem workItem = null;
            try {
                workItem = (IWorkItem)workItemClient.getAuditableCommon().resolveAuditable((IAuditableHandle)wiHandle, IWorkItem.SMALL_PROFILE, null);
            }
            catch (TeamRepositoryException e) {
                this.log("Workitem id could not be retrieved", e, 0);
                throw e;
            }
            workItemNumbers.add(workItem.getId());
            ++n2;
        }
        this.fOutputWorkItemsPropertyValue = PropertyParser.intsToString(workItemNumbers);
        this.getProject().setProperty(this.fOutputWorkItemsProperty, this.fOutputWorkItemsPropertyValue);
    }

    public String getParentWorkItems() {
        return this.fParentWorkItems;
    }

    public void setParentWorkItems(String parentWorkItems) {
        this.fParentWorkItems = parentWorkItems;
    }

    public String getParentWorkItemUUIDs() {
        return this.fParentWorkItemUUIDs;
    }

    public void setParentWorkItemUUIDs(String parentWorkItemUUIDs) {
        this.fParentWorkItemUUIDs = parentWorkItemUUIDs;
    }

    public String getOutputWorkItemsProperty() {
        return this.fOutputWorkItemsProperty;
    }

    public void setOutputWorkItemsProperty(String outputWorkItemsProperty) {
        this.fOutputWorkItemsProperty = outputWorkItemsProperty;
    }

    public String getOutputWorkItemUUIDsProperty() {
        return this.fOutputWorkItemUUIDsProperty;
    }

    public void setOutputWorkItemUUIDsProperty(String outputWorkItemUUIDsProperty) {
        this.fOutputWorkItemUUIDsProperty = outputWorkItemUUIDsProperty;
    }
}

