/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.packaging.taskdefs;

import com.ibm.team.build.ant.task.AbstractTeamBuildTask;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.enterprise.automation.common.util.PropertyParser;
import com.ibm.team.enterprise.automation.taskdefs.AbstractRequestBuildTask;
import com.ibm.team.enterprise.packaging.taskdefs.Messages;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import java.util.HashMap;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.eclipse.osgi.util.NLS;

public final class RequestPackagingBuildTask
extends AbstractRequestBuildTask {
    public static final String TASK_NAME = "RequestPackagingBuildTask";
    public static final String PACKAGE_DEFINITION_UUID_PROPERTY = "team.deploy.packageDefinitionUUID";
    public static final String PACKAGE_TYPE_ATTRIBUTE = "packageType";
    public static final String PACKAGE_TYPE_SHIPLIST_VALUE = "shiplist";
    public static final String PACKAGE_TYPE_WORKITEM_VALUE = "workitem";
    public static final String PACKAGE_TYPE_WORKITEM_PROPERTY = "team.package.common.workitem.option";
    public static final String PACKAGE_WORKITEMS_UUID_ATTRIBUTE = "packageWorkItemUUIDs";
    public static final String PACKAGE_WORKITEMS_STRING_ATTRIBUTE = "packageWorkItems";
    public static final String PACKAGE_WORKITEMS_IMPACTED_ATTRIBUTE = "packageImpacted";
    public static final String PACKAGE_WORKITEMS_IMPACTED_PROPERTY = "team.enterprise.packaging.includeImpactedObjects";
    public static final String PACKAGE_CHILDREN_WORKITEMS_ATTRIBUTE = "packageChildrenWorkitems";
    public static final String PACKAGE_CHILDREN_WORKITEMS_PROPERTY = "team.package.common.includeChildrenWorkitem";
    public static final String PACKAGE_WORKITEMS_UUID_PROPERTY = "team.enterprise.packaging.packagedWorkitems";
    public static final String PACKAGE_TIMESTAMP_ATTRIBUTE = "timestamp";
    public static final String PACKAGE_TIMESTAMP_PROPERTY = "team.package.common.packageBinariesSinceTimestamp";
    public static final String PACKAGE_WORKITEMS_GENERATE_EMPTY_SHIPLIST = "team.package.common.generate.empty.workitem.shiplist";
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    public static final String SEPARATOR = ";";
    private String fPackageDefinitionUUID = null;
    private String fPackageType = null;
    private String fPackageWorkItemString = null;
    private String fPackageWorkItemUUIDs = null;
    private String fTimestamp = null;
    private boolean fPackageTypeWorkitems = false;
    private boolean fPackageImpacted = true;
    private boolean fPackageChildrenWorkItems = false;

    protected void collectAntAttributes(List antAttributes) {
        super.collectAntAttributes(antAttributes);
        antAttributes.add(new AbstractTeamBuildTask.AntAttribute(PACKAGE_TYPE_ATTRIBUTE, this.fPackageType, false));
        antAttributes.add(new AbstractTeamBuildTask.AntAttribute(PACKAGE_TIMESTAMP_ATTRIBUTE, this.fTimestamp, false));
        antAttributes.add(new AbstractTeamBuildTask.AntAttribute(PACKAGE_WORKITEMS_UUID_ATTRIBUTE, this.fPackageWorkItemUUIDs, false));
        antAttributes.add(new AbstractTeamBuildTask.BooleanAntAttribute(PACKAGE_WORKITEMS_IMPACTED_ATTRIBUTE, this.fPackageImpacted, false));
        antAttributes.add(new AbstractTeamBuildTask.BooleanAntAttribute(PACKAGE_CHILDREN_WORKITEMS_ATTRIBUTE, this.fPackageChildrenWorkItems, false));
    }

    protected HashMap<String, String> getExtendedProperties() throws Exception {
        this.findRequiredPropertyValues();
        HashMap<String, String> antProperties = new HashMap<String, String>();
        antProperties.put(PACKAGE_DEFINITION_UUID_PROPERTY, this.fPackageDefinitionUUID);
        antProperties.put(PACKAGE_TYPE_WORKITEM_PROPERTY, TRUE);
        if (this.fTimestamp != null) {
            antProperties.put(PACKAGE_TIMESTAMP_PROPERTY, this.fTimestamp);
        }
        if (this.fPackageWorkItemUUIDs != null) {
            antProperties.put(PACKAGE_WORKITEMS_UUID_PROPERTY, this.fPackageWorkItemUUIDs);
            antProperties.put(PACKAGE_WORKITEMS_GENERATE_EMPTY_SHIPLIST, FALSE);
            antProperties.put(PACKAGE_WORKITEMS_IMPACTED_PROPERTY, this.fPackageImpacted ? TRUE : FALSE);
        }
        return antProperties;
    }

    protected void findRequiredPropertyValues() throws Exception {
        IBuildDefinition buildDefinition = this.getBuildDefinition(this.getBuildDefinitionId());
        this.fPackageDefinitionUUID = buildDefinition.getItemId().getUuidValue();
        this.validatePackageType();
        if (this.fPackageTypeWorkitems) {
            this.findWorkItemUUIDs();
        }
        this.fTimestamp = this.validateTimestamp(this.fTimestamp);
    }

    private void validatePackageType() {
        if (PACKAGE_TYPE_WORKITEM_VALUE.equalsIgnoreCase(this.fPackageType)) {
            this.fPackageTypeWorkitems = true;
        } else {
            if (this.fPackageWorkItemUUIDs != null) {
                throw new BuildException(NLS.bind((String)Messages.RequestPackagingBuildTask_CONFLICTING_TASK_ATTRIBUTES, (Object[])new Object[]{TASK_NAME, PACKAGE_TYPE_ATTRIBUTE, PACKAGE_WORKITEMS_UUID_ATTRIBUTE}));
            }
            if (this.fPackageWorkItemString != null) {
                throw new BuildException(NLS.bind((String)Messages.RequestPackagingBuildTask_CONFLICTING_TASK_ATTRIBUTES, (Object[])new Object[]{TASK_NAME, PACKAGE_TYPE_ATTRIBUTE, PACKAGE_WORKITEMS_STRING_ATTRIBUTE}));
            }
            this.fPackageTypeWorkitems = false;
        }
    }

    private void findWorkItemUUIDs() throws BuildException {
        if (this.fPackageWorkItemUUIDs != null) {
            if (this.fPackageWorkItemString != null) {
                throw new BuildException(NLS.bind((String)Messages.RequestPackagingBuildTask_CONFLICTING_TASK_ATTRIBUTES, (Object[])new Object[]{TASK_NAME, PACKAGE_WORKITEMS_UUID_ATTRIBUTE, PACKAGE_WORKITEMS_STRING_ATTRIBUTE}));
            }
        } else {
            List workItemHandles;
            if (this.fPackageWorkItemString == null) {
                throw new BuildException(NLS.bind((String)Messages.RequestPackagingBuildTask_INVALID_PACKAGING_PROPERTY, (Object)PACKAGE_WORKITEMS_STRING_ATTRIBUTE));
            }
            if (!PropertyParser.isValidIntList((String)this.fPackageWorkItemString)) {
                throw new BuildException(NLS.bind((String)Messages.RequestPackagingBuildTask_INVALID_ATTRIBUTE_WITH_VALUE, (Object[])new Object[]{TASK_NAME, PACKAGE_WORKITEMS_STRING_ATTRIBUTE, this.fPackageWorkItemString}));
            }
            List workItemList = PropertyParser.toWorkItemNumbers((String)this.fPackageWorkItemString);
            try {
                IWorkItemClient workItemClient = (IWorkItemClient)this.getTeamRepository().getClientLibrary(IWorkItemClient.class);
                workItemHandles = workItemClient.findWorkItemsById(workItemList, this.getProgressMonitor());
            }
            catch (TeamRepositoryException e) {
                throw new BuildException(NLS.bind((String)Messages.RequestPackagingBuildTask_INVALID_ATTRIBUTE_WITH_VALUE, (Object[])new Object[]{TASK_NAME, PACKAGE_WORKITEMS_STRING_ATTRIBUTE, this.fPackageWorkItemString}), (Throwable)e);
            }
            this.fPackageWorkItemUUIDs = RequestPackagingBuildTask.convertUuidListToString(workItemHandles);
        }
    }

    private static String convertUuidListToString(List<IWorkItemHandle> handles) {
        StringBuffer aString = new StringBuffer();
        for (IItemHandle iItemHandle : handles) {
            if (aString.length() > 0) {
                aString.append(SEPARATOR);
            }
            aString.append(iItemHandle.getItemId().getUuidValue());
        }
        return aString.toString();
    }

    public void setBuildDefinitionId(String buildDefinitionId) {
        super.setBuildDefinitionId(buildDefinitionId);
    }

    public void setPackageType(String packageType) {
        this.fPackageType = packageType;
    }

    public String getPackageType(String packageType) {
        return this.fPackageType;
    }

    public void setPackageWorkItemUUIDs(String packageWorkItemUUIDs) {
        this.fPackageWorkItemUUIDs = packageWorkItemUUIDs;
    }

    public String getPackageWorkItemUUIDs() {
        return this.fPackageWorkItemUUIDs;
    }

    public void setPackageWorkItems(String packageWorkItems) {
        this.fPackageWorkItemString = packageWorkItems;
    }

    public void setTimestamp(String timestamp) {
        this.fTimestamp = timestamp;
    }

    public String getTimestamp() {
        return this.fTimestamp;
    }

    public void setPackageImpacted(boolean packageImpacted) {
        this.fPackageImpacted = packageImpacted;
    }

    public void setPackageChildrenWorkitems(boolean packageChildren) {
        this.fPackageChildrenWorkItems = packageChildren;
    }

    public String validateTimestamp(String ts) throws BuildException {
        if (ts != null) {
            String timestamp = ts.trim();
            if (timestamp.length() == 0) {
                return null;
            }
            if (timestamp.length() == 19 && this.isNumeric(timestamp.substring(0, 8)) && timestamp.indexOf("-") == 8 && this.isNumeric(timestamp.substring(9, 19))) {
                return timestamp;
            }
            Project proj = this.getProject();
            proj.log("timestamp: " + timestamp);
            throw new BuildException(NLS.bind((String)Messages.RequestPackagingBuildTask_INVALID_PACKAGING_PROPERTY, (Object)PACKAGE_TIMESTAMP_ATTRIBUTE));
        }
        return null;
    }

    public boolean isNumeric(String s) {
        try {
            Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }
}

