/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.packaging.taskdefs;

import com.ibm.team.build.client.ClientFactory;
import com.ibm.team.build.common.BuildItemFactory;
import com.ibm.team.build.common.model.IBuildEngine;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultContribution;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.enterprise.automation.common.resultcontributions.AutomationResultContribution;
import com.ibm.team.enterprise.automation.manifest.Container;
import com.ibm.team.enterprise.automation.manifest.Manifest;
import com.ibm.team.enterprise.automation.manifest.ManifestReader;
import com.ibm.team.enterprise.automation.manifest.Resource;
import com.ibm.team.enterprise.automation.taskdefs.AbstractAutomationPublisherTask;
import com.ibm.team.enterprise.automation.taskdefs.WorkItemAutomationPublisherTask;
import com.ibm.team.enterprise.packaging.toolkit.util.CheckPackagingVersions;
import com.ibm.team.repository.client.ITeamRepository;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.eclipse.core.runtime.IProgressMonitor;

public class RecordPackagedObjectsTask
extends AbstractAutomationPublisherTask {
    private String packageDir;
    final String BUILDFORGE_BUILD_AGENT_ELEMENT = "com.ibm.rational.buildforge.buildagent";
    final String BUILDFORGE_BUILD_AGENT_HOSTNAME = "com.ibm.rational.buildforge.buildagent.hostname";

    public void execute() throws BuildException {
        Project proj = this.getProject();
        if (CheckPackagingVersions.isDefinitionVersionGreaterThan30(proj)) {
            try {
                File packageManifestFile;
                String isUcd = proj.getProperty("isUcdPackage");
                String packageManifestFilename = String.valueOf(this.packageDir) + File.separator + "packageManifest.xml";
                if (isUcd != null && isUcd.equals("true")) {
                    packageManifestFilename = String.valueOf(this.packageDir) + File.separator + "UCDpackageManifest.xml";
                }
                if ((packageManifestFile = new File(packageManifestFilename)).exists()) {
                    Manifest packageManifest = ManifestReader.getInstance().getManifest(packageManifestFile);
                    HashSet<String> workItemUUIDs = new HashSet<String>();
                    ArrayList<IBuildResultContribution> contributions = new ArrayList<IBuildResultContribution>();
                    IBuildResultContribution summaryContribution = BuildItemFactory.createBuildResultContribution();
                    IBuildEngine buildEngine = this.getBuildEngine();
                    String hostname = buildEngine.getConfigurationElement("com.ibm.rational.buildforge.buildagent").getConfigurationProperty("com.ibm.rational.buildforge.buildagent.hostname").getValue();
                    summaryContribution.setLabel(proj.getProperty("team.package.common.filesystem"));
                    summaryContribution.setExtendedContributionTypeId(AutomationResultContribution.PACKAGING_OVERVIEW_EXTENDED_CONTRIBUTION_ID);
                    summaryContribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_APPLICATION_NAME, proj.getProperty("team.package.common.applicationName"));
                    summaryContribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_VERSION, proj.getProperty("team.package.common.version"));
                    summaryContribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_DESCRIPTION, proj.getProperty("team.package.common.applicationDescription"));
                    summaryContribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_HOST_NAME, hostname);
                    summaryContribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_PACKAGE_DIR, this.packageDir);
                    summaryContribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_BUILDRESULT_UUID, proj.getProperty("buildResultUUID"));
                    summaryContribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_PACKAGE_DEFINITION_UUID, proj.getProperty("team.deploy.packageDefinitionUUID"));
                    summaryContribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_SUMMARY_WORKITEM, proj.getProperty("team.enterprise.packaging.summaryWorkItemId"));
                    summaryContribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_SUMMARY_WORKITEM_UUID, proj.getProperty("team.enterprise.packaging.summaryWorkItemUUID"));
                    IBuildResult buildResult = this.getBuildResult();
                    String timestamp = proj.getProperty("com.ibm.team.build.internal.template.id").contains("nonseq") ? String.valueOf(buildResult.getBuildStartTime()) : this.packageDir.substring(this.packageDir.lastIndexOf(File.separator) + 2);
                    summaryContribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_TIMESTAMP, timestamp);
                    String buildRoot = "";
                    if (proj.getProperty("team.package.common.filesystem").equals("luw")) {
                        buildRoot = String.valueOf(this.getBuildRoot(proj.getProperty("team.package.luw.buildRoot.dir"))) + File.separator;
                    } else {
                        String hfsOutputs = this.getBuildRoot(proj.getProperty("team.enterprise.packaging.hfs.buildRoot.dir"));
                        if (hfsOutputs != null && !hfsOutputs.isEmpty() && !(buildRoot = hfsOutputs).endsWith(File.separator)) {
                            buildRoot = String.valueOf(buildRoot) + File.separator;
                        }
                    }
                    contributions.add(summaryContribution);
                    this.recordContainers(packageManifest.getContainers(), contributions, workItemUUIDs, buildRoot, "Changed");
                    this.recordContainers(packageManifest.getDeletedContainers(), contributions, workItemUUIDs, buildRoot, "Deleted");
                    ITeamRepository teamRepository = this.getTeamRepository();
                    IProgressMonitor progressMonitor = this.getProgressMonitor();
                    ClientFactory.getTeamBuildClient((ITeamRepository)teamRepository).addBuildResultContributions((IBuildResultHandle)buildResult, contributions.toArray(new IBuildResultContribution[contributions.size()]), progressMonitor);
                    WorkItemAutomationPublisherTask workItemAutomationPublisherTask = new WorkItemAutomationPublisherTask(workItemUUIDs.toArray(), Boolean.valueOf(false), buildResult, teamRepository);
                    workItemAutomationPublisherTask.execute();
                }
            }
            catch (Exception e) {
                throw new BuildException(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void recordContainers(List<Container> containers, List<IBuildResultContribution> contributions, HashSet<String> workItemUUIDs, String buildRoot, String changeType) {
        for (Container container : containers) {
            if ("sequential".equals(container.getType())) {
                IBuildResultContribution contribution = BuildItemFactory.createBuildResultContribution();
                contribution.setExtendedContributionTypeId(AutomationResultContribution.PACKAGED_OBJECT_EXTENDED_CONTRIBUTION_ID);
                contribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_CONTAINER, container.getName());
                contribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_WORKITEM, container.getWorkItemId());
                contribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_WORKITEM_UUID, container.getWorkitemUUID());
                contribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_RESOURCE_TYPE, container.getType());
                contribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_CHANGE_TYPE, changeType);
                contribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_CONTAINER_TYPE, container.getType());
                contributions.add(contribution);
                continue;
            }
            boolean isHFS = "directory".equalsIgnoreCase(container.getType());
            Iterator resourceIterator = container.getResourcesIterator();
            while (resourceIterator.hasNext()) {
                IBuildResultContribution contribution = BuildItemFactory.createBuildResultContribution();
                contribution.setExtendedContributionTypeId(AutomationResultContribution.PACKAGED_OBJECT_EXTENDED_CONTRIBUTION_ID);
                Resource resource = (Resource)resourceIterator.next();
                String containerName = container.getName();
                if (isHFS && (containerName = ".".equals(containerName) ? buildRoot : String.valueOf(buildRoot) + containerName).endsWith(File.separator)) {
                    containerName = containerName.substring(0, containerName.length() - 1);
                }
                contribution.setLabel(resource.getName());
                contribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_CONTAINER, containerName);
                contribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_LAST_MODIFIED, resource.getLastModifiedTimestamp());
                contribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_WORKITEM, resource.getWorkItemId());
                contribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_WORKITEM_UUID, resource.getWorkitemUUID());
                contribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_OBJECTTYPE, resource.getIbmiType());
                contribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_OBJECTSUBTYPE, resource.getIbmiAttrribute());
                contribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_RESOURCE_TYPE, resource.getType());
                contribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_CHANGE_TYPE, changeType);
                contribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_CONTAINER_TYPE, container.getType());
                if (workItemUUIDs != null && resource.getWorkitemUUID() != null) {
                    workItemUUIDs.add(resource.getWorkitemUUID());
                }
                contributions.add(contribution);
            }
        }
    }

    public void setPackageDir(String packageDir) {
        this.packageDir = packageDir;
    }
}

