/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.packaging.taskdefs;

import com.ibm.team.enterprise.automation.common.helper.ShipListFileNameHelper;
import com.ibm.team.enterprise.automation.manifest.Manifest;
import com.ibm.team.enterprise.automation.manifest.ManifestReader;
import com.ibm.team.enterprise.automation.manifest.ManifestWriter;
import com.ibm.team.enterprise.packaging.taskdefs.Messages;
import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;

public class CopyAndSetGeneratedFilePropertiesTask
extends Task {
    public void execute() throws BuildException {
        Manifest manifest;
        File convertedFile;
        Project proj = this.getProject();
        String packageDefUUID = proj.getProperty("team.deploy.packageDefinitionUUID");
        String packageRootDir = proj.getProperty("team.package.common.packageRoot.dir");
        String encoding = "UTF-8";
        String isZOSString = proj.getProperty("isZOSFileSystem");
        boolean isZOS = false;
        if (isZOSString != null) {
            isZOS = Boolean.parseBoolean(isZOSString);
            encoding = "IBM-1047";
        }
        String packageLabel = proj.getProperty("buildLabel");
        boolean isConcurrentSafe = false;
        String isConcurrentSafeProperty = proj.getProperty("team.package.common.isConcurrentSafe");
        if (isConcurrentSafeProperty != null && isConcurrentSafeProperty.equals("true")) {
            isConcurrentSafe = true;
        }
        if (!isZOS) {
            String manualShiplistPath = proj.getProperty("team.package.manual.shiplist");
            String unconvertedWiShipList = ShipListFileNameHelper.constructShiplistName((ShipListFileNameHelper.Type)ShipListFileNameHelper.Type.WORKITEM, (ShipListFileNameHelper.Phase)ShipListFileNameHelper.Phase.AGENT_INIT, (boolean)isConcurrentSafe, (String)packageRootDir, (String)packageDefUUID, (String)packageLabel);
            String wiShipList = ShipListFileNameHelper.constructShiplistName((ShipListFileNameHelper.Type)ShipListFileNameHelper.Type.WORKITEM, (ShipListFileNameHelper.Phase)ShipListFileNameHelper.Phase.AGENT_CONVERT, (boolean)isConcurrentSafe, (String)packageRootDir, (String)packageDefUUID, (String)packageLabel);
            File file = manualShiplistPath != null && !"".equals(manualShiplistPath) ? new File(manualShiplistPath) : new File(unconvertedWiShipList);
            File convertedFile2 = new File(wiShipList);
            try {
                Manifest manifest2 = ManifestReader.getInstance().getManifest(file);
                ManifestWriter.getInstance().write(convertedFile2, encoding, manifest2);
                if (manualShiplistPath == null || "".equals(manualShiplistPath)) {
                    file.delete();
                }
            }
            catch (Exception e) {
                proj.log(Messages.CopyAndSetGeneratedFilePropertiesTask_ERROR, (Throwable)e, 0);
            }
            proj.setProperty("team.package.common.workItemFilePath", wiShipList);
        }
        String unconvertedIncludeShiplist = ShipListFileNameHelper.constructShiplistName((ShipListFileNameHelper.Type)ShipListFileNameHelper.Type.INCLUDE, (ShipListFileNameHelper.Phase)ShipListFileNameHelper.Phase.AGENT_INIT, (boolean)isConcurrentSafe, (String)packageRootDir, (String)packageDefUUID, (String)packageLabel);
        String includeShiplist = ShipListFileNameHelper.constructShiplistName((ShipListFileNameHelper.Type)ShipListFileNameHelper.Type.INCLUDE, (ShipListFileNameHelper.Phase)ShipListFileNameHelper.Phase.AGENT_CONVERT, (boolean)isConcurrentSafe, (String)packageRootDir, (String)packageDefUUID, (String)packageLabel);
        String unconvertedExcludeShiplist = ShipListFileNameHelper.constructShiplistName((ShipListFileNameHelper.Type)ShipListFileNameHelper.Type.EXCLUDE, (ShipListFileNameHelper.Phase)ShipListFileNameHelper.Phase.AGENT_INIT, (boolean)isConcurrentSafe, (String)packageRootDir, (String)packageDefUUID, (String)packageLabel);
        String excludeShiplist = ShipListFileNameHelper.constructShiplistName((ShipListFileNameHelper.Type)ShipListFileNameHelper.Type.EXCLUDE, (ShipListFileNameHelper.Phase)ShipListFileNameHelper.Phase.AGENT_CONVERT, (boolean)isConcurrentSafe, (String)packageRootDir, (String)packageDefUUID, (String)packageLabel);
        File file = new File(unconvertedIncludeShiplist);
        if (file.exists()) {
            convertedFile = new File(includeShiplist);
            try {
                manifest = ManifestReader.getInstance().getManifest(file);
                ManifestWriter.getInstance().write(convertedFile, encoding, manifest);
                file.delete();
            }
            catch (Exception e) {
                proj.log(Messages.CopyAndSetGeneratedFilePropertiesTask_ERROR, (Throwable)e, 0);
            }
            proj.setProperty("team.package.zos.optional.shiplistFilePath", includeShiplist);
            proj.setProperty("team.package.common.includeFilePath", includeShiplist);
        }
        if ((file = new File(unconvertedExcludeShiplist)).exists()) {
            convertedFile = new File(excludeShiplist);
            try {
                manifest = ManifestReader.getInstance().getManifest(file);
                ManifestWriter.getInstance().write(convertedFile, encoding, manifest);
                file.delete();
            }
            catch (Exception e) {
                proj.log(Messages.CopyAndSetGeneratedFilePropertiesTask_ERROR, (Throwable)e, 0);
            }
            proj.setProperty("team.package.common.excludeFilePath", excludeShiplist);
        }
    }
}

