/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.packaging.taskdefs;

import com.ibm.team.enterprise.packaging.common.util.CreateShiplistUtil;
import com.ibm.team.enterprise.packaging.taskdefs.Messages;
import com.ibm.team.enterprise.packaging.toolkit.manifest.ManifestAdditiveMerger;
import com.ibm.team.enterprise.packaging.toolkit.manifest.ManifestPropertyMerger;
import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.eclipse.osgi.util.NLS;

public class ConvertShipListToUcdTask
extends Task {
    private String inputFileName;
    private String outputFileName;
    public final String POSIX_SEPARATOR = "/";

    public String getInputFileName() {
        return this.inputFileName;
    }

    public void setInputFileName(String fileName) {
        this.inputFileName = fileName;
    }

    public String getOutputFileName() {
        return this.outputFileName;
    }

    public void setOutputFileName(String fileName) {
        this.outputFileName = fileName;
    }

    public void execute() throws BuildException {
        Project proj = this.getProject();
        if (this.inputFileName == null || this.outputFileName == null || this.inputFileName.trim().isEmpty() || this.outputFileName.trim().isEmpty()) {
            throw new BuildException(Messages.ConvertShipListToUcdTask_MissingFileName);
        }
        boolean isZos = false;
        String outputCCSID = "UTF-8";
        String fileSystem = proj.getProperty("team.package.common.filesystem");
        if ("zos".equals(fileSystem)) {
            isZos = true;
            outputCCSID = "IBM-1047";
        }
        String isBlzpkgzpRexxSkipped = proj.getProperty("team.package.common.skipPackageGeneration");
        if (isZos && (isBlzpkgzpRexxSkipped == null || !Boolean.parseBoolean(isBlzpkgzpRexxSkipped))) {
            String preBlzpkgzpFileName = proj.getProperty("team.package.zos.shiplistFilePath");
            if (preBlzpkgzpFileName == null || preBlzpkgzpFileName.trim().isEmpty()) {
                throw new BuildException("@@@bab: team.package.zos.shiplistFilePath was not set!");
            }
            File postBlzpkgzpFile = new File(this.inputFileName);
            String intermediateBuildMapInfoFileName = String.valueOf(postBlzpkgzpFile.getParent()) + "/" + "tempPackageManifest1.xml";
            File intermediateBuildMapInfoFile = new File(intermediateBuildMapInfoFileName);
            new ManifestAdditiveMerger(this.getProject(), preBlzpkgzpFileName, this.inputFileName, intermediateBuildMapInfoFileName, "UTF-8");
            postBlzpkgzpFile.delete();
            intermediateBuildMapInfoFile.renameTo(postBlzpkgzpFile);
        }
        File inputFile = new File(this.inputFileName);
        File outputFile = new File(this.outputFileName);
        String intermediateFileName2 = String.valueOf(outputFile.getParent()) + "/" + "tempPackageManifest2.xml";
        File intermediatePropertyFile = new File(intermediateFileName2);
        String inputPropertyManifestFileNameString = proj.getProperty("team.package.ucd.propertyManifestFile");
        boolean isPropertyManifestUsed = false;
        if (inputPropertyManifestFileNameString != null && !inputPropertyManifestFileNameString.trim().isEmpty()) {
            String inputPropertyManifestFileName = inputPropertyManifestFileNameString.trim();
            File inputPropertyManifestFile = new File(inputPropertyManifestFileName);
            if (!inputPropertyManifestFile.exists()) {
                proj.log(NLS.bind((String)Messages.ConvertShipListToUcdTask_PROPERTY_MANIFEST_NOT_FOUND_IGNORED_WARNING_MSG, (Object)inputPropertyManifestFileName), 1);
            } else {
                try {
                    new ManifestPropertyMerger(this.getProject(), this.inputFileName, inputPropertyManifestFileName, intermediateFileName2, "UTF-8", "");
                    isPropertyManifestUsed = true;
                }
                catch (Exception e) {
                    throw new BuildException((Throwable)e);
                }
            }
        }
        try {
            String outputsDir = this.getProject().getProperty("team.enterprise.packaging.hfs.buildRoot.dir");
            if (isPropertyManifestUsed) {
                CreateShiplistUtil.removeUcdAttributesFromManifest((File)intermediatePropertyFile, (File)outputFile, (String)outputCCSID, (String)outputsDir);
                intermediatePropertyFile.delete();
            } else {
                CreateShiplistUtil.removeUcdAttributesFromManifest((File)inputFile, (File)outputFile, (String)outputCCSID, (String)outputsDir);
            }
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }
}

