/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.packaging.taskdefs;

import com.ibm.team.enterprise.automation.common.helper.ShipListFileNameHelper;
import com.ibm.team.enterprise.automation.manifest.Manifest;
import com.ibm.team.enterprise.automation.manifest.ManifestReader;
import com.ibm.team.enterprise.automation.manifest.ManifestWriter;
import com.ibm.team.enterprise.packaging.taskdefs.Messages;
import com.ibm.team.enterprise.packaging.toolkit.util.CheckPackagingVersions;
import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;

public class ConvertShipListTask
extends Task {
    public void execute() throws BuildException {
        boolean isDefinitionVersionGreaterThan30;
        Project proj = this.getProject();
        String packageDefUUID = proj.getProperty("team.deploy.packageDefinitionUUID");
        String workItemOption = proj.getProperty("team.package.common.workitem.option");
        String packageLabel = proj.getProperty("buildLabel");
        boolean isConcurrentSafe = false;
        String isConcurrentSafeProperty = proj.getProperty("team.package.common.isConcurrentSafe");
        if (isConcurrentSafeProperty != null && isConcurrentSafeProperty.equals("true")) {
            isConcurrentSafe = true;
        }
        if (isDefinitionVersionGreaterThan30 = CheckPackagingVersions.isDefinitionVersionGreaterThan30(proj)) {
            String manualShiplistPath;
            boolean isWorkItemPackage;
            String packageRootDir = proj.getProperty("team.package.common.packageRoot.dir");
            String unconvertedWiShipList = ShipListFileNameHelper.constructShiplistName((ShipListFileNameHelper.Type)ShipListFileNameHelper.Type.WORKITEM, (ShipListFileNameHelper.Phase)ShipListFileNameHelper.Phase.AGENT_INIT, (boolean)isConcurrentSafe, (String)packageRootDir, (String)packageDefUUID, (String)packageLabel);
            String wiShipList = ShipListFileNameHelper.constructShiplistName((ShipListFileNameHelper.Type)ShipListFileNameHelper.Type.WORKITEM, (ShipListFileNameHelper.Phase)ShipListFileNameHelper.Phase.AGENT_CONVERT, (boolean)isConcurrentSafe, (String)packageRootDir, (String)packageDefUUID, (String)packageLabel);
            boolean bl = isWorkItemPackage = workItemOption != null && workItemOption.length() != 0 && Boolean.parseBoolean(workItemOption);
            File file = isWorkItemPackage ? ((manualShiplistPath = proj.getProperty("team.package.manual.shiplist")) == null || "".equals(manualShiplistPath) ? new File(unconvertedWiShipList) : new File(manualShiplistPath)) : new File(proj.getProperty("team.package.common.shiplistFilePath"));
            File convertedFile = new File(wiShipList);
            try {
                Manifest manifest = ManifestReader.getInstance().getManifest(file);
                ManifestWriter.getInstance().write(convertedFile, "IBM-1047", manifest);
                file.delete();
            }
            catch (Exception e) {
                proj.log(Messages.ConvertShipListTask_ERROR, (Throwable)e, 0);
            }
            proj.setProperty("team.package.zos.shiplistFilePath", wiShipList);
        } else {
            proj.setProperty("team.package.zos.shiplistFilePath", proj.getProperty("team.package.common.shiplistFilePath"));
        }
    }
}

