/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.packaging.taskdefs;

import com.ibm.team.enterprise.automation.internal.AutomationPasswordHelper;
import com.ibm.team.enterprise.build.ant.internal.utils.AuthenticationUtilities;
import com.ibm.team.enterprise.build.client.packaging.IPackageJFSClient;
import com.ibm.team.enterprise.rdf.query.common.select.result.Binding;
import com.ibm.team.enterprise.rdf.query.common.select.result.SelectResult;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class CleanupMarkedPackagesForDeletionTask
extends Task {
    private ITeamRepository fTeamRepository = null;

    static {
        if (!TeamPlatform.isStarted()) {
            TeamPlatform.startup();
        }
    }

    public void execute() throws BuildException {
        try {
            if (this.getProject().getProperty("team.package.common.isAutoClean").equals("true")) {
                boolean isAutocleanTest = Boolean.valueOf(this.getProject().getProperty("team.package.common.testAutoclean"));
                boolean isJustCleaningRecords = Boolean.valueOf(this.getProject().getProperty("team.package.common.justCleanPkgRepoRecords"));
                this.getTeamRepository();
                IPackageJFSClient client = (IPackageJFSClient)this.fTeamRepository.getClientLibrary(IPackageJFSClient.class);
                String packageDefinitionUUID = this.getProject().getProperty("team.deploy.packageDefinitionUUID");
                this.autocleanTestLog("AutocleanTest: getting deleted package records for package definition: " + packageDefinitionUUID, isAutocleanTest);
                List results = client.getPackagesMarkedForDeletion(packageDefinitionUUID);
                this.autocleanTestLog(results == null ? "AutocleanTest: no packages to delete" : "AutocleanTest: total packages to delete: " + results.size(), isAutocleanTest);
                int i = 0;
                int numDeletedRecords = 0;
                for (SelectResult selectResult : results) {
                    List bindings = selectResult.getBindings();
                    String location = null;
                    String packageResultUUID = null;
                    this.autocleanTestLog("AutocleanTest: binding [" + i + "] -------", isAutocleanTest);
                    for (Binding binding : bindings) {
                        String bindingName = binding.getName();
                        if (bindingName.equals("location")) {
                            location = binding.getValue();
                            continue;
                        }
                        if (!bindingName.equals("packageResultUUID")) continue;
                        packageResultUUID = binding.getValue();
                    }
                    File file = new File(location);
                    if (!isJustCleaningRecords) {
                        this.recursiveDelete(file, isAutocleanTest);
                    }
                    if (!isAutocleanTest || isJustCleaningRecords) {
                        client.deletePackage(UUID.valueOf(packageResultUUID), UUID.valueOf((String)packageDefinitionUUID));
                        ++numDeletedRecords;
                    }
                    ++i;
                }
                this.autocleanTestLog("AutocleanTest: total package records deleted from repository: " + numDeletedRecords, isAutocleanTest);
            }
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
        catch (TeamRepositoryException t) {
            throw new BuildException((Throwable)t);
        }
    }

    protected void recursiveDelete(File file, boolean isAutocleanTest) {
        if (file.isDirectory()) {
            File[] files;
            File[] fileArray = files = file.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File childFile = fileArray[n2];
                this.recursiveDelete(childFile, isAutocleanTest);
                ++n2;
            }
        }
        this.autocleanTestLog("AutocleanTest: file or dir which would be deleted: " + file.getAbsolutePath(), isAutocleanTest);
        if (!isAutocleanTest) {
            file.delete();
        }
    }

    public String getRepositoryAddress() throws FileNotFoundException, IOException {
        return this.getProject().getProperty("env.repositoryAddress");
    }

    protected ITeamRepository getTeamRepository() throws TeamRepositoryException, FileNotFoundException, IOException {
        if (this.fTeamRepository == null) {
            this.fTeamRepository = AuthenticationUtilities.getLoggedInTeamRepository((Project)this.getProject(), (String)this.getRepositoryAddress(), (String)this.getUserId(), (File)new File(this.getPasswordFile()));
        }
        return this.fTeamRepository;
    }

    protected IProgressMonitor getProgressMonitor() {
        return new NullProgressMonitor();
    }

    public String getUserId() throws FileNotFoundException, IOException {
        return this.getProject().getProperty("env.JAZZ_USER");
    }

    public String getPasswordFile() throws FileNotFoundException, IOException {
        return this.getProject().getProperty("env.JAZZ_PASSWORD_FILE");
    }

    protected String getProvidedPassword() throws TeamRepositoryException, FileNotFoundException, IOException {
        File passwordFile = new File(this.getPasswordFile());
        try {
            return this.decryptPassword(passwordFile);
        }
        catch (Exception exception) {
            throw new TeamRepositoryException((Throwable)exception);
        }
    }

    protected String decryptPassword(File passwordFile) throws Exception {
        return CleanupMarkedPackagesForDeletionTask.getPassword(passwordFile);
    }

    public static String getPassword(File passwordFile) throws GeneralSecurityException, IOException {
        return AutomationPasswordHelper.getPassword((File)passwordFile);
    }

    private void autocleanTestLog(String logMessage, boolean isAutocleanTest) {
        if (isAutocleanTest) {
            this.log(logMessage, 4);
        }
    }
}

