/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.packaging.taskdefs;

import com.ibm.team.enterprise.automation.parsers.ContainerMappingDocument;
import com.ibm.team.enterprise.automation.taskdefs.ValidateManifestTask;
import com.ibm.team.enterprise.packaging.taskdefs.Messages;
import com.ibm.team.enterprise.packaging.toolkit.util.CheckPackagingVersions;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.eclipse.osgi.util.NLS;

public class CheckPackagePropertiesTask
extends Task {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() throws BuildException {
        String packageRootDirPath;
        File packageRootDir;
        Project proj = this.getProject();
        String workItemOption = proj.getProperty("team.package.common.workitem.option");
        String bldToolkit = proj.getProperty("BLD_TOOLKIT");
        String packageLabel = proj.getProperty("buildLabel");
        boolean isNonSequential = proj.getProperty("com.ibm.team.build.internal.template.id").contains("nonseq");
        if (!isNonSequential) {
            String optionalShipListFilePath;
            ValidateManifestTask shiplistValidateTask;
            if (workItemOption == null || workItemOption.length() == 0 || !Boolean.parseBoolean(workItemOption) || !proj.getProperty("team.package.common.filesystem").equals("zos")) {
                String shipListFilePath = proj.getProperty("team.package.common.shiplistFilePath");
                File shipListFile = new File(shipListFilePath);
                if (!shipListFile.exists()) throw new BuildException(NLS.bind((String)Messages.CheckPackagePropertiesTask_SHIP_LIST_DOES_NOT_EXIST_ERROR_MSG, (Object)shipListFilePath));
                if (!shipListFile.isFile()) throw new BuildException(NLS.bind((String)Messages.CheckPackagePropertiesTask_SHIP_LIST_IS_NOT_A_FILE_ERROR_MSG, (Object)shipListFilePath));
                if (!shipListFile.canRead()) throw new BuildException(NLS.bind((String)Messages.CheckPackagePropertiesTask_NO_ACCESS_TO_SHIP_LIST_FILE_ERROR_MSG, (Object)shipListFilePath));
                if (shipListFile.length() == 0L) {
                    throw new BuildException(NLS.bind((String)Messages.CheckPackagePropertiesTask_SHIP_LIST_FILE_IS_EMPTY_ERROR_MSG, (Object)shipListFilePath));
                }
                if (CheckPackagingVersions.isDefinitionVersionGreaterThan30(proj)) {
                    shiplistValidateTask = new ValidateManifestTask();
                    shiplistValidateTask.setManifestPath(shipListFilePath);
                    shiplistValidateTask.setSchemaPath(String.valueOf(bldToolkit) + "/scripts/enterprise/manifest.xsd");
                    shiplistValidateTask.execute();
                }
            } else if (Boolean.parseBoolean(workItemOption) && proj.getProperty("team.package.common.filesystem").equals("zos") && (optionalShipListFilePath = proj.getProperty("team.package.zos.optional.shiplistFilePath")) != null && optionalShipListFilePath.trim().length() > 0) {
                File optionalShipListFile = new File(optionalShipListFilePath);
                if (!optionalShipListFile.exists()) throw new BuildException(NLS.bind((String)Messages.CheckPackagePropertiesTask_OPTIONAl_SHIP_LIST_DOES_NOT_EXIST_ERROR_MSG, (Object)optionalShipListFile));
                if (!optionalShipListFile.isFile()) throw new BuildException(NLS.bind((String)Messages.CheckPackagePropertiesTask_OPTIONAL_SHIP_LIST_IS_NOT_A_FILE_ERROR_MSG, (Object)optionalShipListFile));
                if (!optionalShipListFile.canRead()) throw new BuildException(NLS.bind((String)Messages.CheckPackagePropertiesTask_DO_NOT_HAVE_READ_ACCESS_TO_OPT_SHIP_LIST_ERROR_MSG, (Object)optionalShipListFile));
                if (optionalShipListFile.length() <= 0L) throw new BuildException(NLS.bind((String)Messages.CheckPackagePropertiesTask_OPTIONAL_SHIP_LIST_IS_EMPTY_ERROR_MSG, (Object)optionalShipListFile));
                if (CheckPackagingVersions.isDefinitionVersionGreaterThan30(proj)) {
                    shiplistValidateTask = new ValidateManifestTask();
                    shiplistValidateTask.setManifestPath(optionalShipListFilePath);
                    shiplistValidateTask.setSchemaPath(String.valueOf(bldToolkit) + "/scripts/enterprise/manifest.xsd");
                    shiplistValidateTask.execute();
                }
            }
        }
        if ((packageRootDir = new File(packageRootDirPath = proj.getProperty("team.package.common.packageRoot.dir"))).exists()) {
            if (!packageRootDir.isDirectory()) throw new BuildException(NLS.bind((String)Messages.CheckPackagePropertiesTask_PACKAGE_ROOT_IS_NOT_A_DIR_ERROR_MSG, (Object)packageRootDirPath));
            if (!packageRootDir.canRead()) throw new BuildException(NLS.bind((String)Messages.CheckPackagePropertiesTask_NO_READ_ACCESS_TO_PACKAGE_ROOT_DIR_ERROR_MSG, (Object)packageRootDirPath));
            if (!packageRootDir.canWrite()) {
                throw new BuildException(NLS.bind((String)Messages.CheckPackagePropertiesTask_NO_WRITE_ACCESS_TO_PACKAGE_ROOT_DIR_ERROR_MSG, (Object)packageRootDirPath));
            }
        }
        if (!isNonSequential) {
            String restoreMappingPath = proj.getProperty("team.package.common.restoreMappingPath");
            if (restoreMappingPath == null || restoreMappingPath.trim().length() <= 0) return;
            File restoreMappingFile = new File(restoreMappingPath);
            if (!restoreMappingFile.exists()) throw new BuildException(NLS.bind((String)Messages.CheckPackagePropertiesTask_RESTORE_MAPPING_FILE_DOES_NOT_EXIST_ERROR_MSG, (Object)restoreMappingPath));
            if (!CheckPackagingVersions.isDefinitionVersionGreaterThan30(proj)) return;
            ContainerMappingDocument parser = new ContainerMappingDocument();
            try {
                FileInputStream fileInput = new FileInputStream(restoreMappingFile);
                parser.validate((InputStream)fileInput);
                fileInput.close();
                return;
            }
            catch (Exception e) {
                throw new BuildException(NLS.bind((String)Messages.CheckPackagePropertiesTask_RESTORE_MAPPING_FILE_VALIDATION_ERROR_MSG, (Object)e.getMessage()), (Throwable)e);
            }
        } else {
            String restoreMappingFilePath;
            File file;
            String packageDefUUID = proj.getProperty("team.deploy.packageDefinitionUUID");
            boolean isConcurrentSafe = false;
            String isConcurrentSafeProperty = proj.getProperty("team.package.common.isConcurrentSafe");
            if (isConcurrentSafeProperty != null && isConcurrentSafeProperty.equals("true")) {
                isConcurrentSafe = true;
            }
            if (!(file = new File(restoreMappingFilePath = !isConcurrentSafe ? packageRootDir + File.separator + packageDefUUID + File.separator + "restore-mapping-" + packageDefUUID + ".xml" : packageRootDir + File.separator + "restore-mapping-" + packageDefUUID + "_" + packageLabel + ".xml")).exists()) return;
            proj.setProperty("team.package.common.restoreMappingPath", restoreMappingFilePath);
        }
    }
}

