/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.packaging.taskdefs;

import com.ibm.team.enterprise.packaging.taskdefs.Messages;
import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.Calendar;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.eclipse.osgi.util.NLS;

public class CalculatePackageDirectoryTask
extends Task {
    public void execute() throws BuildException {
        Project proj = this.getProject();
        proj.log(NLS.bind((String)Messages.CalculatePackageDirectoryTask_EXCUTING_TASK_DEBUG_MSG, (Object)CalculatePackageDirectoryTask.class.getName()), 4);
        String packageRootDirValue = proj.getProperty("team.package.common.packageRoot.dir");
        String applicatioNameValue = proj.getProperty("team.package.common.applicationName");
        String versionValue = proj.getProperty("team.package.common.version");
        String isCompletePackageValue = proj.getProperty("team.package.common.isCompletePackage");
        packageRootDirValue = this.addFileSeparatorIfNeeded(packageRootDirValue);
        String appVersionDirString = new String(String.valueOf(packageRootDirValue) + applicatioNameValue + File.separator + versionValue);
        proj.log(NLS.bind((String)Messages.CalculatePackageDirectoryTask_APP_VERSION_DIR_PATH_LOG_MSG, (Object)appVersionDirString));
        String packageDirString = null;
        String timeStamp = this.getTimeStamp();
        if (Boolean.parseBoolean(isCompletePackageValue)) {
            packageDirString = String.valueOf(appVersionDirString) + File.separator + "C" + timeStamp;
        } else {
            File appVersionDir = new File(appVersionDirString);
            if (appVersionDir.exists()) {
                FileFilter dirFilter = new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        return file.isDirectory() && file.getName().startsWith("C");
                    }
                };
                Object[] allFiles = appVersionDir.listFiles(dirFilter);
                if (allFiles.length > 0) {
                    Arrays.sort(allFiles);
                    Object latestCompletePackageDir = allFiles[allFiles.length - 1];
                    packageDirString = String.valueOf(this.addFileSeparatorIfNeeded(((File)latestCompletePackageDir).toString())) + "U" + timeStamp;
                } else {
                    proj.log(NLS.bind((String)Messages.CalculatePackageDirectoryTask_NO_COMPLETE_PACKAGE_DIR_FOUND_IN_APP_VERSION_LOG_MSG, (Object)appVersionDirString));
                    packageDirString = String.valueOf(appVersionDirString) + File.separator + "C" + timeStamp + File.separator + "U" + timeStamp;
                }
            } else {
                proj.log(NLS.bind((String)Messages.CalculatePackageDirectoryTask_APP_VERSION_DIR_DOES_NOT_EXIST_LOG_MSG, (Object)appVersionDirString));
                packageDirString = String.valueOf(appVersionDirString) + File.separator + "C" + timeStamp + File.separator + "U" + timeStamp;
            }
        }
        proj.log(NLS.bind((String)Messages.CalculatePackageDirectoryTask_CALCULATED_PACKAGE_DIR_LOG_MSG, (Object)packageDirString));
        proj.setProperty("team.package.common.package.dir", packageDirString);
    }

    public String getTimeStamp() {
        String time = this.getProject().getProperty("env.buildLabel");
        Calendar cal = Calendar.getInstance();
        cal.set(Integer.parseInt(time.substring(0, 4)), Integer.parseInt(time.substring(4, 6)) - 1, Integer.parseInt(time.substring(6, 8)), Integer.parseInt(time.substring(9, 11)), Integer.parseInt(time.substring(11, 13)), Integer.parseInt(time.substring(13, 15)));
        cal.set(14, Integer.parseInt(time.substring(15)));
        return String.valueOf(cal.getTimeInMillis());
    }

    private String addFileSeparatorIfNeeded(String path) {
        if (!path.endsWith(File.separator)) {
            return path.concat(File.separator);
        }
        return path;
    }
}

