/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.packaging.hfs;

import com.ibm.team.enterprise.automation.hfs.HFSUtil;
import com.ibm.team.enterprise.automation.manifest.Container;
import com.ibm.team.enterprise.automation.manifest.Manifest;
import com.ibm.team.enterprise.automation.manifest.ManifestReader;
import com.ibm.team.enterprise.automation.manifest.Resource;
import com.ibm.team.enterprise.packaging.hfs.Messages;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.selectors.SelectorUtils;
import org.eclipse.osgi.util.NLS;

public class PackageHFSFilesTask
extends Task {
    private File shiplist;
    private File packageDir;
    private String outputFile;
    private boolean preview;
    private String rootDir;
    private boolean useContainerRootDir;

    /*
     * Unable to fully structure code
     */
    public void execute() throws BuildException {
        block35: {
            if (this.shiplist == null || !this.shiplist.exists()) break block35;
            try {
                includeManifest = ManifestReader.getInstance().getManifest(this.shiplist);
                deletionContainers = HFSUtil.getHFSContainers((List)includeManifest.getDeletedContainers(), (boolean)false);
                eeOutputDir = null;
                outputDirToContainerMap = new HashMap<String, ArrayList<Container>>();
                for (Container container : HFSUtil.getHFSContainers((List)includeManifest.getContainers())) {
                    if (this.useContainerRootDir) {
                        outputDir = container.getRootDir();
                        if (outputDir == null || outputDir.isEmpty()) {
                            throw new Exception(NLS.bind((String)Messages.PackageHFSFilesTask_CONTAINER_MISSING_ATTRIBUTE, (Object)container.getName(), (Object)"rootDir"));
                        }
                    } else {
                        if (eeOutputDir == null) {
                            eeOutputDir = this.resolveOutputsDir();
                        }
                        outputDir = eeOutputDir.getAbsolutePath();
                    }
                    if ((containers = (ArrayList<Container>)outputDirToContainerMap.get(outputDir)) == null) {
                        containers = new ArrayList<Container>();
                        outputDirToContainerMap.put(outputDir, containers);
                    }
                    containers.add(container);
                }
                if (deletionContainers.isEmpty() && outputDirToContainerMap.isEmpty()) {
                    this.getProject().log(Messages.PackageHFSFilesTask_NOTHING_TO_PACKAGE_INFO_MSG, 2);
                    return;
                }
                packageManifestFile = new File(this.packageDir + File.separator + "packageManifest.xml");
                if (packageManifestFile.exists()) {
                    packageManifest = ManifestReader.getInstance().getManifest(packageManifestFile);
                } else {
                    packageManifest = new Manifest();
                    packageManifest.setType("MANIFEST_LIST");
                }
                packageManifest.getDeletedContainers().addAll(deletionContainers);
                excludeManifest = null;
                excludeFilePath = this.getProject().getProperty("team.package.common.excludeFilePath");
                if (excludeFilePath != null && !excludeFilePath.trim().isEmpty()) {
                    excludeFile = new File(excludeFilePath);
                    if (excludeFile.exists()) {
                        excludeManifest = ManifestReader.getInstance().getManifest(excludeFile);
                    } else {
                        throw new BuildException(NLS.bind((String)Messages.PackageHFSFilesTask_EXCLUDE_FILE_DOES_NOT_EXIST_ERROR_MSG, (Object)excludeFilePath));
                    }
                }
                fileSets = new ArrayList<FileSet>();
                includesFiles = new ArrayList<File>();
                newContainerMap = new HashMap<String, Container>();
                for (Map.Entry<K, V> entry : outputDirToContainerMap.entrySet()) {
                    resolvedFileSet = null;
                    includesFile = null;
                    includesFileOutput = null;
                    containers = (List)entry.getValue();
                    outputsDir = new File((String)entry.getKey());
                    outputsDirPath = outputsDir.getCanonicalPath();
                    timestamp = PackageHFSFilesTask.getTimestampFromBuildRequest(this);
                    for (Container container : containers) {
                        this.getProject().log("Adding container: \"" + container.getName() + "\"", 4);
                        containerHasWildcard = container.getName().contains("*") != false || container.getName().contains("?") != false;
                        resources = container.getResourcesIterator();
                        while (resources.hasNext()) {
                            resource = (Resource)resources.next();
                            relativePath = HFSUtil.getNormalizedPath((Container)container, (Resource)resource);
                            if (containerHasWildcard || resource.getName().contains("*") || resource.getName().contains("?")) ** GOTO lbl70
                            resolvedFile = new File(String.valueOf(outputsDirPath) + File.separator + relativePath);
                            this.getProject().log("Adding file: \"" + relativePath + "\"", 4);
                            if (resolvedFile.exists()) {
                                resolvedFiles = new String[]{relativePath};
                            } else {
                                if (excludeManifest != null && this.pathMatchesExclude(relativePath, excludeManifest)) {
                                    this.getProject().log("Skipping missing file " + relativePath + " because it matches an exclude filter", 4);
                                    continue;
                                }
                                throw new BuildException(NLS.bind((String)Messages.PackageHFSFilesTask_FILE_NOT_FOUND, (Object[])new Object[]{resolvedFile.getAbsolutePath(), container.getName(), resource.getName()}));
lbl70:
                                // 1 sources

                                this.getProject().log("Resolving resource: \"" + relativePath + "\"", 4);
                                fileSet = new FileSet();
                                fileSet.setDir(outputsDir);
                                fileSet.createInclude().setName(relativePath);
                                if (excludeManifest != null) {
                                    HFSUtil.addContainersToFileSet((FileSet)fileSet, (List)excludeManifest.getContainers(), (boolean)false);
                                }
                                scanner = fileSet.getDirectoryScanner(this.getProject());
                                var33_39 = resolvedFiles = scanner.getIncludedFiles();
                                var32_36 = resolvedFiles.length;
                                var31_34 = 0;
                                while (var31_34 < var32_36) {
                                    resolvedFile = var33_39[var31_34];
                                    this.getProject().log("Adding file: " + resolvedFile, 4);
                                    ++var31_34;
                                }
                            }
                            directoryToResourceMapping = new HashMap<K, V>();
                            var32_37 = resolvedFiles;
                            var31_34 = resolvedFiles.length;
                            resolvedFile = 0;
                            while (resolvedFile < var31_34) {
                                resolvedFile = var32_37[resolvedFile];
                                lastIndexofSlash = resolvedFile.lastIndexOf(File.separator);
                                if (lastIndexofSlash != -1) {
                                    HFSUtil.collectFileInformation((String)(String.valueOf(outputsDirPath) + File.separator + resolvedFile.substring(0, lastIndexofSlash)), (String)resolvedFile.substring(lastIndexofSlash + 1), (Date)timestamp, directoryToResourceMapping, (Project)this.getProject(), (Resource)resource);
                                } else {
                                    HFSUtil.collectFileInformation((String)outputsDirPath, (String)resolvedFile, (Date)timestamp, directoryToResourceMapping, (Project)this.getProject(), (Resource)resource);
                                }
                                ++resolvedFile;
                            }
                            if (directoryToResourceMapping.size() <= 0) continue;
                            if (resolvedFileSet == null) {
                                includesFile = new File(this.packageDir + File.separator + "packageManifest.asHFSFileSet-" + System.currentTimeMillis());
                                includesFileOutput = this.preview != false ? null : new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(includesFile), "UTF-8")));
                                resolvedFileSet = new FileSet();
                                resolvedFileSet.setProject(this.getProject());
                                resolvedFileSet.setDir(outputsDir);
                                resolvedFileSet.setIncludesfile(includesFile);
                            }
                            containerNames = directoryToResourceMapping.keySet();
                            for (String containerName : containerNames) {
                                containerIsOutputsDir = false;
                                if (!containerName.startsWith(String.valueOf(outputsDirPath) + File.separator) && !(containerIsOutputsDir = containerName.equals(outputsDirPath))) continue;
                                newContainerName = containerIsOutputsDir != false ? "." : containerName.substring(outputsDirPath.length() + 1);
                                newContainer = (Container)newContainerMap.get(newContainerName);
                                if (newContainer == null) {
                                    newContainer = new Container();
                                    newContainer.setName(newContainerName);
                                    newContainer.setType("directory");
                                    newContainer.setRootDir(container.getRootDir());
                                    newContainer.setDeployType(container.getDeployType());
                                    newContainer.setProperties(container.getProperties());
                                    newContainerMap.put(newContainerName, newContainer);
                                    packageManifest.addContainer(newContainer);
                                }
                                newResources = (HashSet)directoryToResourceMapping.get(containerName);
                                for (Resource newResource : newResources) {
                                    newContainer.addResource(newResource);
                                    if (includesFileOutput == null) continue;
                                    if (containerIsOutputsDir) {
                                        includesFileOutput.println(newResource.getName());
                                        continue;
                                    }
                                    includesFileOutput.println(String.valueOf(newContainer.getName()) + File.separator + newResource.getName());
                                }
                            }
                        }
                    }
                    if (!this.preview && includesFileOutput != null) {
                        includesFileOutput.flush();
                        includesFileOutput.close();
                        includesFiles.add(includesFile);
                    }
                    if (resolvedFileSet == null) continue;
                    fileSets.add(resolvedFileSet);
                }
                if (deletionContainers.size() > 0 || fileSets.size() > 0) {
                    if (!this.preview && fileSets.size() > 0) {
                        HFSUtil.createTar(fileSets, (File)new File(this.packageDir, this.outputFile), (String)"HFS", (Project)this.getProject());
                    }
                    HFSUtil.serializeManifest((Manifest)packageManifest, (File)packageManifestFile);
                } else {
                    this.getProject().log(Messages.PackageHFSFilesTask_NOTHING_TO_PACKAGE_INFO_MSG, 2);
                }
                for (File includesFile : includesFiles) {
                    includesFile.delete();
                }
            }
            catch (Exception e) {
                throw new BuildException((Throwable)e);
            }
        }
        throw new BuildException(NLS.bind((String)Messages.PackageHFSFilesTask_SHIP_LIST_FILE_DOES_NOT_EXIST_ERROR_MSG, (Object)(this.shiplist == null ? "" : this.shiplist.getAbsolutePath())));
    }

    private File resolveOutputsDir() {
        File outputsDir;
        if (this.getRootDir() != null && !this.getRootDir().isEmpty()) {
            outputsDir = new File(this.getRootDir());
        } else {
            String outputsDirProperty = this.getProject().getProperty("team.enterprise.packaging.hfs.buildRoot.dir");
            if (outputsDirProperty == null || outputsDirProperty.trim().isEmpty()) {
                throw new BuildException(NLS.bind((String)Messages.PackageHFSFilesTask_MISSING_HFS_OUTPUTS_DIR_PROPERTY, (Object)"team.enterprise.packaging.hfs.buildRoot.dir"));
            }
            outputsDir = new File(outputsDirProperty);
        }
        if (!outputsDir.exists()) {
            throw new BuildException(NLS.bind((String)Messages.PackageHFSFilesTask_HFS_OUTPUTS_DIR_DOES_NOT_EXIST, (Object)outputsDir.getAbsolutePath()));
        }
        if (!outputsDir.isDirectory()) {
            throw new BuildException(NLS.bind((String)Messages.PackageHFSFilesTask_HFS_OUTPUTS_DIR_NOT_A_DIR, (Object)outputsDir.getAbsolutePath()));
        }
        return outputsDir;
    }

    private boolean pathMatchesExclude(String relativePath, Manifest excludeManifest) {
        for (Container container : HFSUtil.getHFSContainers((List)excludeManifest.getContainers(), (boolean)false)) {
            Iterator resources = container.getResourcesIterator();
            while (resources.hasNext()) {
                Resource resource = (Resource)resources.next();
                String matchAgainst = HFSUtil.getNormalizedPath((Container)container, (Resource)resource);
                if (!SelectorUtils.matchPath((String)matchAgainst, (String)relativePath, (boolean)true)) continue;
                return true;
            }
        }
        return false;
    }

    public static Date getTimestampFromBuildRequest(Task task) {
        String timestamp = task.getProject().getProperty("team.package.common.packageBinariesSinceTimestamp");
        if (timestamp == null || timestamp.trim().isEmpty()) {
            return null;
        }
        Date baseTimestamp = null;
        try {
            if (timestamp.indexOf("-") > 0) {
                timestamp = String.valueOf(timestamp.substring(0, 8)) + timestamp.substring(9, 15);
            }
            baseTimestamp = new SimpleDateFormat("yyyyMMddHHmmss").parse(timestamp);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        task.getProject().log(task, NLS.bind((String)Messages.PackageHFSFilesTask_PACKAGING_OBJECTS_NEWER_THAN_TIMESTAMP_INFO_MSG, (Object)baseTimestamp.toString()), 2);
        return baseTimestamp;
    }

    public void setManifest(File manifest) {
        this.shiplist = manifest;
    }

    public void setPackageDir(File packageDir) {
        this.packageDir = packageDir;
    }

    public void setOutputFile(String outputFile) {
        this.outputFile = outputFile;
    }

    public void setPreview(boolean preview) {
        this.preview = preview;
    }

    public void setUseContainerRootDir(boolean value) {
        this.useContainerRootDir = value;
    }

    public String getRootDir() {
        return this.rootDir;
    }

    public void setRootDir(String rootDir) {
        this.rootDir = rootDir;
    }
}

