/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.packaging.ant;

import com.ibm.team.build.client.ClientFactory;
import com.ibm.team.build.common.BuildItemFactory;
import com.ibm.team.build.common.model.IBuildEngine;
import com.ibm.team.build.common.model.IBuildEngineHandle;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultContribution;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.enterprise.automation.ant.RepositoryTask;
import com.ibm.team.enterprise.automation.common.resultcontributions.AutomationResultContribution;
import com.ibm.team.enterprise.automation.manifest.Container;
import com.ibm.team.enterprise.automation.manifest.Manifest;
import com.ibm.team.enterprise.automation.manifest.ManifestReader;
import com.ibm.team.enterprise.automation.manifest.Resource;
import com.ibm.team.enterprise.packaging.ant.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.BuildException;

public class RecordPackagedObjectsTask
extends RepositoryTask {
    private String filesystemType;
    private String buildEngineUUID;
    private String buildResultUUID;
    private String packageLabel;
    private String packageDir;

    public void execute() throws BuildException {
        HashSet<String> workItemUUIDs = new HashSet<String>();
        ArrayList<IBuildResultContribution> contributions = new ArrayList<IBuildResultContribution>();
        IBuildResultContribution summaryContribution = BuildItemFactory.createBuildResultContribution();
        IBuildEngine buildEngine = this.getBuildEngine();
        String hostname = buildEngine.getConfigurationElement("com.ibm.rational.buildforge.buildagent").getConfigurationProperty("com.ibm.rational.buildforge.buildagent.hostname").getValue();
        summaryContribution.setLabel(this.filesystemType);
        summaryContribution.setExtendedContributionTypeId(AutomationResultContribution.PACKAGING_OVERVIEW_EXTENDED_CONTRIBUTION_ID);
        summaryContribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_PACKAGE_LABEL, this.packageLabel);
        summaryContribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_DESCRIPTION, "");
        summaryContribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_HOST_NAME, hostname);
        summaryContribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_PACKAGE_DIR, this.packageDir);
        summaryContribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_TIMESTAMP, this.convert2Timestamp(this.packageLabel));
        contributions.add(summaryContribution);
        File manifestFile = new File(this.packageDir, "packageManifest.xml");
        if (manifestFile.exists()) {
            Manifest packageManifest = this.getManifest(manifestFile);
            List packagedContainers = packageManifest.getContainers();
            for (Container packagedContainer : packagedContainers) {
                Iterator resourceIterator = packagedContainer.getResourcesIterator();
                while (resourceIterator.hasNext()) {
                    IBuildResultContribution contribution = BuildItemFactory.createBuildResultContribution();
                    contribution.setExtendedContributionTypeId(AutomationResultContribution.PACKAGED_OBJECT_EXTENDED_CONTRIBUTION_ID);
                    Resource resource = (Resource)resourceIterator.next();
                    contribution.setLabel(resource.getName());
                    contribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_CONTAINER, packagedContainer.getName());
                    contribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_LAST_MODIFIED, resource.getLastModifiedTimestamp());
                    contribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_WORKITEM, resource.getWorkItemId());
                    contribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_WORKITEM_UUID, resource.getWorkitemUUID());
                    contribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_OBJECTTYPE, resource.getIbmiType());
                    contribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_OBJECTSUBTYPE, resource.getIbmiAttrribute());
                    contribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_RESOURCE_TYPE, resource.getType());
                    contribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_CONTAINER_TYPE, packagedContainer.getType());
                    if (resource.getWorkitemUUID() != null) {
                        workItemUUIDs.add(resource.getWorkitemUUID());
                    }
                    contributions.add(contribution);
                }
            }
            this.addBuildResultContributions(contributions);
        }
    }

    private Manifest getManifest(File manifestFile) throws BuildException {
        try {
            return ManifestReader.getInstance().getManifest(manifestFile);
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    private void addBuildResultContributions(List<IBuildResultContribution> contributions) throws BuildException {
        try {
            IBuildResult buildResult = this.getBuildResult();
            ClientFactory.getTeamBuildClient((ITeamRepository)this.getTeamRepository()).addBuildResultContributions((IBuildResultHandle)buildResult, contributions.toArray(new IBuildResultContribution[contributions.size()]), null);
        }
        catch (TeamRepositoryException e) {
            throw new BuildException((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new BuildException((Throwable)e);
        }
        catch (FileNotFoundException e) {
            throw new BuildException((Throwable)e);
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    private IBuildEngine getBuildEngine() throws BuildException {
        if (this.buildEngineUUID == null) {
            throw new BuildException(Messages.RecordPackagedObjectsTask_BUILD_ENGINE_UUID_IS_NULL_ERROR_MSG);
        }
        try {
            IBuildEngineHandle buildEngineHandle = (IBuildEngineHandle)IBuildEngine.ITEM_TYPE.createItemHandle(UUID.valueOf((String)this.buildEngineUUID), null);
            return (IBuildEngine)this.getTeamRepository().itemManager().fetchCompleteItem((IItemHandle)buildEngineHandle, 0, null);
        }
        catch (TeamRepositoryException e) {
            throw new BuildException((Throwable)e);
        }
        catch (FileNotFoundException e) {
            throw new BuildException((Throwable)e);
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    private IBuildResult getBuildResult() throws BuildException {
        if (this.buildResultUUID == null) {
            throw new BuildException(Messages.RecordPackagedObjectsTask_BUILD_RESULT_UUID_IS_NULL_ERROR_MSG);
        }
        try {
            IBuildResultHandle buildResultHandle = (IBuildResultHandle)IBuildResult.ITEM_TYPE.createItemHandle(UUID.valueOf((String)this.buildResultUUID), null);
            return (IBuildResult)this.getTeamRepository().itemManager().fetchCompleteItem((IItemHandle)buildResultHandle, 0, null);
        }
        catch (TeamRepositoryException e) {
            throw new BuildException((Throwable)e);
        }
        catch (FileNotFoundException e) {
            throw new BuildException((Throwable)e);
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    public void setBuildEngineUUID(String buildEngineUUID) {
        this.buildEngineUUID = buildEngineUUID;
    }

    public void setBuildResultUUID(String buildResultUUID) {
        this.buildResultUUID = buildResultUUID;
    }

    public void setPackageLabel(String packageLabel) {
        this.packageLabel = packageLabel;
    }

    public void setPackageDir(String packageDir) {
        this.packageDir = packageDir;
    }

    public void setFilesystemType(String filesystemType) {
        this.filesystemType = filesystemType;
    }

    private String convert2Timestamp(String packageLabel) {
        try {
            return String.valueOf(new SimpleDateFormat("yyyyMMdd-HHmmssSSSS").parse(packageLabel).getTime());
        }
        catch (Exception e) {
            return "";
        }
    }
}

