/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.packaging.common.util;

import com.ibm.team.enterprise.packaging.common.util.VerboseInput;
import com.ibm.team.scm.common.IVersionableHandle;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Output {
    private String fDataSet;
    private String fMember;
    private String fTimestamp;
    private String fWorkItemNumber;
    private String fWorkItemUUID;
    private String fOutputType;
    private String fLanguageDefUUID;
    private String fLanguageDefName;
    private boolean fIsDeletion;
    private String fDeployType;
    private boolean fIsExactMatch;
    private String fVersionId;
    private IVersionableHandle fVersionable;
    private boolean fHFS;
    private final Map<String, String> fProperties;
    private String fBuildMapUrl;
    private List<VerboseInput> fInputs;

    public Output(String buildPath, String buildFile, String outputType, String timestamp, String workItemNumber, String workItemUUID, String languageDefUUID, String languageDefName, boolean isDeletion, boolean isHFS) {
        this.setDataSetName(buildPath);
        this.setMember(buildFile);
        this.setOutputType(outputType);
        this.setTimestamp(timestamp);
        this.setWorkItem(workItemNumber);
        this.setWorkItemUUID(workItemUUID);
        this.setLanguageDefUUID(languageDefUUID);
        this.setLanguageDefName(languageDefName);
        this.setIsDeletion(isDeletion);
        this.setIsExactMatch(true);
        this.setHFS(isHFS);
        this.fProperties = new HashMap<String, String>();
        this.fBuildMapUrl = null;
        this.fInputs = new LinkedList<VerboseInput>();
    }

    public void setDataSetName(String fDataSet) {
        this.fDataSet = fDataSet;
    }

    public String getDataSetName() {
        return this.fDataSet;
    }

    public void setMember(String fMember) {
        this.fMember = fMember;
    }

    public String getMember() {
        return this.fMember;
    }

    public void setTimestamp(String fTimestamp) {
        this.fTimestamp = fTimestamp;
    }

    public String getTimestamp() {
        return this.fTimestamp;
    }

    public void setWorkItem(String fWorkItem) {
        this.fWorkItemNumber = fWorkItem;
    }

    public String getWorkItem() {
        return this.fWorkItemNumber;
    }

    public void setWorkItemUUID(String fWorkItemUUID) {
        this.fWorkItemUUID = fWorkItemUUID;
    }

    public String getWorkItemUUID() {
        return this.fWorkItemUUID;
    }

    public void setOutputType(String fOutputType) {
        this.fOutputType = fOutputType;
    }

    public String getOutputType() {
        return this.fOutputType;
    }

    public void setLanguageDefUUID(String fLanguageDefUUID) {
        this.fLanguageDefUUID = fLanguageDefUUID;
    }

    public String getLanguageDefUUID() {
        return this.fLanguageDefUUID;
    }

    public void setLanguageDefName(String fLanguageDefName) {
        this.fLanguageDefName = fLanguageDefName;
    }

    public String getLanguageDefName() {
        return this.fLanguageDefName;
    }

    public void setIsDeletion(boolean isDeletion) {
        this.fIsDeletion = isDeletion;
    }

    public boolean isDeletion() {
        return this.fIsDeletion;
    }

    public String getDeployType() {
        return this.fDeployType;
    }

    public void setDeployType(String deployType) {
        if (deployType != null && !"".equals(deployType)) {
            this.fDeployType = deployType;
        }
    }

    public boolean isExactMatch() {
        return this.fIsExactMatch;
    }

    public void setIsExactMatch(boolean isExactMatch) {
        this.fIsExactMatch = isExactMatch;
    }

    public boolean isHFS() {
        return this.fHFS;
    }

    public void setHFS(boolean isHFS) {
        this.fHFS = isHFS;
    }

    public void setVersionId(String id) {
        this.fVersionId = id;
    }

    public String getVersionId() {
        return this.fVersionId;
    }

    public IVersionableHandle getVersionable() {
        return this.fVersionable;
    }

    public void setVersionable(IVersionableHandle handle) {
        this.fVersionable = handle;
    }

    public Map<String, String> getProperties() {
        return this.fProperties;
    }

    public String getBuildMapUrl() {
        return this.fBuildMapUrl;
    }

    public void setBuildMapUrl(String buildMapUrl) {
        this.fBuildMapUrl = buildMapUrl;
    }

    public List<VerboseInput> getInputs() {
        return this.fInputs;
    }

    public void setInputs(List<VerboseInput> inputs) {
        this.fInputs = inputs;
    }

    public void addInput(VerboseInput input) {
        if ("SELF".equals(input.getCompileType())) {
            this.fInputs.add(0, input);
        } else {
            this.fInputs.add(input);
        }
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Output)) {
            return false;
        }
        Output _other = (Output)other;
        if (this.fHFS != _other.fHFS) {
            return false;
        }
        if (!this.fDataSet.equals(_other.getDataSetName())) {
            return false;
        }
        if (!this.fMember.equals(_other.getMember())) {
            return false;
        }
        return this.fOutputType == null || this.fOutputType.equals(_other.getOutputType());
    }

    public int hashCode() {
        String hashString = String.valueOf(this.fDataSet) + this.fMember;
        if (this.fOutputType != null) {
            hashString = String.valueOf(hashString) + this.fOutputType;
        }
        return hashString.hashCode();
    }
}

