/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.packaging.common.util;

import com.ibm.team.enterprise.automation.manifest.BuildMapInputGroup;
import com.ibm.team.enterprise.automation.manifest.Container;
import com.ibm.team.enterprise.automation.manifest.Input;
import com.ibm.team.enterprise.automation.manifest.Manifest;
import com.ibm.team.enterprise.automation.manifest.ManifestReader;
import com.ibm.team.enterprise.automation.manifest.ManifestWriter;
import com.ibm.team.enterprise.automation.manifest.Resource;
import com.ibm.team.enterprise.automation.manifest.ResourceContainer;
import com.ibm.team.enterprise.packaging.common.util.Output;
import com.ibm.team.enterprise.packaging.common.util.VerboseInput;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class CreateShiplistUtil {
    static final String ASTERIX = "*";

    public static void createZOSShiplistFromString(String mvsShiplist, String hfsShiplist, String delimiter, File file) throws Exception {
        CreateShiplistUtil.createZOS_ccsid_ShiplistFromString(mvsShiplist, hfsShiplist, delimiter, "IBM-1047", file);
    }

    public static void createZOS_ccsid_ShiplistFromString(String mvsShiplist, String hfsShiplist, String delimiter, String encoding, File file) throws Exception {
        Container container;
        HashMap<String, ArrayList<String>> pdsToMembers = new HashMap<String, ArrayList<String>>();
        ArrayList<String> sequentials = new ArrayList<String>();
        if (mvsShiplist != null) {
            StringTokenizer tokenizer = new StringTokenizer(mvsShiplist, delimiter);
            while (tokenizer.hasMoreElements()) {
                String token = tokenizer.nextToken();
                int index = token.indexOf("(");
                if (index < 0) {
                    sequentials.add(token);
                    continue;
                }
                String pds = token.substring(0, index);
                String member = token.substring(index + 1, token.length() - 1);
                ArrayList<String> members = (ArrayList<String>)pdsToMembers.get(pds);
                if (members == null) {
                    members = new ArrayList<String>();
                }
                members.add(member);
                pdsToMembers.put(pds, members);
            }
        }
        Manifest manifest = new Manifest();
        manifest.setType("MANIFEST_SHIPLIST");
        ManifestWriter writer = ManifestWriter.getInstance();
        Set pdss = pdsToMembers.keySet();
        for (String pds : pdss) {
            container = new Container();
            container.setType("PDS");
            container.setName(pds.toUpperCase());
            List members = (List)pdsToMembers.get(pds);
            for (String member : members) {
                Resource resource = new Resource();
                resource.setName(member.toUpperCase());
                resource.setType("PDSMember");
                container.addResource(resource);
            }
            manifest.addContainer(container);
        }
        for (String s : sequentials) {
            container = new Container();
            container.setType("sequential");
            container.setName(s);
            manifest.addContainer(container);
        }
        CreateShiplistUtil.processHFSResources(manifest, hfsShiplist);
        writer.write(file, encoding, manifest);
    }

    private static void processHFSResources(Manifest manifest, String hfsShiplist) {
        HashMap hfsDirsToPatterns = new HashMap();
        if (hfsShiplist != null) {
            List<String> segments = CreateShiplistUtil.parseHFSEntries(hfsShiplist);
            int i = 0;
            while (i + 1 < segments.size()) {
                ArrayList<String> patterns;
                String dir = segments.get(i);
                String pattern = segments.get(i + 1);
                if (dir.isEmpty()) {
                    dir = ".";
                }
                if (pattern.isEmpty()) {
                    pattern = "**";
                }
                if ((patterns = (ArrayList<String>)hfsDirsToPatterns.get(dir)) == null) {
                    patterns = new ArrayList<String>();
                    hfsDirsToPatterns.put(dir, patterns);
                }
                if (!patterns.contains(pattern)) {
                    patterns.add(pattern);
                }
                i += 2;
            }
        }
        for (String dir : hfsDirsToPatterns.keySet()) {
            Container container = new Container();
            container.setType("directory");
            container.setName(dir);
            List patterns = (List)hfsDirsToPatterns.get(dir);
            for (String pattern : patterns) {
                Resource resource = new Resource();
                resource.setName(pattern);
                resource.setType("file");
                container.addResource(resource);
            }
            manifest.addContainer(container);
        }
    }

    public static void createIBMiShiplistFromString(String libraryShiplist, String hfsShiplist, String delimiter, File file) throws Exception {
        HashMap<String, ArrayList<String>> librariesToObjects = new HashMap<String, ArrayList<String>>();
        if (libraryShiplist != null) {
            StringTokenizer tokenizer = new StringTokenizer(libraryShiplist, delimiter);
            while (tokenizer.hasMoreElements()) {
                String token = tokenizer.nextToken();
                int index = token.indexOf("(");
                String library = token.substring(0, index);
                String object = token.substring(index + 1, token.length() - 1);
                ArrayList<String> objects = (ArrayList<String>)librariesToObjects.get(library);
                if (objects == null) {
                    objects = new ArrayList<String>();
                }
                objects.add(object);
                librariesToObjects.put(library, objects);
            }
        }
        Manifest manifest = new Manifest();
        manifest.setType("MANIFEST_SHIPLIST");
        ManifestWriter writer = ManifestWriter.getInstance();
        Set libraries = librariesToObjects.keySet();
        for (String library : libraries) {
            Container container = new Container();
            container.setType("IBMiLibrary");
            container.setName(library);
            List objects = (List)librariesToObjects.get(library);
            for (String object : objects) {
                Resource resource = new Resource();
                int ind = object.indexOf(")");
                int ind2 = object.indexOf("OBJTYPE(");
                String objectName = object.substring(0, ind);
                String objectType = object.substring(ind2 + 8, object.length());
                resource.setName(objectName);
                resource.setIbmiType(objectType);
                resource.setType("IBMiObject");
                container.addResource(resource);
            }
            manifest.addContainer(container);
        }
        CreateShiplistUtil.processHFSResources(manifest, hfsShiplist);
        writer.write(file, "UTF-8", manifest);
    }

    public static void createZOSShiplistFromWorkItems(Map<String, List<Output>> outputs, File file, Map<String, String> globalProperties, boolean applyHfsContainerDeployType) throws Exception {
        CreateShiplistUtil.createShiplistFromWorkItems("PDS", "PDSMember", false, "IBM-1047", outputs, file, globalProperties, applyHfsContainerDeployType);
    }

    public static void createZOSShiplistFromWorkItems(Map<String, List<Output>> outputs, File file, boolean applyHfsContainerDeployType) throws Exception {
        CreateShiplistUtil.createShiplistFromWorkItems("PDS", "PDSMember", false, "IBM-1047", outputs, file, new HashMap<String, String>(), applyHfsContainerDeployType);
    }

    public static void createZOS_UTF8_ShiplistFromWorkItems(Map<String, List<Output>> outputs, File file, Map<String, String> globalProperties, boolean applyHfsContainerDeployType) throws Exception {
        CreateShiplistUtil.createShiplistFromWorkItems("PDS", "PDSMember", false, "UTF-8", outputs, file, globalProperties, applyHfsContainerDeployType);
    }

    public static void createIBMiShiplistFromWorkItems(Map<String, List<Output>> outputs, File file) throws Exception {
        CreateShiplistUtil.createShiplistFromWorkItems("IBMiLibrary", "IBMiObject", true, "UTF-8", outputs, file, new HashMap<String, String>(), false);
    }

    private static void createShiplistFromWorkItems(String containerType, String resourceType, boolean isIBMiTemplate, String encoding, Map<String, List<Output>> outputs, File file, Map<String, String> globalProperties, boolean applyHfsContainerDeployType) throws Exception {
        Container container;
        Manifest manifest = new Manifest();
        manifest.setType("MANIFEST_SHIPLIST");
        ManifestWriter writer = ManifestWriter.getInstance();
        manifest.setProperties(globalProperties);
        Set<String> datasets = outputs.keySet();
        ArrayList<Output> sequentialOutputs = new ArrayList<Output>();
        ArrayList<Output> sequentialDeletions = new ArrayList<Output>();
        for (String dataSet : datasets) {
            Resource resource;
            Container deletedContainer;
            Container container2;
            List<Output> dsOutputs = outputs.get(dataSet);
            Output sOut = dsOutputs.get(0);
            if (!sOut.isHFS() && sOut.getMember().length() <= 0) {
                if (sOut.isDeletion()) {
                    sequentialDeletions.add(sOut);
                    continue;
                }
                sequentialOutputs.add(sOut);
                continue;
            }
            ArrayList<Output> hfsOutputs = new ArrayList<Output>();
            ArrayList<Output> nonHfsOutputs = new ArrayList<Output>();
            for (Output output : dsOutputs) {
                if (output.isHFS()) {
                    hfsOutputs.add(output);
                    continue;
                }
                nonHfsOutputs.add(output);
            }
            if (!nonHfsOutputs.isEmpty()) {
                container2 = new Container();
                deletedContainer = null;
                container2.setType(containerType);
                if (isIBMiTemplate) {
                    container2.setName(dataSet);
                } else {
                    container2.setName(dataSet.toUpperCase());
                }
                for (Output output : nonHfsOutputs) {
                    resource = new Resource();
                    resource.getProperties().putAll(output.getProperties());
                    if (isIBMiTemplate) {
                        resource.setName(output.getMember());
                    } else {
                        resource.setName(output.getMember().toUpperCase());
                    }
                    resource.setType(resourceType);
                    resource.setLastModifiedTimestamp(output.getTimestamp());
                    resource.setWorkItemId(output.getWorkItem());
                    resource.setWorkitemUUID(output.getWorkItemUUID());
                    resource.setLanguageDefinitionUUID(output.getLanguageDefUUID());
                    resource.setLanguageDefinitionName(output.getLanguageDefName());
                    resource.setDeployType(output.getDeployType());
                    resource.setVersionId(output.getVersionId());
                    if (isIBMiTemplate) {
                        resource.setIbmiType(output.getOutputType());
                    }
                    CreateShiplistUtil.addBuildMapInputs(output, (ResourceContainer)resource);
                    if (output.isDeletion()) {
                        if (deletedContainer == null) {
                            deletedContainer = new Container();
                            deletedContainer.setType(containerType);
                            if (isIBMiTemplate) {
                                deletedContainer.setName(dataSet);
                            } else {
                                deletedContainer.setName(dataSet.toUpperCase());
                            }
                        }
                        deletedContainer.addResource(resource);
                        continue;
                    }
                    container2.addResource(resource);
                }
                manifest.addContainer(container2);
                if (deletedContainer != null) {
                    manifest.addDeletedContainer(deletedContainer);
                }
            }
            if (hfsOutputs.isEmpty()) continue;
            container2 = new Container();
            deletedContainer = null;
            container2.setType("directory");
            container2.setName(dataSet);
            for (Output output : hfsOutputs) {
                resource = new Resource();
                resource.getProperties().putAll(output.getProperties());
                if (output.getMember().isEmpty()) {
                    resource.setName("**");
                } else {
                    resource.setName(output.getMember());
                }
                resource.setType("file");
                resource.setLastModifiedTimestamp(output.getTimestamp());
                resource.setWorkItemId(output.getWorkItem());
                resource.setWorkitemUUID(output.getWorkItemUUID());
                resource.setLanguageDefinitionUUID(output.getLanguageDefUUID());
                resource.setLanguageDefinitionName(output.getLanguageDefName());
                resource.setDeployType(output.getDeployType());
                resource.setVersionId(output.getVersionId());
                if (applyHfsContainerDeployType) {
                    container2.setDeployType(output.getDeployType());
                }
                if (output.isDeletion()) {
                    if (deletedContainer == null) {
                        deletedContainer = new Container();
                        deletedContainer.setType("directory");
                        deletedContainer.setName(dataSet);
                    }
                    deletedContainer.addResource(resource);
                    continue;
                }
                container2.addResource(resource);
            }
            manifest.addContainer(container2);
            if (deletedContainer == null) continue;
            manifest.addDeletedContainer(deletedContainer);
        }
        if (sequentialOutputs.size() > 0) {
            for (Output output : sequentialOutputs) {
                container = new Container();
                container.setType("sequential");
                container.setName(output.getDataSetName().toUpperCase());
                container.setWorkItemId(output.getWorkItem());
                container.setWorkitemUUID(output.getWorkItemUUID());
                container.getProperties().putAll(output.getProperties());
                CreateShiplistUtil.addBuildMapInputs(output, (ResourceContainer)container);
                manifest.addContainer(container);
            }
        }
        if (!sequentialDeletions.isEmpty()) {
            for (Output output : sequentialDeletions) {
                container = new Container();
                container.setType("sequential");
                container.setName(output.getDataSetName().toUpperCase());
                container.setWorkItemId(output.getWorkItem());
                container.setWorkitemUUID(output.getWorkItemUUID());
                container.getProperties().putAll(output.getProperties());
                manifest.addDeletedContainer(container);
            }
        }
        writer.write(file, encoding, manifest);
    }

    private static void addBuildMapInputs(Output output, ResourceContainer resourceContainer) {
        List<VerboseInput> inputs = output.getInputs();
        if (inputs == null) {
            return;
        }
        BuildMapInputGroup manifestInputGroup = new BuildMapInputGroup();
        manifestInputGroup.setUrl(output.getBuildMapUrl());
        for (VerboseInput input : inputs) {
            Input manifestInput = new Input(input.getName(), input.getVersionId(), input.getCompileType(), input.getUrl());
            manifestInputGroup.addInput(manifestInput);
        }
        resourceContainer.setBuildMapInputGroup(manifestInputGroup);
    }

    public static void removeUcdAttributesFromManifest(File inputFile, File outputFile, String outputCCSID, String rootDir) throws Exception {
        Manifest manifest = ManifestReader.getInstance().getManifest(inputFile);
        CreateShiplistUtil.removeUcdAttributesFromContainers(manifest.getContainers(), rootDir);
        CreateShiplistUtil.removeUcdAttributesFromContainers(manifest.getDeletedContainers(), rootDir);
        ManifestWriter.getInstance().write(outputFile, outputCCSID, manifest);
    }

    private static void removeUcdAttributesFromContainers(List<Container> containers, String rootDir) {
        for (Container container : containers) {
            if ("sequential".equals(container.getType())) continue;
            if ("directory".equals(container.getType())) {
                container.setRootDir(rootDir);
            }
            Iterator resourceIterator = container.getResourcesIterator();
            while (resourceIterator.hasNext()) {
                Resource resource = (Resource)resourceIterator.next();
                resource.setLastModifiedTimestamp(null);
            }
        }
    }

    public static void removeHfsContainersFromManifest(File inputFile, File outputFile, String outputCCSID) throws Exception {
        Manifest manifest = ManifestReader.getInstance().getManifest(inputFile);
        List containers = manifest.getContainers();
        Iterator containerIterator = containers.iterator();
        while (containerIterator.hasNext()) {
            Container container = (Container)containerIterator.next();
            if (!"directory".equals(container.getType())) continue;
            containerIterator.remove();
        }
        ManifestWriter.getInstance().write(outputFile, outputCCSID, manifest);
    }

    public static String convertHFSEntriesToProperty(Collection<String> segments) {
        StringBuilder buf = new StringBuilder();
        for (String segment : segments) {
            segment = segment.replaceAll("%", "%25").replaceAll(":", "%3A");
            buf.append(segment);
            buf.append(':');
        }
        return buf.toString();
    }

    public static List<String> parseHFSEntries(String propertyValue) {
        String[] tokens;
        ArrayList<String> segments = new ArrayList<String>();
        String[] stringArray = tokens = propertyValue.split(":", -1);
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            token = token.replaceAll("%3A", ":").replaceAll("%25", "%");
            segments.add(token);
            ++n2;
        }
        return segments;
    }

    public static String joinHFSSegments(String directory, String pattern) {
        StringBuilder joined = new StringBuilder(directory == null ? "" : directory);
        if (pattern != null && !pattern.isEmpty()) {
            if (joined.length() > 0 && joined.charAt(joined.length() - 1) != '/') {
                joined.append('/');
            }
            joined.append(pattern);
        }
        return joined.toString();
    }

    public static boolean containsNoZOSGenericDatasetNames(String mvsShiplist, String delimiter) {
        return mvsShiplist == null || !mvsShiplist.contains(ASTERIX);
    }
}

