/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.packaging.common.jfs.impl;

import com.ibm.team.enterprise.automation.common.helper.DataTypeConverter;
import com.ibm.team.enterprise.automation.common.jfs.AbstractJFSParser;
import com.ibm.team.enterprise.automation.common.jfs.IJFSParser;
import com.ibm.team.enterprise.automation.common.jfs.IJFSResource;
import com.ibm.team.enterprise.packaging.common.jfs.IPackage;
import com.ibm.team.enterprise.packaging.common.jfs.PackageJFSConstants;
import com.ibm.team.enterprise.packaging.common.jfs.impl.Package;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PackageJFSParser
extends AbstractJFSParser
implements IJFSParser,
PackageJFSConstants {
    public IJFSResource toJFSResource(String rdfXml) throws TeamRepositoryException {
        if (rdfXml == null || "".equals(rdfXml)) {
            return null;
        }
        try {
            Document doc = PackageJFSParser.newDocument((InputStream)new ByteArrayInputStream(rdfXml.getBytes("UTF-8")));
            NodeList rdfDescriptionElements = doc.getElementsByTagName("rdf:Description");
            if (rdfDescriptionElements.getLength() > 0) {
                Element rdfDescriptionElement = (Element)rdfDescriptionElements.item(0);
                return this.createPackage(rdfDescriptionElement);
            }
        }
        catch (Exception e) {
            throw new TeamRepositoryException((Throwable)e);
        }
        return null;
    }

    public String toRDFXML(IJFSResource jfsResource) throws TeamRepositoryException {
        try {
            IPackage pkg = (IPackage)jfsResource;
            Document doc = PackageJFSParser.newDocument();
            Element rdfElement = doc.createElement("rdf:RDF");
            doc.appendChild(rdfElement);
            rdfElement.setAttribute("xmlns:rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
            rdfElement.setAttribute("xmlns:package", "http://www.ibm.com/team/enterprise/package/");
            rdfElement.setAttribute("xmlns:manifest", "http://www.ibm.com/team/enterprise/package/manifest/");
            Element rdfDescriptionElement = doc.createElement("rdf:Description");
            rdfDescriptionElement.setAttribute("rdf:about", pkg.getSlug());
            rdfElement.appendChild(rdfDescriptionElement);
            PackageJFSParser.createPropertyNode((Document)doc, (Element)rdfDescriptionElement, (String)"package:packageResultUUID", (String)pkg.getBuildResultUUID().getUuidValue());
            PackageJFSParser.createPropertyNode((Document)doc, (Element)rdfDescriptionElement, (String)"package:packageDefinitionUUID", (String)pkg.getBuildDefinitionUUID().getUuidValue());
            PackageJFSParser.createPropertyNode((Document)doc, (Element)rdfDescriptionElement, (String)"package:label", (String)pkg.getLabel());
            PackageJFSParser.createPropertyNode((Document)doc, (Element)rdfDescriptionElement, (String)"package:timestamp", (String)String.valueOf(pkg.getTimestamp()));
            PackageJFSParser.createPropertyNode((Document)doc, (Element)rdfDescriptionElement, (String)"package:location", (String)pkg.getLocation());
            PackageJFSParser.createPropertyNode((Document)doc, (Element)rdfDescriptionElement, (String)"package:markedForDeletion", (String)String.valueOf(pkg.isMarkedForDeletion()));
            PackageJFSParser.createPropertyNode((Document)doc, (Element)rdfDescriptionElement, (String)"package:summaryWorkItemId", (String)String.valueOf(pkg.getSummaryWorkItemId()));
            PackageJFSParser.createPropertyNode((Document)doc, (Element)rdfDescriptionElement, (String)"package:summaryWorkItemUUID", (String)DataTypeConverter.toString((UUID)pkg.getSummaryWorkItemUUID()));
            Element manifestElement = PackageJFSParser.createXMLLiteralElement((Document)doc, (Element)rdfDescriptionElement, (String)"package:manifest");
            PackageJFSParser.createContainerElements((Document)doc, pkg.getContainers(), (Element)manifestElement);
            return PackageJFSParser.transform((Document)doc);
        }
        catch (Exception e) {
            throw new TeamRepositoryException((Throwable)e);
        }
    }

    private IPackage createPackage(Element packageElement) {
        String buildResultUUID = PackageJFSParser.getElementValue((Element)packageElement, (String)"package:packageResultUUID");
        String buildDefinitionUUID = PackageJFSParser.getElementValue((Element)packageElement, (String)"package:packageDefinitionUUID");
        Package pkg = new Package(UUID.valueOf((String)buildResultUUID), UUID.valueOf((String)buildDefinitionUUID));
        pkg.setLabel(PackageJFSParser.getElementValue((Element)packageElement, (String)"package:label"));
        pkg.setTimestamp(Long.parseLong(PackageJFSParser.getElementValue((Element)packageElement, (String)"package:timestamp")));
        pkg.setSummaryWorkItemId(Integer.parseInt(PackageJFSParser.getElementValue((Element)packageElement, (String)"package:summaryWorkItemId")));
        pkg.setSummaryWorkItemUUID(DataTypeConverter.toUUID((String)PackageJFSParser.getElementValue((Element)packageElement, (String)"package:summaryWorkItemUUID")));
        pkg.setMarkForDeletion(Boolean.valueOf(PackageJFSParser.getElementValue((Element)packageElement, (String)"package:markedForDeletion")));
        pkg.setLocation(PackageJFSParser.getElementValue((Element)packageElement, (String)"package:location"));
        NodeList containerNodes = packageElement.getElementsByTagName("manifest:container");
        int i = 0;
        while (i < containerNodes.getLength()) {
            Element containerElement = (Element)containerNodes.item(i);
            pkg.addContainer(this.parseContainer(containerElement));
            ++i;
        }
        return pkg;
    }
}

