/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.packaging.common.jfs.impl;

import com.ibm.team.enterprise.automation.manifest.Container;
import com.ibm.team.enterprise.automation.manifest.Resource;
import com.ibm.team.enterprise.packaging.common.jfs.IPackage;
import com.ibm.team.enterprise.packaging.common.jfs.impl.PackageJFSParser;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Package
implements IPackage {
    private UUID buildResultUUID;
    private UUID buildDefinitionUUID;
    private String label;
    private long timestamp;
    private String location;
    private int summaryWorkItemId;
    private UUID summaryWorkItemUUID;
    private boolean markedForDeletion;
    private List<Container> containers;

    public Package(UUID buildResultUUID, UUID buildDefinitionUUID) {
        this.buildResultUUID = buildResultUUID;
        this.buildDefinitionUUID = buildDefinitionUUID;
        this.markedForDeletion = false;
        this.summaryWorkItemId = 0;
        this.containers = new ArrayList<Container>();
    }

    @Override
    public UUID getBuildDefinitionUUID() {
        return this.buildDefinitionUUID;
    }

    @Override
    public UUID getBuildResultUUID() {
        return this.buildResultUUID;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public int getSummaryWorkItemId() {
        return this.summaryWorkItemId;
    }

    @Override
    public boolean isMarkedForDeletion() {
        return this.markedForDeletion;
    }

    @Override
    public void setBuildDefinitionUUID(UUID uuidValue) {
        this.buildDefinitionUUID = uuidValue;
    }

    @Override
    public void setBuildResultUUID(UUID uuidValue) {
        this.buildResultUUID = uuidValue;
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public void setMarkForDeletion(boolean value) {
        this.markedForDeletion = value;
    }

    @Override
    public void setLocation(String location) {
        this.location = location;
    }

    @Override
    public void setSummaryWorkItemId(int id) {
        this.summaryWorkItemId = id;
    }

    public static final String generateSlug(String buildResultUUID, String buildDefinitionUUID) {
        StringBuffer slugBuffer = new StringBuffer("_buildResultUUID=");
        slugBuffer.append(buildResultUUID).append("_buildDefinitionUUID=").append(buildDefinitionUUID);
        return slugBuffer.toString();
    }

    public final String getSlug() {
        return Package.generateSlug(this.buildResultUUID.getUuidValue(), this.buildDefinitionUUID.getUuidValue());
    }

    public String getStoragePresentation() throws TeamRepositoryException {
        return new PackageJFSParser().toRDFXML(this);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("Package:");
        buffer.append("\nPackage Result UUID: ").append(this.buildResultUUID);
        buffer.append("\nPackage Definition UUID: ").append(this.buildDefinitionUUID);
        buffer.append("\nLabel: ").append(this.label);
        buffer.append("\nTimestamp: ").append(this.timestamp);
        buffer.append("\nPackage Location: ").append(this.location);
        buffer.append("\nSummary Work Item: ").append(this.summaryWorkItemId).append(" , ").append(this.summaryWorkItemUUID);
        buffer.append("\nIs Marked For Deletion: ").append(this.markedForDeletion);
        for (Container container : this.containers) {
            buffer.append("\nContainer: ").append(container.getName()).append(" (").append(container.getType()).append(")");
            Iterator iterator = container.getResourcesIterator();
            while (iterator.hasNext()) {
                Resource resource = (Resource)iterator.next();
                buffer.append("\n   Resource: ").append(resource.getName()).append(" (").append(resource.getType()).append(")");
                buffer.append("\n             Subtype: ").append(resource.getIbmiType());
                buffer.append("\n             Attribute: ").append(resource.getIbmiAttrribute());
                buffer.append("\n             Work Item: ").append(String.valueOf(resource.getWorkItemId()) + " , " + resource.getWorkitemUUID());
                buffer.append("\n             Last Modified Timestamp: ").append(resource.getLastModifiedTimestamp());
            }
        }
        return buffer.toString();
    }

    @Override
    public void addContainer(Container container) {
        if (this.getContainer(container.getName(), container.getChangeType()) == null) {
            this.containers.add(container);
        }
    }

    @Override
    public Container getContainer(String name) {
        return this.getContainer(name, null);
    }

    @Override
    public Container getContainer(String name, String changeType) {
        for (Container container : this.containers) {
            if (!container.getName().equals(name)) continue;
            if (changeType == null) {
                return container;
            }
            if (!changeType.equals(container.getChangeType())) continue;
            return container;
        }
        return null;
    }

    @Override
    public List<Container> getContainers() {
        return this.containers;
    }

    @Override
    public UUID getSummaryWorkItemUUID() {
        return this.summaryWorkItemUUID;
    }

    @Override
    public void setSummaryWorkItemUUID(UUID uuidValue) {
        this.summaryWorkItemUUID = uuidValue;
    }
}

