/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.packaging.common.internal.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.AbstractEnumerator;

public final class ContainerType
extends AbstractEnumerator {
    public static final int CONTAINER_TYPE_PDS = 0;
    public static final int CONTAINER_TYPE_IBMI_LIBRARY = 1;
    public static final int CONTAINER_TYPE_DIRECTORY = 2;
    public static final int CONTAINER_TYPE_SEQUENTIAL = 3;
    public static final ContainerType CONTAINER_TYPE_PDS_LITERAL = new ContainerType(0, "CONTAINER_TYPE_PDS", "PDS");
    public static final ContainerType CONTAINER_TYPE_IBMI_LIBRARY_LITERAL = new ContainerType(1, "CONTAINER_TYPE_IBMI_LIBRARY", "IBMiLibrary");
    public static final ContainerType CONTAINER_TYPE_DIRECTORY_LITERAL = new ContainerType(2, "CONTAINER_TYPE_DIRECTORY", "directory");
    public static final ContainerType CONTAINER_TYPE_SEQUENTIAL_LITERAL = new ContainerType(3, "CONTAINER_TYPE_SEQUENTIAL", "sequential");
    private static final ContainerType[] VALUES_ARRAY = new ContainerType[]{CONTAINER_TYPE_PDS_LITERAL, CONTAINER_TYPE_IBMI_LIBRARY_LITERAL, CONTAINER_TYPE_DIRECTORY_LITERAL, CONTAINER_TYPE_SEQUENTIAL_LITERAL};
    public static final List VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

    public static ContainerType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ContainerType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ContainerType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ContainerType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ContainerType get(int value) {
        switch (value) {
            case 0: {
                return CONTAINER_TYPE_PDS_LITERAL;
            }
            case 1: {
                return CONTAINER_TYPE_IBMI_LIBRARY_LITERAL;
            }
            case 2: {
                return CONTAINER_TYPE_DIRECTORY_LITERAL;
            }
            case 3: {
                return CONTAINER_TYPE_SEQUENTIAL_LITERAL;
            }
        }
        return null;
    }

    private ContainerType(int value, String name, String literal) {
        super(value, name, literal);
    }
}

