/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.ui.query.wizard;

import com.ibm.team.enterprise.metadata.ui.query.wizard.Messages;
import com.ibm.team.enterprise.metadata.ui.query.wizard.SetStreamScanningContentProvider;
import com.ibm.team.enterprise.metadata.ui.query.wizard.SetStreamScanningLabelProvider;
import com.ibm.team.enterprise.metadata.ui.query.wizard.StreamViewerSorter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class UpdateStreamFirstPage
extends WizardPage {
    private CheckboxTableViewer fViewer;
    private ViewerSorter fViewerSorter;
    private List<Map<String, String>> streams;

    public UpdateStreamFirstPage(String pageName, List<Map<String, String>> streams) {
        super(pageName);
        this.setPageComplete(true);
        this.streams = streams;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)new GridLayout());
        GridDataFactory.swtDefaults().applyTo((Control)composite);
        Label label = new Label(composite, 16384);
        label.setText(Messages.SetStreamScanningWizardTable);
        this.fViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2048);
        GridDataFactory.fillDefaults().grab(true, true).indent(5, 0).applyTo((Control)this.fViewer.getTable());
        this.fViewer.setContentProvider((IContentProvider)new SetStreamScanningContentProvider());
        this.fViewer.setLabelProvider((IBaseLabelProvider)new SetStreamScanningLabelProvider());
        if (this.streams != null) {
            this.fViewer.setInput(this.getStreamsSetForScanning(this.streams));
        } else {
            this.fViewer.setInput(this.streams);
        }
        this.fViewer.addCheckStateListener(this.getCheckStateListener());
        this.fViewer.setSorter(this.getSorter());
        Label jazzAdminsLabel = new Label(composite, 16384);
        jazzAdminsLabel.setText(Messages.UpdateStreamWizardRequiresJazzAdmins);
        this.setPageComplete(false);
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite);
    }

    public void handleScanningStatusFinished(List<Map<String, String>> newStreams) {
        this.streams = newStreams;
        if (this.fViewer != null) {
            if (this.fViewer.getControl().isDisposed()) {
                return;
            }
            this.fViewer.setInput(this.getStreamsSetForScanning(this.streams));
        }
    }

    private ICheckStateListener getCheckStateListener() {
        return new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (UpdateStreamFirstPage.this.fViewer.getCheckedElements().length > 0) {
                    UpdateStreamFirstPage.this.setPageComplete(true);
                } else {
                    UpdateStreamFirstPage.this.setPageComplete(false);
                }
            }
        };
    }

    private List<Map<String, String>> getStreamsSetForScanning(List<Map<String, String>> streams) {
        ArrayList<Map<String, String>> selectedList = new ArrayList<Map<String, String>>();
        int i = 0;
        while (i < streams.size()) {
            if (streams.get(i).get("scanFlag").equals("true")) {
                selectedList.add(streams.get(i));
            }
            ++i;
        }
        return selectedList;
    }

    protected boolean validatePage() {
        return true;
    }

    public CheckboxTableViewer getViewer() {
        return this.fViewer;
    }

    private ViewerSorter getSorter() {
        if (this.fViewerSorter == null) {
            this.fViewerSorter = new StreamViewerSorter();
        }
        return this.fViewerSorter;
    }
}

