/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.ui.query.wizard;

import com.ibm.team.build.internal.ui.jobs.TeamBuildJob;
import com.ibm.team.enterprise.metadata.client.collection.ClientFactory;
import com.ibm.team.enterprise.metadata.client.collection.IMetadataCollectionClient;
import com.ibm.team.enterprise.metadata.ui.query.wizard.Messages;
import com.ibm.team.enterprise.metadata.ui.query.wizard.StreamScanningResetFirstPage;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.json.JSONArray;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWizard;

public class StreamScanningResetWizard
extends Wizard
implements IWorkbenchWizard {
    private StreamScanningResetFirstPage fFirstPage;
    protected IProjectAreaHandle fProjectHandle;
    private List<Map<String, String>> fStreams = null;
    private IMetadataCollectionClient fClient;
    private String[] fIds;
    private int fResetType;

    public boolean canFinish() {
        return super.canFinish();
    }

    public void addPages() {
        super.addPages();
        this.fFirstPage = new StreamScanningResetFirstPage(Messages.StreamScanningResetWizardPageTitle, this.fStreams);
        this.fFirstPage.setTitle(Messages.StreamScanningResetWizardPageTitle);
        this.fFirstPage.setDescription(Messages.StreamScanningResetWizardFirstPageDescription);
        this.addPage((IWizardPage)this.fFirstPage);
    }

    public void init(final IProjectAreaHandle projectHandle) {
        this.setWindowTitle(Messages.StreamScanningResetWizardTitle);
        this.fProjectHandle = projectHandle;
        final ITeamRepository teamRepository = (ITeamRepository)this.fProjectHandle.getOrigin();
        TeamBuildJob getScanningStatusJob = new TeamBuildJob(Messages.Job_RetrieveScanStatus_Name, true, teamRepository){

            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                StreamScanningResetWizard.this.fClient = ClientFactory.getMetadataCollectionClient((ITeamRepository)teamRepository);
                String jsonString = "{}";
                jsonString = StreamScanningResetWizard.this.fClient.getScanningStatusForStreams(projectHandle, monitor);
                JSONArray jsonArray = JSONArray.parse((Reader)new StringReader(jsonString));
                StreamScanningResetWizard.this.fStreams = (List)jsonArray;
                return Status.OK_STATUS;
            }

            protected void jobFinished(IStatus status) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (StreamScanningResetWizard.this.fFirstPage != null) {
                            StreamScanningResetWizard.this.fFirstPage.handleScanningStatusFinished(StreamScanningResetWizard.this.fStreams);
                        }
                    }
                });
            }
        };
        getScanningStatusJob.schedule();
    }

    public boolean performFinish() {
        ArrayList<String> streamUUIDs = new ArrayList<String>();
        for (Map<String, String> stream : this.fStreams) {
            if (!this.fFirstPage.getfViewer().getChecked(stream)) continue;
            streamUUIDs.add(stream.get("UUID"));
        }
        this.fIds = new String[streamUUIDs.size()];
        this.fIds = streamUUIDs.toArray(this.fIds);
        this.fResetType = this.fFirstPage.getResetType();
        return true;
    }

    public String[] getStreamUUIDs() {
        return this.fIds;
    }

    public int getResetType() {
        return this.fResetType;
    }

    public void init(IWorkbench arg0, IStructuredSelection arg1) {
    }
}

