/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.ui.query.wizard;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.enterprise.metadata.ui.MetadataUIPlugin;
import com.ibm.team.enterprise.metadata.ui.query.IRemoteFileDescriptor;
import com.ibm.team.enterprise.metadata.ui.query.SparseLoadWizardInput;
import com.ibm.team.enterprise.metadata.ui.query.util.JazzFile;
import com.ibm.team.enterprise.metadata.ui.query.util.PhysicalImpactAnalysisCalculator;
import com.ibm.team.enterprise.metadata.ui.query.util.SparseLoadUtils;
import com.ibm.team.enterprise.metadata.ui.query.util.UIUtils;
import com.ibm.team.enterprise.metadata.ui.query.wizard.BlindLoadPage;
import com.ibm.team.enterprise.metadata.ui.query.wizard.Messages;
import com.ibm.team.enterprise.metadata.ui.query.wizard.SearchPathPage;
import com.ibm.team.enterprise.metadata.ui.query.wizard.SelectFilesToLoadPage;
import com.ibm.team.enterprise.metadata.ui.query.wizard.SelectRepositoryWorkspacePage;
import com.ibm.team.enterprise.metadata.ui.query.wizard.SparseInput;
import com.ibm.team.enterprise.metadata.ui.query.wizard.SparseLoadDilemmaHandler;
import com.ibm.team.enterprise.metadata.ui.query.wizard.SparseLoadModel;
import com.ibm.team.enterprise.metadata.ui.query.wizard.SparseLoadNode;
import com.ibm.team.enterprise.rdf.query.common.select.result.SelectResult;
import com.ibm.team.enterprise.systemdefinition.common.model.ILanguageDefinition;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.PathLocation;
import com.ibm.team.filesystem.client.internal.RelativeLocation;
import com.ibm.team.filesystem.client.operations.ILoadOperation;
import com.ibm.team.filesystem.client.operations.IMultipleSandboxLoad;
import com.ibm.team.filesystem.client.operations.LoadDilemmaHandler;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.ide.ui.internal.wizards.load.IExtraLoadWizard;
import com.ibm.team.filesystem.ide.ui.internal.wizards.load.LoadWizardInput;
import com.ibm.team.filesystem.ide.ui.internal.wizards.load.NamedSiloedItem;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.dto.IAncestorReport;
import com.ibm.team.scm.common.dto.INameItemPair;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;

public class SparseLoadWizard
extends Wizard
implements IPageChangedListener {
    private static boolean DEBUG = false;
    private boolean needModelUpdate;
    private final SparseLoadModel model;
    private final Object[] selection;
    private final SearchPathPage searchPathPage;
    private final SelectRepositoryWorkspacePage selectRWSPage;
    private final SelectFilesToLoadPage selectFilesPage;
    private List<Object> checkedNodes;
    private boolean needInputUpdate;
    private final BlindLoadPage blindLoadPage;
    protected SparseLoadWizardInput input;
    IExtraLoadWizard wizard;
    private String extraWizardId;
    private IWorkspaceConnection currentWks;
    private SparseInput sparseInput;
    private ILoadOperation loadOp4LocalSandbox;

    public SparseLoadWizard(Object[] selection, boolean loadDependencies, ITeamRepository repo) {
        this.setWindowTitle(loadDependencies ? Messages.SparseLoadWizard_Title_LoadWithDependencies : Messages.SparseLoadWizard_Title_LoadFiles);
        this.model = new SparseLoadModel(repo);
        this.selection = selection;
        this.searchPathPage = loadDependencies ? new SearchPathPage(repo, this.model) : null;
        this.selectRWSPage = new SelectRepositoryWorkspacePage(this.model);
        this.selectFilesPage = new SelectFilesToLoadPage();
        this.blindLoadPage = this.extraWizardsExist() ? new BlindLoadPage() : null;
        this.needModelUpdate = true;
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        if (this.blindLoadPage != null) {
            this.addPage((IWizardPage)this.blindLoadPage);
        }
        if (this.searchPathPage != null) {
            this.addPage((IWizardPage)this.searchPathPage);
        }
        this.addPage((IWizardPage)this.selectRWSPage);
        this.addPage((IWizardPage)this.selectFilesPage);
    }

    public boolean performFinish() {
        if (this.isLoadOpForExtraWizard()) {
            if (DEBUG) {
                System.out.println("SparseLoadWizard#performFinish for extra wizard");
            }
            return true;
        }
        this.selectFilesPage.ensureModelExists(this.model);
        this.checkedNodes = this.selectFilesPage.getFullyCheckedElements();
        if (DEBUG) {
            System.out.println(">>SparseLoadWizard#performFinish evaluate the requests");
        }
        this.loadOp4LocalSandbox = null;
        IStatus status = this.evaluate();
        if (status == Status.CANCEL_STATUS) {
            this.getContainer().showPage((IWizardPage)this.selectFilesPage);
        }
        if (DEBUG) {
            System.out.println("<<SparseLoadWizard#performFinish return: " + status.isOK());
        }
        return status.isOK();
    }

    private static IRelativeLocation calculateRelativeLocation(IAncestorReport report) {
        List niPairs = report.getNameItemPairs();
        int numNIPairs = niPairs == null ? 0 : niPairs.size();
        String[] locationParts = new String[numNIPairs - 1];
        int i = 1;
        while (i < numNIPairs) {
            locationParts[i - 1] = ((INameItemPair)niPairs.get(i)).getName();
            ++i;
        }
        return new RelativeLocation(locationParts);
    }

    private static void addFileItemHandle(Map<UUID, Set<UUID>> compToVersionablesMap, SelectResult selectResult) {
        String fileUUID;
        Map<String, String> bindingMap = SparseLoadUtils.parseSelectResult(selectResult);
        String compUUID = bindingMap.get("componentId");
        if (compUUID != null && (fileUUID = bindingMap.get("fileItemId")) != null) {
            SparseLoadWizard.addFileItemHandle(compToVersionablesMap, UUID.valueOf((String)compUUID), UUID.valueOf((String)fileUUID));
        }
    }

    private static void addFileItemHandle(Map<UUID, Set<UUID>> compToVersionablesMap, UUID compUUID, UUID fileUUID) {
        Set<UUID> fileUUIDList = compToVersionablesMap.get(compUUID);
        if (fileUUIDList == null) {
            fileUUIDList = new HashSet<UUID>();
            compToVersionablesMap.put(compUUID, fileUUIDList);
        }
        fileUUIDList.add(fileUUID);
    }

    private static Map<UUID, Set<UUID>> calculateFilesToLoad(Object[] selection, boolean loadWithDeps, boolean applySearchPath, ILanguageDefinition langdef, IBuildDefinition builddef, IProgressMonitor monitor) throws TeamRepositoryException {
        HashMap<UUID, Set<UUID>> compToVersionablesMap = new HashMap<UUID, Set<UUID>>();
        ArrayList<PhysicalImpactAnalysisCalculator> calcs = new ArrayList<PhysicalImpactAnalysisCalculator>();
        ArrayList<SelectResult> dependencies = new ArrayList<SelectResult>();
        Object[] objectArray = selection;
        int n = selection.length;
        int n2 = 0;
        while (n2 < n) {
            Object sel = objectArray[n2];
            if (sel instanceof SelectResult) {
                SelectResult self = (SelectResult)sel;
                SparseLoadWizard.addFileItemHandle(compToVersionablesMap, self);
                if (loadWithDeps) {
                    calcs.add(new PhysicalImpactAnalysisCalculator(self, monitor));
                }
            } else if (sel instanceof IRemoteFileDescriptor) {
                JazzFile jazzFile = JazzFile.createJazzFile((IRemoteFileDescriptor)sel, monitor);
                SparseLoadWizard.addFileItemHandle(compToVersionablesMap, UUID.valueOf((String)jazzFile.getComponentId()), UUID.valueOf((String)jazzFile.getFileItemId()));
                if (loadWithDeps) {
                    calcs.add(new PhysicalImpactAnalysisCalculator(jazzFile));
                }
            } else if (loadWithDeps && sel instanceof IResource) {
                calcs.add(new PhysicalImpactAnalysisCalculator((IResource)sel, monitor));
            }
            ++n2;
        }
        Boolean cachedIgnoreFlag = null;
        for (PhysicalImpactAnalysisCalculator calc : calcs) {
            if (cachedIgnoreFlag == null) {
                cachedIgnoreFlag = calc.isIgnoreFileTypes(monitor);
            } else {
                calc.setIgnoreFileTypes(cachedIgnoreFlag);
            }
            List<SelectResult> calculatedDependencies = loadWithDeps && applySearchPath && langdef != null && builddef != null ? calc.calculatePhysicalDependencies(langdef, builddef, monitor) : calc.calculateLogicalDependencies2(null, monitor);
            dependencies.addAll(calculatedDependencies);
        }
        for (SelectResult selectResult : dependencies) {
            SparseLoadWizard.addFileItemHandle(compToVersionablesMap, selectResult);
        }
        return compToVersionablesMap;
    }

    private static void addFile(IFileItemHandle thisFile, IRelativeLocation relLoc, Map<IRelativeLocation, List<IFileItemHandle>> result) {
        List<IFileItemHandle> fileList = result.get(relLoc);
        if (fileList == null) {
            fileList = new ArrayList<IFileItemHandle>();
            result.put(relLoc, fileList);
        }
        fileList.add(thisFile);
    }

    private Map<IRelativeLocation, List<IFileItemHandle>> buildRelativePathRequests(IConfiguration config, Set<UUID> allUUIDsToLoad, IProgressMonitor monitor) throws TeamRepositoryException {
        HashMap<IRelativeLocation, List<IFileItemHandle>> result = new HashMap<IRelativeLocation, List<IFileItemHandle>>();
        HashSet<String> projectsProcessed = new HashSet<String>();
        IFolderHandle componentRootHandle = config.rootFolderHandle(monitor);
        ArrayList<IFileItemHandle> allFilesToLoad = new ArrayList<IFileItemHandle>(allUUIDsToLoad.size());
        for (UUID thisUUID : allUUIDsToLoad) {
            allFilesToLoad.add((IFileItemHandle)IFileItem.ITEM_TYPE.createItemHandle(thisUUID, null));
        }
        List ancestorReports = config.determineAncestorsInHistory(allFilesToLoad, monitor);
        int numFiles = allFilesToLoad == null ? 0 : allFilesToLoad.size();
        int i = 0;
        while (i < numFiles) {
            IRelativeLocation relLoc = SparseLoadWizard.calculateRelativeLocation((IAncestorReport)ancestorReports.get(i));
            SparseLoadWizard.addFile((IFileItemHandle)allFilesToLoad.get(i), relLoc.removeLastSegments(1), result);
            String projectName = relLoc.segment(0);
            if (!projectsProcessed.contains(projectName)) {
                IVersionableHandle dotProject = config.resolvePath(componentRootHandle, new String[]{projectName, ".project"}, monitor);
                if (dotProject instanceof IFileItemHandle) {
                    SparseLoadWizard.addFile((IFileItemHandle)dotProject, (IRelativeLocation)new RelativeLocation(projectName), result);
                }
                projectsProcessed.add(projectName);
            }
            String[] folderRelPathSegments = relLoc.removeFirstSegments(1).removeLastSegments(1).segments();
            int numFolderRelPathSegments = folderRelPathSegments.length;
            String[] sideFileSegments = new String[numFolderRelPathSegments + 3];
            sideFileSegments[0] = projectName;
            sideFileSegments[1] = ".ibmi";
            int j = 0;
            while (j < folderRelPathSegments.length) {
                sideFileSegments[2 + j] = folderRelPathSegments[j];
                ++j;
            }
            sideFileSegments[sideFileSegments.length - 1] = String.valueOf(relLoc.segment(relLoc.segmentCount() - 1)) + ".properties";
            IVersionableHandle ibmiSideFile = config.resolvePath(componentRootHandle, sideFileSegments, monitor);
            if (ibmiSideFile instanceof IFileItemHandle) {
                SparseLoadWizard.addFile((IFileItemHandle)ibmiSideFile, new RelativeLocation(sideFileSegments).removeLastSegments(1), result);
            }
            ++i;
        }
        return result;
    }

    public IWorkspace getWorkspaceToLoadFrom() {
        return this.model.getWorkspaceToLoadFrom().getResolvedWorkspace();
    }

    public ILoadOperation getLoadOperation(IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.loadOp4LocalSandbox != null) {
            return this.loadOp4LocalSandbox;
        }
        ILoadOperation loadOp = IOperationFactory.instance.getLoadOperation((LoadDilemmaHandler)SparseLoadDilemmaHandler.getInstance());
        ISandbox sandbox = FileSystemCore.getSharingManager().getSandbox((ILocation)(this.sparseInput != null ? this.sparseInput.getSandboxPath() : new PathLocation(ResourcesPlugin.getWorkspace().getRoot().getLocation())), false);
        loadOp.setEclipseSpecificLoadOptions(2);
        IWorkspaceConnection wsConn = this.model.getWorkspaceToLoadFrom();
        for (Map.Entry<UUID, Set<UUID>> thisCompLoad : this.getFilesToLoad(monitor).entrySet()) {
            IComponentHandle compHandle = (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle(thisCompLoad.getKey(), null);
            for (Map.Entry<IRelativeLocation, List<IFileItemHandle>> relPathToItem : this.buildRelativePathRequests(wsConn.configuration(compHandle), thisCompLoad.getValue(), monitor).entrySet()) {
                loadOp.requestLoad(sandbox, relPathToItem.getKey(), wsConn, compHandle, (Collection)relPathToItem.getValue());
            }
        }
        this.loadOp4LocalSandbox = loadOp;
        if (DEBUG) {
            System.out.println("-- SparseLoadWizard#getLoadOperationOnLocalSandbox for local sandbox:<" + sandbox + ">");
        }
        return this.loadOp4LocalSandbox;
    }

    public void pageChanged(PageChangedEvent event) {
        Object page = event.getSelectedPage();
        if (page == this.searchPathPage || page == this.blindLoadPage) {
            this.needModelUpdate = true;
            this.needInputUpdate = true;
            this.sparseInput = null;
            this.wizard = null;
            this.getContainer().updateButtons();
        } else if (page == this.selectRWSPage) {
            if (this.needModelUpdate) {
                if (DEBUG) {
                    System.out.println(">>SparseLoadWizard#pageChanged update model");
                }
                this.needInputUpdate = true;
                this.sparseInput = null;
                final UUID[] toSelect = new UUID[1];
                try {
                    this.getContainer().run(true, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException {
                            try {
                                IShare share;
                                IShareable shareable;
                                boolean loadWithDeps = SparseLoadWizard.this.searchPathPage != null;
                                SparseLoadWizard.this.model.setToLoad(SparseLoadWizard.calculateFilesToLoad(SparseLoadWizard.this.selection, loadWithDeps, loadWithDeps ? SparseLoadWizard.this.searchPathPage.applySearchPath() : false, loadWithDeps ? SparseLoadWizard.this.searchPathPage.getLangdef() : null, loadWithDeps ? SparseLoadWizard.this.searchPathPage.getBuilddef() : null, monitor));
                                SparseLoadWizard.this.needModelUpdate = false;
                                if (SparseLoadWizard.this.selection[0] instanceof IResource && (shareable = (IShareable)((IResource)SparseLoadWizard.this.selection[0]).getAdapter(IShareable.class)) != null && (share = shareable.getShare(monitor)) != null) {
                                    toSelect[0] = share.getSharingDescriptor().getConnectionHandle().getItemId();
                                }
                            }
                            catch (TeamRepositoryException ex) {
                                throw new InvocationTargetException(ex);
                            }
                        }
                    });
                }
                catch (InvocationTargetException ex) {
                    MetadataUIPlugin.log(Messages.SparseLoadWizard_ErrorCalculatingFilesToLoad, ex);
                    Throwable t = ex.getCause();
                    if (t == null) {
                        t = ex;
                    }
                    UIUtils.showError(Messages.SparseLoadWizard_Error, Messages.SparseLoadWizard_ErrorCalculatingFilesToLoad, t);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.selectRWSPage.scheduleRWSUpdate(toSelect[0]);
                if (DEBUG) {
                    System.out.println("<<SparseLoadWizard#pageChanged update model");
                }
            }
            if (this.extraWizardId != null && this.wizard == null) {
                this.wizard = this.createExtraLoadWizard(this.extraWizardId);
            }
        } else if (page == this.selectFilesPage) {
            this.selectFilesPage.updateModel(this.model);
        } else if (this.wizard != null) {
            this.wizard.getStartingPage();
        }
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.blindLoadPage) {
            this.extraWizardId = this.blindLoadPage.getSelectedExtraWizardId();
            if (this.extraWizardId == null || this.extraWizardId.length() <= 0) {
                this.wizard = null;
                this.model.setBuildDefinitionChecked(false);
            } else {
                this.model.setBuildDefinitionChecked(true);
            }
            return super.getNextPage(page);
        }
        if (page == this.selectRWSPage) {
            if (this.wizard != null) {
                if (this.needInputUpdate) {
                    this.initializeExtraLoadWizard();
                } else if (!this.currentWks.equals((Object)this.model.getWorkspaceToLoadFrom())) {
                    this.wizard = this.createExtraLoadWizard(this.extraWizardId);
                    this.initializeExtraLoadWizard();
                }
                return this.wizard.getStartingPage();
            }
            if (this.sparseInput == null || this.currentWks != null && !this.currentWks.equals((Object)this.model.getWorkspaceToLoadFrom())) {
                this.initializeSparseInput();
            }
        } else if (page != this.searchPathPage && page != this.selectRWSPage && page != this.blindLoadPage && this.wizard != null) {
            return this.wizard.getNextPage(page);
        }
        return super.getNextPage(page);
    }

    private Map<UUID, Set<UUID>> getFilesToLoad(IProgressMonitor monitor) throws TeamRepositoryException {
        HashMap<UUID, Set<UUID>> toLoad = new HashMap<UUID, Set<UUID>>();
        for (Object checkedItem : this.checkedNodes) {
            if (checkedItem instanceof SparseLoadNode) {
                SparseLoadNode node = (SparseLoadNode)checkedItem;
                IConfiguration config = node.getConfiguration();
                UUID compUUID = config.component().getItemId();
                HashSet<UUID> filesToLoad = (HashSet<UUID>)toLoad.get(compUUID);
                if (filesToLoad == null) {
                    filesToLoad = new HashSet<UUID>();
                    toLoad.put(compUUID, filesToLoad);
                }
                if (node.isFolder()) {
                    filesToLoad.addAll(this.getSubfiles(config, (IFolderHandle)node.getHandle(), monitor));
                    continue;
                }
                filesToLoad.add(node.getHandle().getItemId());
                continue;
            }
            if (!(checkedItem instanceof IWorkspaceConnection)) continue;
            IWorkspaceConnection wsConn = (IWorkspaceConnection)checkedItem;
            List compHandles = wsConn.getComponents();
            for (IComponentHandle thisCompHandle : compHandles) {
                IConfiguration config = wsConn.configuration(thisCompHandle);
                UUID compUUID = thisCompHandle.getItemId();
                HashSet<UUID> filesToLoad = (HashSet<UUID>)toLoad.get(compUUID);
                if (filesToLoad == null) {
                    filesToLoad = new HashSet<UUID>();
                    toLoad.put(compUUID, filesToLoad);
                }
                filesToLoad.addAll(this.getSubfiles(config, config.rootFolderHandle(monitor), monitor));
            }
        }
        return toLoad;
    }

    private Set<UUID> getSubfiles(IConfiguration config, IFolderHandle folderHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        HashSet<UUID> subfiles = new HashSet<UUID>();
        for (IVersionableHandle thisKid : config.childEntries(folderHandle, monitor).values()) {
            if (thisKid instanceof IFolderHandle) {
                subfiles.addAll(this.getSubfiles(config, (IFolderHandle)thisKid, monitor));
                continue;
            }
            subfiles.add(thisKid.getItemId());
        }
        return subfiles;
    }

    public boolean canFinish() {
        String selection;
        if (this.extraWizardId != null && this.extraWizardId.length() > 0 && this.wizard != null && !this.needInputUpdate && !this.needModelUpdate) {
            IWizardPage currentPage = this.getContainer().getCurrentPage();
            if (currentPage == this.blindLoadPage || currentPage == this.searchPathPage || currentPage == this.selectRWSPage) {
                return false;
            }
            return this.wizard.canFinish();
        }
        if (this.blindLoadPage != null && (selection = this.blindLoadPage.getSelectedExtraWizardId()) != null && selection.length() > 0) {
            return false;
        }
        return super.canFinish();
    }

    public boolean isLoadOpForExtraWizard() {
        return this.input != null && this.input.getLoadType() == 7;
    }

    private boolean extraWizardsExist() {
        return BlindLoadPage.getExtraLoadWizardInformations(true).size() > 0;
    }

    private IExtraLoadWizard createExtraLoadWizard(String id) {
        if (DEBUG) {
            System.out.println(">>SparseLoadWizard#createExtraLoadWizard");
        }
        IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint("com.ibm.team.filesystem.ide.ui", "extraLoadWizards");
        IExtension[] iExtensionArray = ep.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement ce = iConfigurationElementArray[n4];
                try {
                    IExtraLoadWizard wizard = (IExtraLoadWizard)ce.createExecutableExtension("class");
                    if (id.equals(ce.getAttribute("id"))) {
                        if (DEBUG) {
                            System.out.println("<<SparseLoadWizard#createExtraLoadWizard wizard created");
                        }
                        return wizard;
                    }
                }
                catch (CoreException e) {
                    MetadataUIPlugin.log(e.getStatus());
                }
                catch (ClassCastException e) {
                    MetadataUIPlugin.log(e.getMessage(), e);
                }
                ++n4;
            }
            ++n2;
        }
        if (DEBUG) {
            System.out.println("<<SparseLoadWizard#createExtraLoadWizard NO wizard created");
        }
        return null;
    }

    private void initializeExtraLoadWizard() {
        if (DEBUG) {
            System.out.println(">>SparseLoadWizard#initializeExtraLoadWizard");
        }
        try {
            this.selectFilesPage.ensureModelExists(this.model);
            List allComps = this.model.getWorkspaceToLoadFrom().getComponents();
            Map<UUID, Set<UUID>> toLoad = this.model.getVersionablesToLoad();
            HashSet<IComponentHandle> comps = new HashSet<IComponentHandle>();
            HashSet<NamedSiloedItem> items = new HashSet<NamedSiloedItem>();
            for (UUID comp : toLoad.keySet()) {
                boolean bFound = false;
                for (IComponentHandle c : allComps) {
                    if (!comp.equals((Object)c.getItemId())) continue;
                    comps.add(c);
                    bFound = true;
                    break;
                }
                if (!bFound) continue;
                for (UUID item : toLoad.get(comp)) {
                    items.add(new NamedSiloedItem(IFileItem.ITEM_TYPE, item, comp));
                }
            }
            this.input = new SparseLoadWizardInput(this.model.getWorkspaceToLoadFrom(), comps, null, (IProgressMonitor)new NullProgressMonitor());
            this.input.setBuildDefinition(this.searchPathPage != null && this.searchPathPage.applySearchPath() ? this.searchPathPage.getBuilddef() : null);
            this.input.initialize();
            this.input.setExtraWizard(this.wizard, this.extraWizardId);
            LoadWizardInput.SelectedFoldersSet f = this.input.getSelectedFolders();
            f.update(items);
            try {
                this.getContainer().run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            SparseLoadWizard.this.input.refreshSelectedFolders(monitor);
                        }
                        catch (TeamRepositoryException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                });
            }
            catch (InvocationTargetException e) {
                MetadataUIPlugin.log(e.getMessage(), e);
            }
            catch (InterruptedException e) {
                MetadataUIPlugin.log(e.getMessage(), e);
            }
            this.needInputUpdate = false;
            this.currentWks = this.model.getWorkspaceToLoadFrom();
        }
        catch (TeamRepositoryException e) {
            MetadataUIPlugin.log(e.getMessage(), e);
            UIUtils.showError(Messages.SparseLoadWizard_Error, Messages.SparseLoadWizard_ErrorInitializingRemoteLoadWizard, e);
        }
        this.wizard.setLoadWizardInput(this.getLoadWizardInput());
        this.wizard.setContainer(this.getContainer());
        this.wizard.addPages();
        if (DEBUG) {
            System.out.println("<<SparseLoadWizard#initializeExtraLoadWizard");
        }
    }

    public LoadWizardInput getLoadWizardInput() {
        return this.input;
    }

    private IStatus evaluate() {
        try {
            final ArrayList<IMultipleSandboxLoad> multipleSandboxLoads = new ArrayList<IMultipleSandboxLoad>();
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.SparseLoadWizard_CheckingLoadCondition_1, (int)2);
                    try {
                        try {
                            if (SparseLoadWizard.this.sparseInput != null) {
                                SparseLoadWizard.this.sparseInput.evaluateLoadRequests(SparseLoadWizard.this.getLoadOperation((IProgressMonitor)sub.newChild(1)), multipleSandboxLoads, (IProgressMonitor)sub.newChild(1));
                            }
                        }
                        catch (FileSystemException e) {
                            throw new InvocationTargetException(e);
                        }
                        catch (TeamRepositoryException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        sub.done();
                    }
                }
            });
            if (this.sparseInput != null) {
                this.sparseInput.promptInvalidLoadRequests(this.getShell());
            }
            boolean hasMultipleSandboxes = false;
            for (IMultipleSandboxLoad sand : multipleSandboxLoads) {
                Collection ss = sand.getSandboxes();
                if (ss.size() <= 1) continue;
                hasMultipleSandboxes = true;
            }
            if (hasMultipleSandboxes) {
                SparseLoadDilemmaHandler.getInstance().multipleSandboxLoad(multipleSandboxLoads);
                return Status.CANCEL_STATUS;
            }
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            IStatus status = cause != null ? FileSystemStatusUtil.getStatusFor((Throwable)cause) : FileSystemStatusUtil.getStatusFor((Throwable)e);
            ErrorDialog.openError((Shell)this.getShell(), (String)Messages.SparseLoadWizard_CheckingLoadCondition_2, null, (IStatus)status);
            return status;
        }
        catch (InterruptedException e) {
            Throwable cause = e.getCause();
            IStatus status = cause != null ? FileSystemStatusUtil.getStatusFor((Throwable)cause) : FileSystemStatusUtil.getStatusFor((Throwable)e);
            return status;
        }
        return Status.OK_STATUS;
    }

    private void initializeSparseInput() {
        if (DEBUG) {
            System.out.println(">>SparseLoadWizard#initializeSparseInput");
        }
        this.selectFilesPage.ensureModelExists(this.model);
        this.currentWks = this.model.getWorkspaceToLoadFrom();
        this.sparseInput = new SparseInput();
        this.selectFilesPage.setSparseInput(this.sparseInput);
        if (DEBUG) {
            System.out.println("<<SparseLoadWizard#initializeSparseInput");
        }
    }
}

