/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.ui.query.wizard;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IWorkspaceConnection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class SparseLoadModel {
    private final ITeamRepository repo;
    private Map<UUID, Set<UUID>> toLoad;
    private IWorkspaceConnection toLoadFrom;
    private int totalNumberToLoad;
    private IBuildDefinition buildDefinition;
    private boolean toCheck;

    public SparseLoadModel(ITeamRepository repo) {
        this.repo = repo;
        this.totalNumberToLoad = 0;
    }

    public Map<UUID, Set<UUID>> getVersionablesToLoad() {
        int size = this.toLoad == null ? 0 : this.toLoad.size();
        HashMap<UUID, Set<UUID>> copy = new HashMap<UUID, Set<UUID>>(size);
        if (size > 0) {
            copy.putAll(this.toLoad);
        }
        return copy;
    }

    public ITeamRepository getRepository() {
        return this.repo;
    }

    public void setWorkspaceToLoadFrom(IWorkspaceConnection wsConn) {
        this.toLoadFrom = wsConn;
    }

    public void setToLoad(Map<UUID, Set<UUID>> toLoad) {
        this.toLoad = toLoad;
        this.totalNumberToLoad = 0;
        Iterator<Set<UUID>> it = toLoad.values().iterator();
        while (it.hasNext()) {
            this.totalNumberToLoad += it.next().size();
        }
    }

    public IWorkspaceConnection getWorkspaceToLoadFrom() {
        return this.toLoadFrom;
    }

    public int getTotalNumberToLoad() {
        return this.totalNumberToLoad;
    }

    public boolean isBuildDefinitionChecked() {
        return this.toCheck;
    }

    public void setBuildDefinitionChecked(boolean toCheck) {
        this.toCheck = toCheck;
    }

    public IBuildDefinition getBuildDefinition() {
        return this.buildDefinition;
    }

    public void setBuildDefinition(IBuildDefinition buildDefinition) {
        this.buildDefinition = buildDefinition;
    }
}

