/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.ui.query.wizard;

import com.ibm.team.enterprise.metadata.ui.query.wizard.FetchComponentsJob;
import com.ibm.team.enterprise.metadata.ui.query.wizard.FetchSCMChildrenJob;
import com.ibm.team.enterprise.metadata.ui.query.wizard.Messages;
import com.ibm.team.enterprise.metadata.ui.query.wizard.SparseLoadModel;
import com.ibm.team.enterprise.metadata.ui.query.wizard.SparseLoadNode;
import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IWorkspaceConnection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class SparseLoadFilesContentProvider
extends LabelProvider
implements ITreeContentProvider {
    private Image workspaceImage;
    private Image componentImage;
    private TreeViewer viewer;
    private Map<Object, Object[]> cachedKids;

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = (TreeViewer)viewer;
        this.cachedKids = new HashMap<Object, Object[]>();
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public boolean hasChildren(Object element) {
        return element instanceof IWorkspaceConnection || element instanceof SparseLoadNode && ((SparseLoadNode)element).isFolder();
    }

    public Object getParent(Object element) {
        if (element instanceof SparseLoadNode) {
            return ((SparseLoadNode)element).getParent();
        }
        if (element instanceof IWorkspaceConnection) {
            return this.viewer.getInput();
        }
        return null;
    }

    public Object[] getCachedKids(Object parentElement) {
        return this.cachedKids.get(parentElement);
    }

    public Object[] precomputeCacheFor(Object parentElement, IProgressMonitor monitor) throws TeamRepositoryException {
        SparseLoadNode node;
        Object[] kids = this.getCachedKids(parentElement);
        if (kids != null) {
            return kids;
        }
        if (parentElement instanceof SparseLoadModel) {
            kids = new Object[]{((SparseLoadModel)parentElement).getWorkspaceToLoadFrom()};
        } else if (parentElement instanceof IWorkspaceConnection) {
            kids = FetchComponentsJob.computeChildren((IWorkspaceConnection)parentElement, monitor);
        } else if (parentElement instanceof SparseLoadNode && (node = (SparseLoadNode)parentElement).isFolder()) {
            kids = FetchSCMChildrenJob.computeChildren(node, monitor);
        }
        this.cachedKids.put(parentElement, kids);
        return kids;
    }

    public Object[] getChildren(Object parentElement) {
        Object[] fromCache = this.getCachedKids(parentElement);
        if (fromCache != null) {
            return fromCache;
        }
        if (parentElement instanceof SparseLoadModel) {
            return new Object[]{((SparseLoadModel)parentElement).getWorkspaceToLoadFrom()};
        }
        if (parentElement instanceof IWorkspaceConnection) {
            Object[] pending = new Object[]{Messages.SparseLoadWizard_Pending};
            new FetchComponentsJob((IWorkspaceConnection)parentElement, this).schedule();
            return pending;
        }
        if (parentElement instanceof SparseLoadNode) {
            SparseLoadNode node = (SparseLoadNode)parentElement;
            if (!node.isFolder()) {
                return null;
            }
            Object[] pending = new Object[]{Messages.SparseLoadWizard_Pending};
            new FetchSCMChildrenJob(node, this).schedule();
            return pending;
        }
        return null;
    }

    public void updateChildren(final Object parentNode, final Object[] toAdd) {
        if (toAdd != null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (SparseLoadFilesContentProvider.this.viewer != null && !SparseLoadFilesContentProvider.this.viewer.getTree().isDisposed()) {
                        SparseLoadFilesContentProvider.this.cachedKids.put(parentNode, toAdd);
                        SparseLoadFilesContentProvider.this.viewer.add(parentNode, toAdd);
                        SparseLoadFilesContentProvider.this.viewer.remove(parentNode, new Object[]{Messages.SparseLoadWizard_Pending});
                    }
                }
            });
        }
    }

    public String getText(Object element) {
        if (element instanceof IWorkspaceConnection) {
            return ((IWorkspaceConnection)element).getName();
        }
        if (element instanceof SparseLoadNode) {
            return ((SparseLoadNode)element).getName();
        }
        return super.getText(element);
    }

    public Image getImage(Object element) {
        if (element instanceof IWorkspaceConnection) {
            if (this.workspaceImage == null) {
                this.workspaceImage = ImagePool.WORKSPACE.createImage();
            }
            return this.workspaceImage;
        }
        if (element instanceof SparseLoadNode) {
            SparseLoadNode node = (SparseLoadNode)element;
            if (node.isComponentRoot()) {
                if (this.componentImage == null) {
                    this.componentImage = ImagePool.COMPONENT.createImage();
                }
                return this.componentImage;
            }
            if (node.isFolder()) {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
            }
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
        }
        return super.getImage(element);
    }

    public void dispose() {
        super.dispose();
        if (this.workspaceImage != null) {
            this.workspaceImage.dispose();
        }
        if (this.componentImage != null) {
            this.componentImage.dispose();
        }
    }
}

