/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.ui.query.wizard;

import com.ibm.team.enterprise.metadata.ui.query.wizard.Messages;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.RelativeLocation;
import com.ibm.team.filesystem.client.operations.ICollision;
import com.ibm.team.filesystem.client.operations.ILoadLocation;
import com.ibm.team.filesystem.client.operations.ILoadOverlap;
import com.ibm.team.filesystem.client.operations.ILoadRequest;
import com.ibm.team.filesystem.client.operations.IMultipleSandboxLoad;
import com.ibm.team.filesystem.client.operations.IRemovedShare;
import com.ibm.team.filesystem.client.operations.IShareOutOfSync;
import com.ibm.team.filesystem.client.operations.LoadDilemmaHandler;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListDialog;
import org.eclipse.ui.dialogs.ListSelectionDialog;

public class SparseLoadDilemmaHandler
extends LoadDilemmaHandler {
    private static SparseLoadDilemmaHandler instance;
    private final Collection<ILoadRequest> preparedInvalidRequests = new HashSet<ILoadRequest>();

    public static SparseLoadDilemmaHandler getInstance() {
        if (instance == null) {
            instance = new SparseLoadDilemmaHandler();
        }
        return instance;
    }

    private SparseLoadDilemmaHandler() {
    }

    public int collision(Collection<ICollision> collisions, Collection<IRemovedShare> removedShares, Collection<IShareOutOfSync> sharesOutOfSync) {
        final HashMap<IRelativeLocation, ICollision> collisionMap = new HashMap<IRelativeLocation, ICollision>();
        for (ICollision collision : collisions) {
            IRelativeLocation relLoc;
            String[] segments;
            collision.setLoadLocation(null);
            if (!collision.collidedWithExistingContent() || collision.getLocations().size() != 1 || (segments = (relLoc = collision.getShareable().getLocalPath()).segments()).length > 1 && ".ibmi".equals(segments[1]) || ".project".equals(segments[segments.length - 1])) continue;
            collisionMap.put(relLoc, collision);
        }
        if (collisionMap.size() > 0) {
            final IWorkbench workbench = PlatformUI.getWorkbench();
            final boolean[] shouldCancel = new boolean[1];
            workbench.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    ListSelectionDialog dialog = new ListSelectionDialog(workbench.getActiveWorkbenchWindow().getShell(), collisionMap.keySet(), (IStructuredContentProvider)ArrayContentProvider.getInstance(), (ILabelProvider)new LabelProvider(), Messages.SparseLoadDilemmaHandler_collisionsDetectedMessage);
                    dialog.setTitle(Messages.SparseLoadDilemmaHandler_confirmOverwrite);
                    dialog.open();
                    Object[] result = dialog.getResult();
                    if (result == null) {
                        shouldCancel[0] = true;
                    } else {
                        shouldCancel[0] = false;
                        Object[] objectArray = dialog.getResult();
                        int n = objectArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object obj = objectArray[n2];
                            ICollision toOverwrite = (ICollision)collisionMap.get(obj);
                            if (toOverwrite != null) {
                                toOverwrite.setLoadLocation((ILoadLocation)toOverwrite.getLocations().iterator().next());
                            }
                            ++n2;
                        }
                    }
                }
            });
            if (shouldCancel[0]) {
                return 1;
            }
        }
        return 0;
    }

    public int deletedContent(Collection<IShareable> contentDeleted) {
        final ArrayList<IRelativeLocation> input = new ArrayList<IRelativeLocation>();
        for (IShareable share : contentDeleted) {
            input.add(share.getLocalPath());
        }
        final IWorkbench workbench = PlatformUI.getWorkbench();
        workbench.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                ListDialog dialog = new ListDialog(workbench.getActiveWorkbenchWindow().getShell());
                dialog.setInput((Object)input);
                dialog.setMessage(Messages.SparseLoadDilemmaHandler_contentDeletedMessage);
                dialog.setTitle(Messages.SparseLoadDilemmaHandler_cannotLoadContent);
                dialog.setContentProvider((IStructuredContentProvider)ArrayContentProvider.getInstance());
                dialog.setLabelProvider((ILabelProvider)new LabelProvider());
                dialog.open();
            }
        });
        return 0;
    }

    public int overlappingLoadRequests(Collection<ILoadOverlap> foldersOverlapping) {
        final ArrayList<String> input = new ArrayList<String>();
        for (ILoadOverlap overlap : foldersOverlapping) {
            input.add(new RelativeLocation(overlap.getPath()).toString());
        }
        Collections.sort(input);
        final IWorkbench workbench = PlatformUI.getWorkbench();
        workbench.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                ListDialog dialog = new ListDialog(workbench.getActiveWorkbenchWindow().getShell());
                dialog.setInput((Object)input);
                dialog.setMessage(Messages.SparseLoadDilemmaHandler_contentOverlapsMessage);
                dialog.setTitle(Messages.SparseLoadDilemmaHandler_cannotLoadContent);
                dialog.setContentProvider((IStructuredContentProvider)ArrayContentProvider.getInstance());
                dialog.setLabelProvider((ILabelProvider)new LabelProvider());
                dialog.open();
            }
        });
        return 0;
    }

    public int multipleSandboxLoad(final Collection<IMultipleSandboxLoad> locations) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                IStatus status = null;
                status = SparseLoadDilemmaHandler.this.createStatus(locations);
                StatusDialog dialog = new StatusDialog(null, Messages.SparseLoadDilemmaHandler_MultipleSandboxLoadDialogTitle, Messages.SparseLoadDilemmaHandler_MultipleSandboxLoadDialogMessage, null, status, 7);
                dialog.open();
            }
        });
        return 1;
    }

    private IStatus createStatus(Collection<IMultipleSandboxLoad> locations) {
        ArrayList<IStatus> info = new ArrayList<IStatus>();
        for (IMultipleSandboxLoad location : locations) {
            SparseLoadDilemmaHandler.accumulateStatus(location, info);
        }
        if (info.size() == 1) {
            return (IStatus)info.get(0);
        }
        return StatusUtil.newStatus((Object)((Object)this), (String)Messages.SparseLoadDilemmaHandler_MultipleSandboxLoadMultiStatus, info);
    }

    private static void accumulateStatus(IMultipleSandboxLoad location, List<IStatus> info) {
        Collection sandboxes = location.getSandboxes();
        Collection loadLocations = location.getLoadLocations();
        for (ILoadLocation loadLocation : loadLocations) {
            String workspaceName = loadLocation.getConnection().getName();
            String componentName = loadLocation.getComponent().getName();
            String versionableName = SparseLoadDilemmaHandler.getName(loadLocation.getRootToLoad());
            versionableName = versionableName.equals(Messages.SparseLoadDilemmaHandler_UnknownVersionableName) ? loadLocation.getLoadPath().getName() : versionableName;
            for (ISandbox sandbox : sandboxes) {
                if (sandbox.equals(loadLocation.getSandbox())) continue;
                info.add(StatusUtil.newStatus((Object)"com.ibm.team.enterprise.metadata.ui", (int)2, (String)NLS.bind((String)Messages.SparseLoadDilemmaHandle_MultipleSandboxLoadEncountered, (Object[])new String[]{versionableName, workspaceName, componentName, sandbox.getRoot().toOSString()}), null));
            }
        }
    }

    protected static String getName(IVersionableHandle handle) {
        if (handle instanceof IVersionable) {
            IVersionable v = (IVersionable)handle;
            return v.getName();
        }
        return Messages.SparseLoadDilemmaHandler_UnknownVersionableName;
    }

    public void setInvalidLoadRequests(Collection<ILoadRequest> invalidRequests) {
        this.preparedInvalidRequests.clear();
        this.preparedInvalidRequests.addAll(invalidRequests);
    }

    public class StatusDialog
    extends ErrorDialog {
        public StatusDialog(Shell parentShell, String dialogTitle, String dialogMessage, String detailsTitle, IStatus status, int displayMask) {
            super(parentShell, dialogTitle, dialogMessage, status, displayMask);
        }

        protected void createButtonsForButtonBar(Composite parent) {
            Button OK = this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
            this.createDetailsButton(parent);
            OK.setFocus();
        }
    }
}

