/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.ui.query.wizard;

import com.ibm.team.enterprise.metadata.ui.query.util.PropertyChangeNotifier;
import com.ibm.team.enterprise.metadata.ui.query.wizard.Messages;
import com.ibm.team.enterprise.metadata.ui.query.wizard.MultipleSandboxLoadEvaluator;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingManager;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.PathLocation;
import com.ibm.team.filesystem.client.internal.load.LoadLocation;
import com.ibm.team.filesystem.client.internal.load.LoadRequest;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationFacade;
import com.ibm.team.filesystem.client.operations.IInvalidLoadLocation;
import com.ibm.team.filesystem.client.operations.IInvalidLoadRequest;
import com.ibm.team.filesystem.client.operations.ILoadLocation;
import com.ibm.team.filesystem.client.operations.ILoadOperation;
import com.ibm.team.filesystem.client.operations.ILoadRequest;
import com.ibm.team.filesystem.client.operations.IMultipleSandboxLoad;
import com.ibm.team.filesystem.client.operations.IShareableToLoad;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.utils.SWTUtil;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class SparseInput
extends PropertyChangeNotifier {
    private ILocation sandboxPath = new PathLocation(this.getWorkspaceRootPath()).getCanonicalForm();
    private ILoadOperation loadOperation;

    protected SparseInput() {
    }

    protected IPath getWorkspaceRootPath() {
        return ResourcesPlugin.getWorkspace().getRoot().getLocation();
    }

    public Collection<ISandbox> getKnownSandboxes() {
        ISharingManager mgr = FileSystemCore.getSharingManager();
        HashSet<ISandbox> sandboxes = mgr.getRegisteredSandboxes();
        ISandbox workspaceSandbox = mgr.getSandbox((ILocation)new PathLocation(this.getWorkspaceRootPath()), true);
        if (workspaceSandbox == null) {
            workspaceSandbox = mgr.getSandbox((ILocation)new PathLocation(this.getWorkspaceRootPath()), false);
            sandboxes = new HashSet<ISandbox>(sandboxes);
            sandboxes.add(workspaceSandbox);
        }
        return sandboxes;
    }

    public ILocation getSandboxPath() {
        return this.sandboxPath;
    }

    public void setSandboxPath(ILocation sandboxPath) {
        ILocation iLocation = sandboxPath = sandboxPath != null ? sandboxPath.getCanonicalForm() : null;
        if (this.sandboxPath == null && sandboxPath != null || this.sandboxPath != null && !this.sandboxPath.equals((Object)sandboxPath)) {
            this.sandboxPath = sandboxPath;
        }
    }

    public void evaluateLoadRequests(ILoadOperation loadOp, Collection<IMultipleSandboxLoad> multipleSandboxLoads, IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, null, (int)3);
        this.loadOperation = loadOp;
        this.loadOperation.evaluateLoadRequests((IProgressMonitor)sub.newChild(1));
        this.validateMultipleCopyFileAreas(this.evaluateLoadRequests((IProgressMonitor)sub.newChild(1)), multipleSandboxLoads, (IProgressMonitor)sub.newChild(1));
    }

    private MultipleSandboxLoadEvaluator evaluateLoadRequests(IProgressMonitor progress) throws FileSystemException, TeamRepositoryException {
        ISandbox sandbox;
        HashMap requestsByCFA = new HashMap();
        Collection loadRequests = this.loadOperation.getLoadRequests();
        for (ILoadRequest request : loadRequests) {
            HashSet<LoadRequest> requestsByConfig;
            HashMap<ConfigurationFacade, HashSet<LoadRequest>> requestsByConnection;
            sandbox = request.getSandbox();
            IConnection connection = request.getConnection();
            IComponentHandle component = request.getComponent();
            ConfigurationFacade config = new ConfigurationFacade(connection, component);
            HashMap requestsBySandbox = (HashMap)requestsByCFA.get(sandbox);
            if (requestsBySandbox == null) {
                requestsBySandbox = new HashMap();
                requestsByCFA.put(sandbox, requestsBySandbox);
            }
            if ((requestsByConnection = (HashMap<ConfigurationFacade, HashSet<LoadRequest>>)requestsBySandbox.get(connection)) == null) {
                requestsByConnection = new HashMap<ConfigurationFacade, HashSet<LoadRequest>>();
                requestsBySandbox.put(connection, requestsByConnection);
            }
            if ((requestsByConfig = (HashSet<LoadRequest>)requestsByConnection.get(config)) == null) {
                requestsByConfig = new HashSet<LoadRequest>();
                requestsByConnection.put(config, requestsByConfig);
            }
            requestsByConfig.add((LoadRequest)request);
        }
        MultipleSandboxLoadEvaluator loadEvaluator = null;
        for (Map.Entry entry : requestsByCFA.entrySet()) {
            sandbox = (ISandbox)entry.getKey();
            Map allRequests = (Map)entry.getValue();
            if (loadEvaluator == null) {
                loadEvaluator = new MultipleSandboxLoadEvaluator();
            }
            loadEvaluator.setRequests(sandbox, allRequests);
            loadEvaluator.setCollisionsValues(this.loadOperation.getCollisions());
            Collection a = this.loadOperation.getNewSharesToLoad();
            ArrayList<LoadLocation> result = new ArrayList<LoadLocation>();
            for (IShareableToLoad s : a) {
                ILoadLocation l = s.getLoadLocation();
                result.add((LoadLocation)l);
            }
            loadEvaluator.setTreesToLoadValues(result);
        }
        return loadEvaluator;
    }

    private void validateMultipleCopyFileAreas(MultipleSandboxLoadEvaluator evaluator, Collection<IMultipleSandboxLoad> result, IProgressMonitor progress) throws FileSystemException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        if (evaluator != null) {
            result.addAll(evaluator.getMultipleSandboxLoads((IProgressMonitor)monitor.newChild(100)));
        }
    }

    public void promptInvalidLoadRequests(final Shell shell) {
        final List<IStatus> status = this.processInvalidLoadRequests();
        if (!status.isEmpty()) {
            SWTUtil.greedyExec((Display)shell.getDisplay(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    ErrorDialog.openError((Shell)shell, (String)Messages.SparseLoadWizard_ReportError_InvalidLoad_1, null, (IStatus)StatusUtil.newStatus((Object)this, (String)Messages.SparseLoadWizard_ReportError_InvalidLoad_2, (Collection)status));
                }
            });
        }
    }

    private List<IStatus> processInvalidLoadRequests() {
        ArrayList<ILoadRequest> requests = new ArrayList<ILoadRequest>();
        ArrayList<IStatus> status = new ArrayList<IStatus>();
        Collection invalids = this.loadOperation.getInvalidLoadRequests();
        for (IInvalidLoadRequest invalidLoadRequest : invalids) {
            this.accumulateStatus(invalidLoadRequest, status);
            requests.add(invalidLoadRequest.getInvalidRequest());
        }
        Collection invalidLoadLocations = this.loadOperation.getInvalidLoadLocations();
        for (IInvalidLoadLocation invalidLoadLocation : invalidLoadLocations) {
            this.accumulateStatus(invalidLoadLocation, status);
            requests.add(invalidLoadLocation.getLoadRequest());
        }
        return status;
    }

    private Collection<IStatus> accumulateStatus(IInvalidLoadLocation invalidLoadLocation, List<IStatus> statusList) {
        IShareable share2;
        ILoadRequest loadRequest = invalidLoadLocation.getLoadRequest();
        for (ISandbox sandbox : invalidLoadLocation.getSandboxesOverlapped()) {
            statusList.add(StatusUtil.newStatus((Object)this, (String)NLS.bind((String)Messages.SparseLoadWizard_ReportError_SandboxesOverlap_1, (Object)loadRequest.getSandbox().getRoot().toOSString(), (Object)sandbox.getRoot().toOSString())));
        }
        for (ILoadRequest request : invalidLoadLocation.getLoadRequestsOverlapped()) {
            statusList.add(StatusUtil.newStatus((Object)this, (String)NLS.bind((String)Messages.SparseLoadWizard_ReportError_SandboxesOverlap_2, (Object)this.toString(loadRequest), (Object)this.toString(request))));
        }
        for (IShareable share2 : invalidLoadLocation.getSharesOverlapped()) {
            String sandboxRelativeLoadPath = loadRequest.getRelativeLoadPath().append(this.getVersionableName(loadRequest)).toString();
            statusList.add(StatusUtil.newStatus((Object)this, (String)NLS.bind((String)Messages.SparseLoadWizard_ReportError_SandboxesOverlap_3, (Object[])new Object[]{sandboxRelativeLoadPath, loadRequest.getSandbox().getRoot().toOSString(), share2.getShareable().getLocalPath().toString()})));
        }
        share2 = invalidLoadLocation.getPresentLoadLocation();
        if (share2 != null) {
            String sandboxRelativeLoadPath = loadRequest.getRelativeLoadPath().append(this.getVersionableName(loadRequest)).toString();
            statusList.add(StatusUtil.newStatus((Object)this, (String)NLS.bind((String)Messages.SparseLoadWizard_ReportError_SandboxesOverlap_3, (Object[])new Object[]{sandboxRelativeLoadPath, loadRequest.getSandbox().getRoot().toOSString(), share2.getLocalPath().toString()})));
        }
        return statusList;
    }

    private void accumulateStatus(IInvalidLoadRequest invalidLoadRequest, List<IStatus> status) {
        ILoadRequest request = invalidLoadRequest.getInvalidRequest();
        String path = null;
        if (request.getVersionableToLoad() instanceof IFolderHandle) {
            path = this.findFolder(request.getComponent(), (IFolderHandle)request.getVersionableToLoad());
        }
        if (path == null) {
            status.add(invalidLoadRequest.getStatus());
        } else {
            String message = null;
            switch (invalidLoadRequest.getReason()) {
                case InvalidProjectName: {
                    message = NLS.bind((String)"{0} is an invalid folder name.", (Object)path);
                    status.add(FileSystemStatusUtil.getStatusFor((int)2, (String)message));
                    break;
                }
                case NonExistantItem: {
                    message = NLS.bind((String)"{0} no longer exists in the configuration.", (Object)path);
                    status.add(FileSystemStatusUtil.getStatusFor((int)2, (String)message));
                    break;
                }
                case InvalidSandbox: {
                    status.add(invalidLoadRequest.getStatus());
                    break;
                }
                default: {
                    message = NLS.bind((String)"{0} could not be loaded because {1}", (Object)path, (Object)invalidLoadRequest.getReason().toString());
                    status.add(FileSystemStatusUtil.getStatusFor((int)2, (String)message));
                }
            }
        }
    }

    private String findFolder(IComponentHandle component, IFolderHandle folderToLoad) {
        return null;
    }

    private String toString(ILoadRequest loadRequest) {
        return loadRequest.getSandbox().getRoot().append(loadRequest.getRelativeLoadPath()).append(this.getVersionableName(loadRequest)).toOSString();
    }

    private String getVersionableName(ILoadRequest loadRequest) {
        if (loadRequest.getAlternativeName() != null && loadRequest.getAlternativeName().length() > 0) {
            return loadRequest.getAlternativeName();
        }
        return this.getName(loadRequest.getVersionableToLoad());
    }

    private String getName(IVersionableHandle handle) {
        if (handle instanceof IVersionable) {
            IVersionable v = (IVersionable)handle;
            return v.getName();
        }
        return Messages.SparseLoadWizard_UnknownVersionableName;
    }
}

