/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.ui.query.wizard;

import com.ibm.team.build.internal.ui.jobs.TeamBuildJob;
import com.ibm.team.enterprise.metadata.client.collection.ClientFactory;
import com.ibm.team.enterprise.metadata.client.collection.IMetadataCollectionClient;
import com.ibm.team.enterprise.metadata.ui.query.wizard.Messages;
import com.ibm.team.enterprise.metadata.ui.query.wizard.SetStreamScanningFirstPage;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.scm.common.IWorkspace;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWizard;

public class SetStreamScanningWizard
extends Wizard
implements IWorkbenchWizard {
    private SetStreamScanningFirstPage fFirstPage;
    private List<Map<String, String>> fStreams = null;
    private IMetadataCollectionClient fClient;
    private List<IWorkspace> initialSelectedStreams;

    public boolean canFinish() {
        return super.canFinish();
    }

    public void addPages() {
        super.addPages();
        this.fFirstPage = new SetStreamScanningFirstPage(Messages.SetStreamScanningWizardPageTitle, this.fStreams);
        this.fFirstPage.setTitle(Messages.SetStreamScanningWizardPageTitle);
        this.fFirstPage.setDescription(Messages.SetStreamScanningWizardPageDescription);
        this.addPage((IWizardPage)this.fFirstPage);
    }

    public void init(final IProcessAreaHandle processAreaHandle) {
        this.setWindowTitle(Messages.SetStreamScanningWizardTitle);
        final ITeamRepository teamRepository = (ITeamRepository)processAreaHandle.getOrigin();
        TeamBuildJob getScanningStatusJob = new TeamBuildJob(Messages.Job_RetrieveScanStatus_Name, true, teamRepository){

            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                IProjectAreaHandle projectAreaHandle;
                SetStreamScanningWizard.this.fClient = ClientFactory.getMetadataCollectionClient((ITeamRepository)teamRepository);
                String jsonString = "{}";
                if (processAreaHandle instanceof IProjectAreaHandle) {
                    projectAreaHandle = (IProjectAreaHandle)processAreaHandle;
                } else {
                    IProcessArea processArea = (IProcessArea)teamRepository.itemManager().fetchCompleteItem((IItemHandle)processAreaHandle, 0, monitor);
                    projectAreaHandle = processArea.getProjectArea();
                }
                jsonString = SetStreamScanningWizard.this.fClient.getScanningStatusForStreams(projectAreaHandle, monitor);
                JSONArray jsonArray = JSONArray.parse((Reader)new StringReader(jsonString));
                SetStreamScanningWizard.this.fStreams = (List)jsonArray;
                return Status.OK_STATUS;
            }

            protected void jobFinished(IStatus status) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (SetStreamScanningWizard.this.fFirstPage != null) {
                            SetStreamScanningWizard.this.fFirstPage.handleScanningStatusFinished(SetStreamScanningWizard.this.fStreams);
                            if (SetStreamScanningWizard.this.initialSelectedStreams != null) {
                                SetStreamScanningWizard.this.fFirstPage.setInitialSelectedStreams(SetStreamScanningWizard.this.initialSelectedStreams);
                            }
                        }
                    }
                });
            }
        };
        getScanningStatusJob.schedule();
    }

    public boolean performFinish() {
        final JSONArray jsonArray = new JSONArray();
        for (Map<String, String> stream : this.fStreams) {
            String scanFlag = "false";
            if (this.fFirstPage.getViewer().getChecked(stream)) {
                scanFlag = "true";
            }
            stream.put("scanFlag", scanFlag);
            JSONObject jsonObject = new JSONObject();
            jsonObject.putAll(stream);
            jsonArray.add((Object)jsonObject);
        }
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    SetStreamScanningWizard.this.fClient.updateScanningStatusForStreams(jsonArray.toString(), monitor);
                }
                catch (TeamRepositoryException tre) {
                    throw new InvocationTargetException(tre);
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InvocationTargetException ite) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.SetStreamScanningWizardTitle, (String)ite.getTargetException().getMessage());
        }
        catch (InterruptedException ie) {
            throw new OperationCanceledException();
        }
        return true;
    }

    public void init(IWorkbench arg0, IStructuredSelection arg1) {
    }

    public void setInitialSelectedStreams(List<IWorkspace> initialSelectedStreams) {
        this.initialSelectedStreams = new ArrayList<IWorkspace>(initialSelectedStreams);
    }
}

