/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.ui.query.wizard;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.enterprise.metadata.ui.query.util.Utils;
import com.ibm.team.enterprise.metadata.ui.query.wizard.FetchRepositoryWorkspacesJob;
import com.ibm.team.enterprise.metadata.ui.query.wizard.Messages;
import com.ibm.team.enterprise.metadata.ui.query.wizard.RepositoryWorkspaceLabelProvider;
import com.ibm.team.enterprise.metadata.ui.query.wizard.RepositoryWorkspaceNode;
import com.ibm.team.enterprise.metadata.ui.query.wizard.SparseLoadModel;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class SelectRepositoryWorkspacePage
extends WizardPage {
    private final SparseLoadModel model;
    private TableViewer viewer;

    protected SelectRepositoryWorkspacePage(SparseLoadModel model) {
        super("");
        this.model = model;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.setTitle(Messages.SparseLoadWizard_SelectRepositoryWorkspacePage_Title);
        this.setDescription(Messages.SparseLoadWizard_SelectRepositoryWorkspacePage_Description);
        this.viewer = new TableViewer(composite, 2820);
        this.viewer.setComparator(new ViewerComparator());
        this.viewer.setLabelProvider((IBaseLabelProvider)new RepositoryWorkspaceLabelProvider(this.model));
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = SelectRepositoryWorkspacePage.this.viewer.getSelection();
                if (selection instanceof IStructuredSelection) {
                    Object el = ((IStructuredSelection)selection).getFirstElement();
                    if (el instanceof RepositoryWorkspaceNode) {
                        String storedBuildUUID;
                        RepositoryWorkspaceNode rwsNode = (RepositoryWorkspaceNode)el;
                        SelectRepositoryWorkspacePage.this.model.setWorkspaceToLoadFrom(rwsNode.workspace);
                        int totalToLoad = SelectRepositoryWorkspacePage.this.model.getTotalNumberToLoad();
                        if (totalToLoad > 0 && rwsNode.numDependenciesMissing > 0) {
                            if (totalToLoad == rwsNode.numDependenciesMissing) {
                                SelectRepositoryWorkspacePage.this.setMessage(null);
                                SelectRepositoryWorkspacePage.this.setErrorMessage(Messages.SparseLoadWizard_SelectRepositoryWorkspacePage_AllFilesMissing);
                                SelectRepositoryWorkspacePage.this.setPageComplete(false);
                            } else {
                                SelectRepositoryWorkspacePage.this.setErrorMessage(null);
                                SelectRepositoryWorkspacePage.this.setMessage(Messages.SparseLoadWizard_SelectRepositoryWorkspacePage_SomeFilesMissing, 2);
                                SelectRepositoryWorkspacePage.this.setPageComplete(true);
                            }
                        } else {
                            SelectRepositoryWorkspacePage.this.setErrorMessage(null);
                            SelectRepositoryWorkspacePage.this.setMessage(null);
                            SelectRepositoryWorkspacePage.this.setPageComplete(true);
                        }
                        if (SelectRepositoryWorkspacePage.this.getErrorMessage() == null && SelectRepositoryWorkspacePage.this.model.isBuildDefinitionChecked() && SelectRepositoryWorkspacePage.this.model.getBuildDefinition() != null && (storedBuildUUID = Utils.retrieveBuildDefinitionMetadataProperty(rwsNode.workspace.getResolvedWorkspace().getItemId().getUuidValue())) != null && !storedBuildUUID.equals(SelectRepositoryWorkspacePage.this.model.getBuildDefinition().getItemId().getUuidValue())) {
                            String name;
                            try {
                                name = SelectRepositoryWorkspacePage.getBuildDefinition(SelectRepositoryWorkspacePage.this.model.getRepository(), storedBuildUUID, null).getId();
                            }
                            catch (TeamRepositoryException e) {
                                name = storedBuildUUID;
                            }
                            String message = NLS.bind((String)Messages.SparseLoadWizard_SelectRepositoryWorkspacePage_BuildDefinitionDifferent, (Object[])new String[]{SelectRepositoryWorkspacePage.this.model.getBuildDefinition().getId(), name});
                            if (SelectRepositoryWorkspacePage.this.getMessage() != null) {
                                message = String.valueOf(SelectRepositoryWorkspacePage.this.getMessageType() == 2 ? "2 warnings: 1- " : "2 messages: 1- ") + SelectRepositoryWorkspacePage.this.getMessage() + " 2- " + message;
                            }
                            SelectRepositoryWorkspacePage.this.setMessage(message, 2);
                            SelectRepositoryWorkspacePage.this.setErrorMessage(null);
                            SelectRepositoryWorkspacePage.this.setPageComplete(true);
                        }
                    } else {
                        SelectRepositoryWorkspacePage.this.setPageComplete(false);
                        SelectRepositoryWorkspacePage.this.model.setWorkspaceToLoadFrom(null);
                        SelectRepositoryWorkspacePage.this.setErrorMessage(Messages.SparseLoadWizard_SelectRepositoryWorkspacePage_RWS_Must_Be_Selected);
                    }
                }
            }
        });
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = 250;
        this.viewer.getTable().setLayoutData((Object)gridData);
        final Button filterButton = new Button(composite, 32);
        filterButton.setSelection(true);
        filterButton.setText(Messages.SparseLoadWizard_SelectRepositoryWorkspacePage_FilterButtonText);
        filterButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SelectRepositoryWorkspacePage.this.viewer.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof RepositoryWorkspaceNode[]) {
                    Object[] nodes = (RepositoryWorkspaceNode[])inputElement;
                    if (filterButton.getSelection()) {
                        ArrayList<Object> filteredList = new ArrayList<Object>();
                        Object[] objectArray = nodes;
                        int n = nodes.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object node = objectArray[n2];
                            if (((RepositoryWorkspaceNode)node).numDependenciesMissing == 0) {
                                filteredList.add(node);
                            }
                            ++n2;
                        }
                        return filteredList.toArray();
                    }
                    return nodes;
                }
                if (inputElement instanceof String) {
                    return new Object[]{inputElement};
                }
                return null;
            }
        });
        this.setControl((Control)composite);
        this.clearRWSList();
    }

    public void clearRWSList() {
        this.viewer.setInput((Object)Messages.SparseLoadWizard_Pending);
        this.setPageComplete(false);
    }

    public void scheduleRWSUpdate(UUID toSelect) {
        new FetchRepositoryWorkspacesJob(this.model, this.viewer, toSelect).schedule();
    }

    public static IBuildDefinition getBuildDefinition(ITeamRepository repo, String buildDefinitionUUID, IProgressMonitor monitor) throws TeamRepositoryException {
        IItem buildDefn;
        if (repo != null && (buildDefn = repo.itemManager().fetchCompleteItem(IBuildDefinition.ITEM_TYPE.createItemHandle(UUID.valueOf((String)buildDefinitionUUID), null), 0, monitor)) instanceof IBuildDefinition) {
            return (IBuildDefinition)buildDefn;
        }
        return null;
    }
}

