/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.ui.query.wizard;

import com.ibm.team.enterprise.metadata.ui.query.util.UIUtils;
import com.ibm.team.enterprise.metadata.ui.query.wizard.CombinedStatus;
import com.ibm.team.enterprise.metadata.ui.query.wizard.CopyFileAreaCombo;
import com.ibm.team.enterprise.metadata.ui.query.wizard.Messages;
import com.ibm.team.enterprise.metadata.ui.query.wizard.SparseInput;
import com.ibm.team.enterprise.metadata.ui.query.wizard.SparseLoadFilesContentProvider;
import com.ibm.team.enterprise.metadata.ui.query.wizard.SparseLoadModel;
import com.ibm.team.enterprise.metadata.ui.query.wizard.SparseLoadNode;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.internal.PathLocation;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.ui.parts.WidgetToolkit;
import com.ibm.team.repository.rcp.ui.utils.WidgetFactoryContext;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IAncestorReport;
import com.ibm.team.scm.common.dto.INameItemPair;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardContainer2;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;

public class SelectFilesToLoadPage
extends WizardPage
implements IPropertyChangeListener {
    private CheckboxTreeViewer viewer;
    private final boolean showAdvancedTwistie;
    private boolean bCopyFileAreaExist = false;
    private DataBindingContext dataBindingContext;
    private final CombinedStatus validationStatus = new CombinedStatus();
    private SparseInput sparseInput;

    protected SelectFilesToLoadPage() {
        super("");
        this.showAdvancedTwistie = true;
    }

    private void uncheckKnownSubtree(Object root, SparseLoadFilesContentProvider provider) {
        this.viewer.setChecked(root, false);
        Object[] kids = provider.getCachedKids(root);
        int numKids = kids == null ? 0 : kids.length;
        int i = 0;
        while (i < numKids) {
            this.uncheckKnownSubtree(kids[i], provider);
            ++i;
        }
    }

    private void greyCheckParents(Object obj) {
        while (obj instanceof SparseLoadNode) {
            obj = ((SparseLoadNode)obj).getParent();
            this.viewer.setGrayChecked(obj, true);
        }
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        super.setControl((Control)composite);
        this.createBody(composite);
    }

    private void createBody(Composite composite) {
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer = new CheckboxTreeViewer(composite);
        final SparseLoadFilesContentProvider provider = new SparseLoadFilesContentProvider();
        this.viewer.setContentProvider((IContentProvider)provider);
        this.viewer.setLabelProvider((IBaseLabelProvider)provider);
        this.viewer.setComparator(new ViewerComparator());
        this.viewer.setUseHashlookup(true);
        this.viewer.addCheckStateListener(new ICheckStateListener(){

            /*
             * Unable to fully structure code
             */
            public void checkStateChanged(CheckStateChangedEvent event) {
                block4: {
                    obj = event.getElement();
                    checked = event.getChecked();
                    SelectFilesToLoadPage.access$0(SelectFilesToLoadPage.this).setGrayed(obj, false);
                    kids = provider.getCachedKids(obj);
                    numKids = kids == null ? 0 : kids.length;
                    i = 0;
                    while (i < numKids) {
                        SelectFilesToLoadPage.access$1(SelectFilesToLoadPage.this, kids[i], provider);
                        ++i;
                    }
                    if (!checked) ** GOTO lbl29
                    SelectFilesToLoadPage.access$2(SelectFilesToLoadPage.this, obj);
                    break block4;
lbl-1000:
                    // 1 sources

                    {
                        obj = ((SparseLoadNode)obj).getParent();
                        if (!SelectFilesToLoadPage.access$0(SelectFilesToLoadPage.this).getChecked(obj)) continue;
                        anyChecked = false;
                        cachedKids = provider.getCachedKids(obj);
                        numCachedKids = cachedKids == null ? 0 : cachedKids.length;
                        i = 0;
                        while (i < numCachedKids && !anyChecked) {
                            if (SelectFilesToLoadPage.access$0(SelectFilesToLoadPage.this).getChecked(cachedKids[i])) {
                                anyChecked = true;
                            }
                            ++i;
                        }
                        if (anyChecked) continue;
                        SelectFilesToLoadPage.access$0(SelectFilesToLoadPage.this).setGrayChecked(obj, false);
lbl29:
                        // 4 sources

                        ** while (obj instanceof SparseLoadNode)
                    }
                }
            }
        });
        this.setTitle(Messages.SparseLoadWizard_SelectFilesToLoadPage_Title);
        this.setDescription(Messages.SparseLoadWizard_SelectFilesToLoadPage_Description);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = 250;
        this.viewer.getTree().setLayoutData((Object)gridData);
        if (this.getSparseInput() != null) {
            this.createCopyFileAreaExpander(composite);
        }
    }

    public void ensureModelExists(SparseLoadModel model) {
        if (!(this.viewer.getInput() instanceof SparseLoadModel)) {
            this.updateModel(model);
        }
    }

    public void updateModel(final SparseLoadModel model) {
        this.viewer.setInput((Object)model);
        final ArrayList initiallyExpandedFolders = new ArrayList();
        final ArrayList initiallyCheckedElements = new ArrayList();
        try {
            this.getWizard().getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    try {
                        SelectFilesToLoadPage.this.precacheTree(model, initiallyCheckedElements, initiallyExpandedFolders, monitor);
                    }
                    catch (TeamRepositoryException ex) {
                        throw new InvocationTargetException(ex);
                    }
                }
            });
        }
        catch (InvocationTargetException ex) {
            UIUtils.showError(Messages.SparseLoadWizard_Error, Messages.SparseLoadWizard_SelectFilesToLoadPage_ErrorSearchingForFiles, ex.getTargetException());
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        for (SparseLoadNode folder : initiallyExpandedFolders) {
            this.viewer.expandToLevel((Object)folder, 1);
        }
        Object[] initCheckArray = initiallyCheckedElements.toArray();
        this.viewer.setCheckedElements(initCheckArray);
        Object[] objectArray = initCheckArray;
        int n = initCheckArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            this.greyCheckParents(obj);
            ++n2;
        }
    }

    public void precacheTree(SparseLoadModel model, List<SparseLoadNode> initiallyCheckedElements, List<SparseLoadNode> initiallyExpandedFolders, IProgressMonitor monitor) throws TeamRepositoryException {
        initiallyCheckedElements.clear();
        initiallyExpandedFolders.clear();
        SparseLoadFilesContentProvider contentProvider = (SparseLoadFilesContentProvider)this.viewer.getContentProvider();
        Object[] rwsNode = contentProvider.precomputeCacheFor(model, monitor);
        Object[] compNodes = null;
        if (rwsNode != null && rwsNode.length == 1 && rwsNode[0] instanceof IWorkspaceConnection) {
            compNodes = contentProvider.precomputeCacheFor(rwsNode[0], monitor);
        }
        if (compNodes != null) {
            for (Map.Entry<UUID, Set<UUID>> thisCompLoads : model.getVersionablesToLoad().entrySet()) {
                HashSet<UUID> processedFolders = new HashSet<UUID>();
                IConfiguration config = model.getWorkspaceToLoadFrom().configuration((IComponentHandle)IComponent.ITEM_TYPE.createItemHandle(thisCompLoads.getKey(), null));
                ArrayList<IVersionableHandle> versionableHandles = new ArrayList<IVersionableHandle>();
                for (UUID thisFileUUID : thisCompLoads.getValue()) {
                    versionableHandles.add((IVersionableHandle)IFileItem.ITEM_TYPE.createItemHandle(thisFileUUID, null));
                }
                List reports = config.determineAncestorsInHistory(versionableHandles, monitor);
                for (IAncestorReport report : reports) {
                    Object[] potentialNodes = compNodes;
                    List niPairs = report.getNameItemPairs();
                    int numPairs = niPairs.size();
                    int i = 0;
                    while (i < numPairs) {
                        int numPotentialNodes = potentialNodes == null ? 0 : potentialNodes.length;
                        INameItemPair niPair = (INameItemPair)niPairs.get(i);
                        SparseLoadNode matchingNode = null;
                        int j = 0;
                        while (j < numPotentialNodes && matchingNode == null) {
                            SparseLoadNode node;
                            if (potentialNodes[j] instanceof SparseLoadNode && (node = (SparseLoadNode)potentialNodes[j]).getHandle().getItemId().equals((Object)niPair.getItem().getItemId())) {
                                matchingNode = node;
                            }
                            ++j;
                        }
                        if (matchingNode != null) {
                            if (i == numPairs - 1) {
                                initiallyCheckedElements.add(matchingNode);
                            } else {
                                UUID folderUUID;
                                if (i == numPairs - 2 && processedFolders.add(folderUUID = matchingNode.getHandle().getItemId())) {
                                    initiallyExpandedFolders.add(matchingNode);
                                }
                                potentialNodes = contentProvider.precomputeCacheFor(matchingNode, monitor);
                            }
                        }
                        ++i;
                    }
                }
            }
        }
    }

    public List<Object> getFullyCheckedElements() {
        ArrayList<Object> fullyCheckedElements = new ArrayList<Object>();
        Object[] allCheckedElements = this.viewer.getCheckedElements();
        int numElements = allCheckedElements == null ? 0 : allCheckedElements.length;
        int i = 0;
        while (i < numElements) {
            if (!this.viewer.getGrayed(allCheckedElements[i])) {
                fullyCheckedElements.add(allCheckedElements[i]);
            }
            ++i;
        }
        return fullyCheckedElements;
    }

    public void setSparseInput(SparseInput sparseInput) {
        this.sparseInput = sparseInput;
        if (!this.bCopyFileAreaExist) {
            this.createCopyFileAreaExpander((Composite)this.getControl());
        }
    }

    private SparseInput getSparseInput() {
        return this.sparseInput;
    }

    public void dispose() {
        super.dispose();
        if (this.dataBindingContext != null) {
            this.dataBindingContext.dispose();
        }
        if (this.sparseInput != null) {
            this.sparseInput.removePropertyChangeListener(this);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("com.ibm.team.filesystem.ide.ui.ErrorMessageProperty")) {
            this.getContainer().updateButtons();
        }
    }

    private void createCopyFileAreaExpander(final Composite parent) {
        this.bCopyFileAreaExist = true;
        WidgetFactoryContext context = WidgetFactoryContext.forWizardPage((IWizardPage)this);
        this.dataBindingContext = new DataBindingContext();
        if (this.showAdvancedTwistie) {
            WidgetToolkit toolkit = context.getToolkit();
            ExpandableComposite copyFileAreaPart = toolkit.createExpandableComposite(parent, 18);
            copyFileAreaPart.setText(Messages.SparseLoadWizard_SelectFilesToLoadPage_AdvancedFeatures);
            copyFileAreaPart.setLayoutData((Object)new GridData(4, 4, true, false));
            copyFileAreaPart.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

                public void expansionStateChanged(ExpansionEvent e) {
                    parent.layout();
                    IWizardContainer container = SelectFilesToLoadPage.this.getContainer();
                    if (container instanceof IWizardContainer2) {
                        ((IWizardContainer2)container).updateSize();
                    }
                }
            });
            Composite composite = new Composite((Composite)copyFileAreaPart, 0);
            copyFileAreaPart.setClient((Control)composite);
            composite.setLayoutData((Object)new GridData(4, 4, true, true));
            this.createCopyFileAreaPart(composite, context);
            GridLayoutFactory.fillDefaults().numColumns(3).applyTo(composite);
            copyFileAreaPart.setExpanded(!this.isEclipseSandboxSelected());
        } else {
            Composite composite = new Composite(parent, 0);
            composite.setLayoutData((Object)new GridData(4, 4, true, true));
            this.createCopyFileAreaPart(composite, context);
            GridLayoutFactory.fillDefaults().numColumns(3).applyTo(composite);
        }
        parent.layout();
    }

    private void createCopyFileAreaPart(Composite composite, WidgetFactoryContext context) {
        CopyFileAreaCombo copyFileAreaCombo = new CopyFileAreaCombo(composite, context, this.getCopyFileAreaComboDescription()){

            @Override
            protected boolean filterSandbox(ISandbox sandbox) {
                return !SelectFilesToLoadPage.this.getStorageIdForPage().equals(sandbox.getRoot().getStorageId());
            }

            @Override
            protected ILocation createSandboxLocation(Shell shell) {
                return SelectFilesToLoadPage.this.createSandboxLocation(shell);
            }
        };
        IObservableValue connectionStatus = copyFileAreaCombo.connectLoadInput(this.getSparseInput(), this.dataBindingContext);
        this.validationStatus.addStatus(connectionStatus);
    }

    private String getStorageIdForPage() {
        return "com.ibm.team.filesystem.hfs";
    }

    private ILocation createSandboxLocation(Shell shell) {
        DirectoryDialog dialog = new DirectoryDialog(shell);
        dialog.setFilterPath(new PathLocation(ResourcesPlugin.getWorkspace().getRoot().getLocation()).toOSString());
        String pathString = dialog.open();
        if (pathString != null) {
            IPath path = Path.fromOSString((String)pathString);
            return new PathLocation(path);
        }
        return null;
    }

    private String getCopyFileAreaComboDescription() {
        return Messages.SparseLoadWizard_SelectFilesToLoadPage_CopyFileAreaPickerDescription;
    }

    private boolean isEclipseSandboxSelected() {
        ILocation curSandboxPath = this.getSparseInput().getSandboxPath();
        Object adapted = curSandboxPath.getAdapter(IPath.class);
        if (adapted == null) {
            return false;
        }
        IPath rootPath = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        return rootPath.equals(adapted);
    }

    static /* synthetic */ CheckboxTreeViewer access$0(SelectFilesToLoadPage selectFilesToLoadPage) {
        return selectFilesToLoadPage.viewer;
    }

    static /* synthetic */ void access$1(SelectFilesToLoadPage selectFilesToLoadPage, Object object, SparseLoadFilesContentProvider sparseLoadFilesContentProvider) {
        selectFilesToLoadPage.uncheckKnownSubtree(object, sparseLoadFilesContentProvider);
    }

    static /* synthetic */ void access$2(SelectFilesToLoadPage selectFilesToLoadPage, Object object) {
        selectFilesToLoadPage.greyCheckParents(object);
    }
}

