/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.ui.query.wizard;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.enterprise.build.ui.dialogs.DependencyBuildDefinitionSelectionDialog;
import com.ibm.team.enterprise.metadata.ui.query.wizard.Messages;
import com.ibm.team.enterprise.metadata.ui.query.wizard.SparseLoadModel;
import com.ibm.team.enterprise.systemdefinition.common.model.ILanguageDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.ui.dialogs.LanguageDefinitionSelectionDialog;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class SearchPathPage
extends WizardPage {
    private final int DEF_FIELD_WIDTH = 250;
    private final int DEF_FIELD_INDENT = 45;
    private final ITeamRepository repo;
    private boolean applySearchPath;
    private Button applySearchPathButton;
    private Label langdefLabel;
    private Text langdefField;
    private Button browseLangdefButton;
    private Label builddefLabel;
    private Text builddefField;
    private Button browseBuilddefButton;
    private ILanguageDefinition langdef;
    private IBuildDefinition builddef;
    private final SparseLoadModel model;

    protected SearchPathPage(ITeamRepository repo, SparseLoadModel model) {
        super("");
        this.repo = repo;
        this.model = model;
    }

    private void toggleSearchPathFieldEnablement() {
        boolean enable = this.applySearchPathButton.getSelection();
        this.langdefLabel.setEnabled(enable);
        this.langdefField.setEnabled(enable);
        this.browseLangdefButton.setEnabled(enable);
        this.builddefLabel.setEnabled(enable);
        this.builddefField.setEnabled(enable);
        this.browseBuilddefButton.setEnabled(enable);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.setTitle(Messages.SparseLoadWizard_SearchPathPage_Title);
        this.setDescription(Messages.SparseLoadWizard_SearchPathPage_Description);
        this.applySearchPathButton = new Button(composite, 32);
        this.applySearchPathButton.setText(Messages.SparseLoadWizard_SearchPathPage_ApplySearchPath);
        GridData data = new GridData();
        data.horizontalIndent = 20;
        data.horizontalSpan = 3;
        this.applySearchPathButton.setLayoutData((Object)data);
        this.langdefLabel = new Label(composite, 0);
        this.langdefLabel.setText(Messages.SparseLoadWizard_SearchPathPage_LanguageDefinition);
        data = new GridData();
        data.horizontalIndent = 45;
        this.langdefLabel.setLayoutData((Object)data);
        this.langdefField = new Text(composite, 2056);
        data = new GridData();
        data.widthHint = 250;
        this.langdefField.setEditable(false);
        this.langdefField.setLayoutData((Object)data);
        this.browseLangdefButton = new Button(composite, 0);
        this.browseLangdefButton.setText(Messages.SparseLoadWizard_SearchPathPage_Browse);
        this.browseLangdefButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LanguageDefinitionSelectionDialog dialog = new LanguageDefinitionSelectionDialog(SearchPathPage.this.getShell(), SearchPathPage.this.repo, null, new ViewerFilter(){

                    public boolean select(Viewer viewer, Object parentElement, Object element) {
                        if (element instanceof ILanguageDefinition) {
                            return ((ILanguageDefinition)element).getTranslators().size() > 0;
                        }
                        return true;
                    }
                }, null);
                if (dialog != null && dialog.open() == 0) {
                    ISystemDefinition systemDefinition = dialog.getSelectedSystemDefinition();
                    SearchPathPage.this.langdef = (ILanguageDefinition)systemDefinition;
                    if (SearchPathPage.this.langdef != null) {
                        SearchPathPage.this.langdefField.setText(SearchPathPage.this.langdef.getName());
                    }
                    SearchPathPage.this.validatePage();
                }
            }
        });
        this.builddefLabel = new Label(composite, 0);
        this.builddefLabel.setText(Messages.SparseLoadWizard_SearchPathPage_BuildDefinition);
        data = new GridData();
        data.horizontalIndent = 45;
        this.builddefLabel.setLayoutData((Object)data);
        this.builddefField = new Text(composite, 2056);
        data = new GridData();
        data.widthHint = 250;
        this.builddefField.setEditable(false);
        this.builddefField.setLayoutData((Object)data);
        this.browseBuilddefButton = new Button(composite, 0);
        this.browseBuilddefButton.setText(Messages.SparseLoadWizard_SearchPathPage_Browse);
        this.browseBuilddefButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IProcessAreaHandle processArea = null;
                DependencyBuildDefinitionSelectionDialog dialog = new DependencyBuildDefinitionSelectionDialog(SearchPathPage.this.getShell(), false, processArea);
                if (dialog.open() == 0) {
                    SearchPathPage.this.builddef = dialog.getFirstSelectedBuildDefinition();
                    if (SearchPathPage.this.builddef != null) {
                        SearchPathPage.this.builddefField.setText(SearchPathPage.this.builddef.getId());
                    }
                    SearchPathPage.this.validatePage();
                }
            }
        });
        this.toggleSearchPathFieldEnablement();
        this.applySearchPathButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                SearchPathPage.this.applySearchPath = SearchPathPage.this.applySearchPathButton.getSelection();
                SearchPathPage.this.toggleSearchPathFieldEnablement();
                SearchPathPage.this.validatePage();
            }
        });
        this.applySearchPath = false;
        this.applySearchPathButton.setSelection(this.applySearchPath);
        this.setControl((Control)composite);
    }

    private boolean builddefRequired() {
        return true;
    }

    private void validatePage() {
        String errMsg = null;
        if (!this.repo.loggedIn()) {
            errMsg = Messages.SparseLoadWizard_SearchPathPage_NotLoggedIn;
        } else if (this.applySearchPathButton.getSelection()) {
            if (this.langdef == null) {
                errMsg = Messages.SparseLoadWizard_SearchPathPage_LangdefRequired;
            } else if (this.builddefRequired() && this.builddef == null) {
                errMsg = Messages.SparseLoadWizard_SearchPathPage_BuilddefRequired;
            }
        }
        this.setErrorMessage(errMsg);
        this.setPageComplete(errMsg == null);
        if (this.applySearchPathButton.getSelection()) {
            this.model.setBuildDefinition(this.builddef);
        } else {
            this.model.setBuildDefinition(null);
        }
    }

    public boolean applySearchPath() {
        return this.applySearchPath;
    }

    public ILanguageDefinition getLangdef() {
        return this.langdef;
    }

    public IBuildDefinition getBuilddef() {
        return this.builddef;
    }
}

