/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.ui.query.wizard;

import com.ibm.team.enterprise.metadata.ui.query.wizard.Messages;
import com.ibm.team.enterprise.metadata.ui.query.wizard.RepositoryWorkspaceNode;
import com.ibm.team.enterprise.metadata.ui.query.wizard.SparseLoadModel;
import com.ibm.team.internal.filesystem.ui.ImagePool;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;

public class RepositoryWorkspaceLabelProvider
extends LabelProvider {
    private final SparseLoadModel model;
    private Image workspaceImage;

    public RepositoryWorkspaceLabelProvider(SparseLoadModel model) {
        this.model = model;
    }

    public String getText(Object element) {
        if (element instanceof RepositoryWorkspaceNode) {
            RepositoryWorkspaceNode rwsNode = (RepositoryWorkspaceNode)element;
            int totalToLoad = this.model.getTotalNumberToLoad();
            if (rwsNode.numDependenciesMissing > 0 && totalToLoad > 0) {
                return NLS.bind((String)Messages.SparseLoadWizard_SelectRepositoryWorkspacePage_RWSMissingDeps, (Object[])new String[]{rwsNode.workspace.getName(), Integer.toString(rwsNode.numDependenciesMissing), Integer.toString(totalToLoad)});
            }
            return rwsNode.workspace.getName();
        }
        return super.getText(element);
    }

    public Image getImage(Object element) {
        if (element instanceof RepositoryWorkspaceNode) {
            if (this.workspaceImage == null) {
                this.workspaceImage = ImagePool.WORKSPACE.createImage();
            }
            return this.workspaceImage;
        }
        return super.getImage(element);
    }

    public void dispose() {
        super.dispose();
        if (this.workspaceImage != null) {
            this.workspaceImage.dispose();
        }
    }
}

