/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.ui.query.wizard;

import com.ibm.icu.text.MessageFormat;
import com.ibm.team.enterprise.metadata.query.common.Attribute;
import com.ibm.team.enterprise.metadata.query.common.IAttribute;
import com.ibm.team.enterprise.metadata.ui.query.dialog.AttributeContentProvider;
import com.ibm.team.enterprise.metadata.ui.query.dialog.AttributeNamespace;
import com.ibm.team.enterprise.metadata.ui.query.util.Utils;
import com.ibm.team.enterprise.metadata.ui.query.wizard.Messages;
import com.ibm.team.enterprise.metadata.ui.query.wizard.NewAttributeWizard;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class NewAttributeFirstPage
extends WizardPage {
    private Text nameField;
    private Combo namespaceField;
    private Combo typeField;
    private String initialName;
    private String initialNamespace;
    private IAttribute.AttributeType initialType;

    public NewAttributeFirstPage() {
        super("NewAttributeFirstPage");
        this.setTitle(Messages.NewAttributeFirstPage_Title);
        this.setDescription(Messages.NewAttributeFirstPage_NewDescription);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite);
        Label label = new Label(composite, 16384);
        label.setText(Messages.NewAttributeFirstPage_NameLabel);
        this.nameField = new Text(composite, 2048);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.nameField);
        if (this.initialName != null) {
            this.nameField.setText(this.initialName);
        }
        this.nameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                NewAttributeFirstPage.this.checkPageComplete();
            }
        });
        label = new Label(composite, 16384);
        label.setText(Messages.NewAttributeFirstPage_NamespaceLabel);
        this.namespaceField = new Combo(composite, 2048);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.namespaceField);
        AttributeContentProvider attributeContentProvider = ((NewAttributeWizard)this.getWizard()).getAttributeContentProvider();
        List<AttributeNamespace> namespaces = attributeContentProvider.getNamespaces();
        for (AttributeNamespace namespace : namespaces) {
            this.namespaceField.add(namespace.getNamespace());
        }
        if (this.initialNamespace != null) {
            this.namespaceField.setText(this.initialNamespace);
        }
        this.namespaceField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                NewAttributeFirstPage.this.checkPageComplete();
            }
        });
        label = new Label(composite, 16384);
        label.setText(Messages.NewAttributeFirstPage_TypeLabel);
        this.typeField = new Combo(composite, 8);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.typeField);
        IAttribute.AttributeType[] attributeTypes = IAttribute.AttributeType.values();
        int i = 0;
        while (i < attributeTypes.length) {
            IAttribute.AttributeType attributeType = attributeTypes[i];
            if (attributeType != IAttribute.AttributeType.COMPLEX) {
                String attributeTypeLabel = Attribute.getTypeLabel((IAttribute.AttributeType)attributeType);
                this.typeField.add(attributeTypeLabel);
                this.typeField.setData(attributeTypeLabel, (Object)attributeType);
            }
            ++i;
        }
        if (this.initialType != null) {
            i = 0;
            while (i < this.typeField.getItemCount()) {
                String item = this.typeField.getItem(i);
                if (item.equals(Attribute.getTypeLabel((IAttribute.AttributeType)this.initialType))) {
                    this.typeField.select(i);
                    break;
                }
                ++i;
            }
        } else {
            this.typeField.select(0);
        }
        this.typeField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                NewAttributeFirstPage.this.checkPageComplete();
            }
        });
        this.setControl((Control)composite);
        this.checkPageComplete();
        this.setErrorMessage(null);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "com.ibm.team.filesystem.ide.ui.wizard_newAttributePage1");
    }

    public void setInitialName(String name) {
        if (name != null) {
            this.initialName = name;
        }
    }

    public void setInitialNamespace(String namespace) {
        if (namespace != null) {
            this.initialNamespace = namespace;
        }
    }

    public void setInitialType(IAttribute.AttributeType type) {
        if (type != null) {
            this.initialType = type;
        }
    }

    public String getName() {
        return this.nameField.getText();
    }

    public String getNamespace() {
        return this.namespaceField.getText();
    }

    public IAttribute.AttributeType getType() {
        return (IAttribute.AttributeType)this.typeField.getData(this.typeField.getText());
    }

    private IStatus validate() {
        String name = this.getName();
        if (name.trim().length() == 0) {
            return new Status(4, "com.ibm.team.enterprise.metadata.ui", Messages.NewAttributeFirstPage_InvalidName1);
        }
        Character ch = Utils.findFirstNonLetterOrNumeric(name);
        if (ch != null) {
            return new Status(4, "com.ibm.team.enterprise.metadata.ui", MessageFormat.format((String)Messages.NewAttributeFirstPage_InvalidName2, (Object[])new String[]{String.valueOf(ch.charValue()), name}));
        }
        String namespace = this.getNamespace();
        if (namespace.trim().length() == 0) {
            return new Status(4, "com.ibm.team.enterprise.metadata.ui", Messages.NewAttributeFirstPage_InvalidNamespace1);
        }
        if (this.getType() == null) {
            return new Status(4, "com.ibm.team.enterprise.metadata.ui", Messages.NewAttributeFirstPage_InvalidType);
        }
        return Status.OK_STATUS;
    }

    private void checkPageComplete() {
        IStatus status = this.validate();
        if (status.isOK()) {
            this.setErrorMessage(null);
            this.setPageComplete(true);
        } else if (status.getSeverity() == 4) {
            this.setErrorMessage(status.getMessage());
            this.setPageComplete(false);
        }
    }
}

