/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.ui.query.wizard;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.load.LoadLocation;
import com.ibm.team.filesystem.client.internal.load.LoadRequest;
import com.ibm.team.filesystem.client.internal.operations.MultipleSandboxLoad;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationFacade;
import com.ibm.team.filesystem.client.operations.ICollision;
import com.ibm.team.filesystem.client.operations.ILoadLocation;
import com.ibm.team.filesystem.client.operations.IMultipleSandboxLoad;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.common.IComponentHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class MultipleSandboxLoadEvaluator {
    private Map<ISandbox, Map<IConnection, Map<ConfigurationFacade, Set<LoadRequest>>>> requestsByCFA;
    private Collection<ICollision> collisionsValues;
    private Collection<LoadLocation> treesToLoadValues;

    public void setCollisionsValues(Collection<ICollision> collisionsValues) {
        this.collisionsValues = collisionsValues;
    }

    public void setTreesToLoadValues(Collection<LoadLocation> treesToLoadValues) {
        this.treesToLoadValues = treesToLoadValues;
    }

    public final Collection<ICollision> getCollisionsValues() {
        return this.collisionsValues;
    }

    public final Collection<LoadLocation> getItemsToLoadValues() {
        return this.treesToLoadValues;
    }

    public final Collection<IMultipleSandboxLoad> getMultipleSandboxLoads(IProgressMonitor progress) throws FileSystemException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        Set<ConfigurationFacade> affectedConfigurations = this.getAffectedConfigurations();
        Map<ConfigurationFacade, Set<ISandbox>> configurationSandboxes = this.getConfigurationSandboxes_PF(affectedConfigurations, (IProgressMonitor)monitor.newChild(10));
        return this.validateMultipleCopyFileAreas(configurationSandboxes, (IProgressMonitor)monitor.newChild(90));
    }

    public void setRequests(ISandbox sandbox, Map<IConnection, Map<ConfigurationFacade, Set<LoadRequest>>> requests) {
        if (this.requestsByCFA == null) {
            this.requestsByCFA = new HashMap<ISandbox, Map<IConnection, Map<ConfigurationFacade, Set<LoadRequest>>>>();
        }
        HashMap bySandbox = new HashMap();
        this.requestsByCFA.put(sandbox, bySandbox);
        for (Map.Entry<IConnection, Map<ConfigurationFacade, Set<LoadRequest>>> entry : requests.entrySet()) {
            HashMap byConnection = new HashMap();
            bySandbox.put(entry.getKey(), byConnection);
            for (Map.Entry<ConfigurationFacade, Set<LoadRequest>> entry2 : entry.getValue().entrySet()) {
                byConnection.put(entry2.getKey(), new HashSet(entry2.getValue()));
            }
        }
    }

    private Set<ConfigurationFacade> getAffectedConfigurations() {
        HashSet<ConfigurationFacade> configurationsAffected = new HashSet<ConfigurationFacade>();
        for (Map<IConnection, Map<ConfigurationFacade, Set<LoadRequest>>> requestsByConnection : this.requestsByCFA.values()) {
            for (Map<ConfigurationFacade, Set<LoadRequest>> requestsByConfig : requestsByConnection.values()) {
                configurationsAffected.addAll(requestsByConfig.keySet());
            }
        }
        return configurationsAffected;
    }

    private Map<ConfigurationFacade, Set<ISandbox>> getConfigurationSandboxes_PF(Set<ConfigurationFacade> affectedConfigurations, IProgressMonitor progress) throws FileSystemException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)affectedConfigurations.size());
        HashMap<ConfigurationFacade, Set<ISandbox>> result = new HashMap<ConfigurationFacade, Set<ISandbox>>();
        for (ConfigurationFacade configuration : affectedConfigurations) {
            Collection sandboxes = SharingManager.getInstance().getSandboxes(configuration, (IProgressMonitor)monitor.newChild(1));
            result.put(configuration, new HashSet(sandboxes));
        }
        return result;
    }

    private Collection<IMultipleSandboxLoad> validateMultipleCopyFileAreas(Map<ConfigurationFacade, Set<ISandbox>> configurationSandboxes, IProgressMonitor monitor) throws FileSystemException {
        HashMap<ConfigurationFacade, Set<ISandbox>> multipleCFA = new HashMap<ConfigurationFacade, Set<ISandbox>>();
        HashMap<ConfigurationFacade, Set<ILoadLocation>> loadLocations = new HashMap<ConfigurationFacade, Set<ILoadLocation>>();
        this.recordSandbox(this.getItemsToLoadValues(), multipleCFA, loadLocations);
        for (ICollision collision : this.getCollisionsValues()) {
            this.recordSandbox(collision.getLocations(), multipleCFA, loadLocations);
        }
        ArrayList<IMultipleSandboxLoad> result = new ArrayList<IMultipleSandboxLoad>();
        for (Map.Entry entry : multipleCFA.entrySet()) {
            ConfigurationFacade configuration = (ConfigurationFacade)entry.getKey();
            Set<ISandbox> loadedSandboxes = configurationSandboxes.get(configuration);
            Set sandboxes = (Set)entry.getValue();
            if (loadedSandboxes != null) {
                sandboxes.addAll(loadedSandboxes);
            }
            if (sandboxes.size() <= 1) continue;
            MultipleSandboxLoad multipleSandboxLoad = new MultipleSandboxLoad(configuration, sandboxes, (Set)loadLocations.get(configuration));
            result.add((IMultipleSandboxLoad)multipleSandboxLoad);
        }
        return result;
    }

    private void recordSandbox(Collection<? extends ILoadLocation> toLoad, Map<ConfigurationFacade, Set<ISandbox>> multipleCFA, Map<ConfigurationFacade, Set<ILoadLocation>> loadLocations) {
        for (ILoadLocation iLoadLocation : toLoad) {
            ConfigurationFacade configuration = new ConfigurationFacade(iLoadLocation.getConnection(), (IComponentHandle)iLoadLocation.getComponent());
            Set<ISandbox> sandboxes = multipleCFA.get(configuration);
            if (sandboxes == null) {
                sandboxes = new HashSet<ISandbox>();
                multipleCFA.put(configuration, sandboxes);
            }
            sandboxes.add(iLoadLocation.getSandbox());
            Set<ILoadLocation> locations = loadLocations.get(configuration);
            if (locations == null) {
                locations = new HashSet<ILoadLocation>();
                loadLocations.put(configuration, locations);
            }
            locations.add(iLoadLocation);
        }
    }
}

