/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.ui.query.wizard;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.enterprise.metadata.ui.MetadataUIPlugin;
import com.ibm.team.enterprise.metadata.ui.query.util.ImpactAnalysisUtils;
import com.ibm.team.enterprise.metadata.ui.query.util.JazzFile;
import com.ibm.team.enterprise.metadata.ui.query.util.PhysicalImpactAnalysisCalculator;
import com.ibm.team.enterprise.metadata.ui.query.util.SCMUtil;
import com.ibm.team.enterprise.metadata.ui.query.view.QueryView;
import com.ibm.team.enterprise.metadata.ui.query.view.ViewUtil;
import com.ibm.team.enterprise.metadata.ui.query.wizard.ImpactAnalysisFirstPage;
import com.ibm.team.enterprise.metadata.ui.query.wizard.Messages;
import com.ibm.team.enterprise.rdf.query.common.select.result.SelectResult;
import com.ibm.team.enterprise.systemdefinition.common.model.ILanguageDefinition;
import com.ibm.team.internal.filesystem.ui.adapters.AbstractAdaptableRemoteResource;
import com.ibm.team.jface.util.UIUpdaterJob;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWizard;

public class ImpactAnalysisWizard
extends Wizard
implements IWorkbenchWizard {
    private final ImpactAnalysisFirstPage fFirstPage;
    protected IStructuredSelection selection;
    private ComputeAndShowResultsJob job;

    public ImpactAnalysisWizard(JazzFile jazzFile, ILanguageDefinition initialLangDef) {
        this.setNeedsProgressMonitor(true);
        this.fFirstPage = new ImpactAnalysisFirstPage(Messages.ImpactAnalysisWizardPageTitle, jazzFile, initialLangDef);
        this.fFirstPage.setTitle(Messages.ImpactAnalysisWizardPageTitle);
        this.fFirstPage.setDescription(Messages.ImpactAnalysisWizardPageDescription);
    }

    public void addPages() {
        super.addPages();
        this.addPage((IWizardPage)this.fFirstPage);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(Messages.ImpactAnalysisWizardTitle);
        this.selection = selection;
    }

    public boolean performFinish() {
        if (this.job != null) {
            this.job.cancel();
        }
        this.job = new ComputeAndShowResultsJob("", this.fFirstPage.getSearchStreamUUID(), this.fFirstPage.getLanguageDefinition(), this.fFirstPage.getBuildDefinition(), this.fFirstPage.getAddSearchPathButton().getSelection(), this.fFirstPage.getDependencyAnalysisButton().getSelection());
        this.job.setUser(true);
        this.job.schedule();
        return true;
    }

    public static Object getValidObjectFromSelection(IStructuredSelection selection) {
        if (selection != null && !selection.isEmpty()) {
            Object context = selection.getFirstElement();
            if (context instanceof IResource) {
                return context;
            }
            if (context instanceof SelectResult) {
                return context;
            }
            if (context instanceof IAdaptable) {
                return ((IAdaptable)context).getAdapter(AbstractAdaptableRemoteResource.class);
            }
        }
        return null;
    }

    private class ComputeAndShowResultsJob
    extends UIUpdaterJob {
        private static final int PHYS_IMPACT = 1;
        private static final int PHYS_DEPS = 2;
        private static final int LOG_IMPACT = 4;
        private static final int LOG_DEPS = 8;
        private int option;
        private PhysicalImpactAnalysisCalculator calculator;
        private List<SelectResult> results;
        private final ILanguageDefinition langDef;
        private final IBuildDefinition buildDef;
        private final String streamUUID;
        private String streamName;
        private String objectName;

        private ComputeAndShowResultsJob(String name, String streamUUID, ILanguageDefinition langDef, IBuildDefinition buildDef, boolean isSearchPath, boolean isDependencyAnalysis) {
            super(name);
            this.calculator = null;
            this.results = null;
            this.option = isDependencyAnalysis ? 2 : 1;
            this.option = isSearchPath ? this.option : this.option << 2;
            this.buildDef = buildDef;
            this.langDef = langDef;
            this.streamUUID = streamUUID;
        }

        public IStatus runInBackground(IProgressMonitor monitor) {
            block19: {
                monitor.beginTask(Messages.ImpactAnalysisWizardPage_Progress, -1);
                try {
                    try {
                        if (ImpactAnalysisWizard.this.selection != null && !ImpactAnalysisWizard.this.selection.isEmpty()) {
                            Object context = ImpactAnalysisWizard.this.selection.getFirstElement();
                            if (context instanceof IResource) {
                                this.calculator = new PhysicalImpactAnalysisCalculator((IResource)context, monitor);
                                this.objectName = ((IResource)context).getName();
                            } else if (context instanceof SelectResult) {
                                this.calculator = new PhysicalImpactAnalysisCalculator((SelectResult)context, monitor);
                                this.objectName = ViewUtil.getBindingValue((SelectResult)context, "logicalName");
                                if (this.objectName == null || this.objectName.isEmpty()) {
                                    this.objectName = ViewUtil.getBindingValue((SelectResult)context, "fileName");
                                }
                            } else if (context instanceof IAdaptable) {
                                AbstractAdaptableRemoteResource aarr = (AbstractAdaptableRemoteResource)((IAdaptable)context).getAdapter(AbstractAdaptableRemoteResource.class);
                                this.calculator = new PhysicalImpactAnalysisCalculator(JazzFile.createJazzFile(aarr, monitor));
                                this.objectName = aarr.getLocation().getName();
                            }
                        }
                        this.streamName = SCMUtil.getStreamName(SCMUtil.getAllStreams(ImpactAnalysisWizard.this.fFirstPage.getTeamRepository()), this.streamUUID);
                        switch (this.option) {
                            case 1: {
                                this.results = this.calculator.calculatePhysicalImpacts(this.langDef, this.buildDef, monitor);
                                break;
                            }
                            case 2: {
                                this.results = this.calculator.calculatePhysicalDependencies(this.langDef, this.buildDef, monitor);
                                break;
                            }
                            case 4: {
                                this.results = this.calculator.calculateLogicalImpacts(this.streamUUID, monitor);
                                break;
                            }
                            case 8: {
                                this.results = this.calculator.calculateLogicalDependencies(this.streamUUID, monitor);
                            }
                        }
                    }
                    catch (TeamRepositoryException ex) {
                        InvocationTargetException invEx = new InvocationTargetException(ex);
                        Throwable t = invEx.getTargetException();
                        if (t == null) {
                            t = ex;
                        }
                        MetadataUIPlugin.log(com.ibm.team.enterprise.metadata.ui.query.action.Messages.ImpactAnalysis_General_Error, t);
                        MessageDialog.openError((Shell)ImpactAnalysisWizard.this.getShell(), (String)com.ibm.team.enterprise.metadata.ui.query.action.Messages.ImpactAnalysis_General_Error, (String)t.getLocalizedMessage());
                        monitor.done();
                        break block19;
                    }
                }
                catch (Throwable throwable) {
                    monitor.done();
                    throw throwable;
                }
                monitor.done();
            }
            return super.runInBackground(monitor);
        }

        public IStatus runInUI(IProgressMonitor monitor) {
            String statusMessage = "";
            Object[] inserts = new Object[]{this.results.size(), this.objectName};
            switch (this.option) {
                case 1: {
                    statusMessage = NLS.bind((String)Messages.ImpactAnalysisWizardPage_PhysicalChangeImpactSearchResults, (Object[])inserts);
                    break;
                }
                case 2: {
                    statusMessage = NLS.bind((String)Messages.ImpactAnalysisWizardPage_PhysicalDependencySearchResults, (Object[])inserts);
                    break;
                }
                case 4: {
                    statusMessage = NLS.bind((String)Messages.ImpactAnalysisWizardPage_LogicalChangeImpactSearchResults, (Object[])inserts);
                    break;
                }
                case 8: {
                    statusMessage = NLS.bind((String)Messages.ImpactAnalysisWizardPage_LogicalDependencySearchResults, (Object[])inserts);
                }
            }
            statusMessage = String.valueOf(statusMessage) + " [" + com.ibm.team.enterprise.metadata.ui.query.part.Messages.ScopePart_STREAM_RADIO_LABEL + " " + this.streamName + "]";
            QueryView view = ViewUtil.openQueryView();
            view.setColumns(ImpactAnalysisUtils.getViewerColumns());
            view.setInput(this.results);
            view.setStatus(statusMessage);
            view.refresh();
            return super.runInUI(monitor);
        }
    }
}

