/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.ui.query.wizard;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.enterprise.build.ui.dialogs.DependencyBuildDefinitionSelectionDialog;
import com.ibm.team.enterprise.metadata.ui.MetadataUIPlugin;
import com.ibm.team.enterprise.metadata.ui.query.dialog.StreamSelectionDialog;
import com.ibm.team.enterprise.metadata.ui.query.util.ImpactAnalysisUtils;
import com.ibm.team.enterprise.metadata.ui.query.util.JazzFile;
import com.ibm.team.enterprise.metadata.ui.query.util.SCMUtil;
import com.ibm.team.enterprise.metadata.ui.query.util.Utils;
import com.ibm.team.enterprise.metadata.ui.query.wizard.Messages;
import com.ibm.team.enterprise.systemdefinition.common.model.IIBMiLanguageDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IIBMiPlatformObject;
import com.ibm.team.enterprise.systemdefinition.common.model.ILanguageDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IZosLanguageDefinition;
import com.ibm.team.enterprise.systemdefinition.ui.dialogs.LanguageDefinitionSelectionDialog;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ImpactAnalysisFirstPage
extends WizardPage {
    private Button dependencyAnalysisButton;
    private Button changeImpactAnalysisButton;
    private Button addSearchPathButton;
    private Text fLanguageDefinitionField;
    private ILanguageDefinition fLanguageDefinition;
    private Text fBuildDefinitionField;
    private Text fSearchStreamField;
    private IBuildDefinition fBuildDefinition;
    private Label fLangDefLabel;
    private Button fLangDefButton;
    private Label fBuildDefLabel;
    private Button fBuildDefButton;
    private Label fSearchStreamLabel;
    private Button fSearchStreamButton;
    private final JazzFile fJazzFile;
    private final ITeamRepository fTeamRepository;
    private String fSearchStreamUUID;
    private IWorkspace fInitialStream;
    private List<IWorkspace> fAvailableStreams;
    private static final int SIZING_TEXT_FIELD_WIDTH = 250;

    public ImpactAnalysisFirstPage(String pageName, JazzFile jazzFile, ILanguageDefinition initialLangDef) {
        super(pageName);
        this.setPageComplete(true);
        this.fJazzFile = jazzFile;
        this.fTeamRepository = this.fJazzFile.getTeamRepository();
        if (initialLangDef != null && initialLangDef.getTranslators().size() > 0) {
            this.fLanguageDefinition = initialLangDef;
        }
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        Composite subGroup = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        subGroup.setLayout((Layout)layout);
        subGroup.setLayoutData((Object)new GridData(768));
        this.createSearchTypeGroup(subGroup);
        this.createDefinitionsGroup(subGroup);
        this.setPageComplete(this.validatePage());
        this.setControl((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "com.ibm.team.filesystem.ide.ui.wizard_impactAnalysisPage1");
    }

    private final void createSearchTypeGroup(Composite subGroup) {
        Group typeGroup = new Group(subGroup, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        typeGroup.setLayout((Layout)layout);
        typeGroup.setText(Messages.ImpactAnalysisFirstPage_SearchType);
        typeGroup.setLayoutData((Object)new GridData(768));
        this.dependencyAnalysisButton = new Button((Composite)typeGroup, 16);
        this.dependencyAnalysisButton.setSelection(true);
        this.dependencyAnalysisButton.setText(Messages.ImpactAnalysisFirstPage_DependencyAnalysis);
        this.changeImpactAnalysisButton = new Button((Composite)typeGroup, 16);
        this.changeImpactAnalysisButton.setText(Messages.ImpactAnalysisFirstPage_ChangeImpactAnalysis);
        this.createSearchStreamGroup((Composite)typeGroup);
    }

    private final void createSearchStreamGroup(Composite subGroup) {
        Group streamGroup = new Group(subGroup, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        streamGroup.setLayout((Layout)layout);
        streamGroup.setLayoutData((Object)new GridData(768));
        this.fSearchStreamLabel = new Label((Composite)streamGroup, 0);
        this.fSearchStreamLabel.setText(com.ibm.team.enterprise.metadata.ui.query.part.Messages.ScopePart_STREAM_RADIO_LABEL);
        this.fSearchStreamLabel.setEnabled(true);
        this.fSearchStreamField = new Text((Composite)streamGroup, 2048);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.fSearchStreamField.setLayoutData((Object)data);
        this.fSearchStreamField.setFont(streamGroup.getFont());
        this.fSearchStreamField.setEditable(false);
        this.fSearchStreamField.setEnabled(true);
        this.initializeSearchStream();
        if (this.fInitialStream != null) {
            this.fSearchStreamField.setText(this.fInitialStream.getName());
            this.fSearchStreamUUID = this.fInitialStream.getItemId().getUuidValue();
        }
        this.fSearchStreamButton = new Button((Composite)streamGroup, 0);
        this.fSearchStreamButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    ImpactAnalysisFirstPage.this.getAvailableStreams(ImpactAnalysisFirstPage.this.fSearchStreamField.getDisplay());
                    StreamSelectionDialog dialog = new StreamSelectionDialog(ImpactAnalysisFirstPage.this.fSearchStreamField.getShell(), (IProcessAreaHandle)ImpactAnalysisFirstPage.this.fInitialStream.getOwner());
                    dialog.setElements(ImpactAnalysisFirstPage.this.fAvailableStreams.toArray(new IWorkspace[ImpactAnalysisFirstPage.this.fAvailableStreams.size()]));
                    if (dialog.open() == 0) {
                        IWorkspace selectedStream = dialog.getSelectedStream();
                        ImpactAnalysisFirstPage.this.fSearchStreamField.setText(Utils.getStreamDisplayName(selectedStream));
                        ImpactAnalysisFirstPage.this.fSearchStreamUUID = selectedStream.getItemId().getUuidValue();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (ImpactAnalysisFirstPage.this.fInitialStream == null || !ImpactAnalysisFirstPage.this.fSearchStreamUUID.equals(ImpactAnalysisFirstPage.this.fInitialStream.getItemId().getUuidValue())) {
                    ImpactAnalysisFirstPage.this.addSearchPathButton.setSelection(false);
                    ImpactAnalysisFirstPage.this.addSearchPathButton.setEnabled(false);
                } else {
                    ImpactAnalysisFirstPage.this.addSearchPathButton.setEnabled(true);
                }
                if (ImpactAnalysisFirstPage.this.addSearchPathButton.getSelection()) {
                    ImpactAnalysisFirstPage.this.fLangDefLabel.setEnabled(true);
                    ImpactAnalysisFirstPage.this.fLanguageDefinitionField.setEnabled(true);
                    ImpactAnalysisFirstPage.this.fLangDefButton.setEnabled(true);
                    ImpactAnalysisFirstPage.this.fBuildDefLabel.setEnabled(true);
                    ImpactAnalysisFirstPage.this.fBuildDefinitionField.setEnabled(true);
                    ImpactAnalysisFirstPage.this.fBuildDefButton.setEnabled(true);
                } else {
                    ImpactAnalysisFirstPage.this.fLangDefLabel.setEnabled(false);
                    ImpactAnalysisFirstPage.this.fLanguageDefinitionField.setEnabled(false);
                    ImpactAnalysisFirstPage.this.fLangDefButton.setEnabled(false);
                    ImpactAnalysisFirstPage.this.fBuildDefLabel.setEnabled(false);
                    ImpactAnalysisFirstPage.this.fBuildDefinitionField.setEnabled(false);
                    ImpactAnalysisFirstPage.this.fBuildDefButton.setEnabled(false);
                }
                ImpactAnalysisFirstPage.this.setPageComplete(ImpactAnalysisFirstPage.this.validatePage());
            }
        });
        this.fSearchStreamButton.setText(Messages.ImpactAnalysisFirstPage_SelectionButton);
        this.fSearchStreamButton.setEnabled(true);
    }

    private final void createDefinitionsGroup(Composite scopeGroup) {
        Group definitionGroup = new Group(scopeGroup, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        definitionGroup.setLayout((Layout)layout);
        definitionGroup.setText(Messages.ImpactAnalysisFirstPage_AdvancedSearch);
        definitionGroup.setLayoutData((Object)new GridData(768));
        this.addSearchPathButton = new Button((Composite)definitionGroup, 32);
        this.addSearchPathButton.setText(Messages.ImpactAnalysisFirstPage_ApplySearchPath);
        this.addSearchPathButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (ImpactAnalysisFirstPage.this.addSearchPathButton.getSelection()) {
                    ImpactAnalysisFirstPage.this.fLangDefLabel.setEnabled(true);
                    ImpactAnalysisFirstPage.this.fLanguageDefinitionField.setEnabled(true);
                    ImpactAnalysisFirstPage.this.fLangDefButton.setEnabled(true);
                    ImpactAnalysisFirstPage.this.fBuildDefLabel.setEnabled(true);
                    ImpactAnalysisFirstPage.this.fBuildDefinitionField.setEnabled(true);
                    ImpactAnalysisFirstPage.this.fBuildDefButton.setEnabled(true);
                } else {
                    ImpactAnalysisFirstPage.this.fLangDefLabel.setEnabled(false);
                    ImpactAnalysisFirstPage.this.fLanguageDefinitionField.setEnabled(false);
                    ImpactAnalysisFirstPage.this.fLangDefButton.setEnabled(false);
                    ImpactAnalysisFirstPage.this.fBuildDefLabel.setEnabled(false);
                    ImpactAnalysisFirstPage.this.fBuildDefinitionField.setEnabled(false);
                    ImpactAnalysisFirstPage.this.fBuildDefButton.setEnabled(false);
                }
                ImpactAnalysisFirstPage.this.setPageComplete(ImpactAnalysisFirstPage.this.validatePage());
            }
        });
        Group bComp = new Group((Composite)definitionGroup, 0);
        GridLayout bLayout = new GridLayout();
        bLayout.numColumns = 3;
        bComp.setLayout((Layout)bLayout);
        bComp.setLayoutData((Object)new GridData(768));
        this.fLangDefLabel = new Label((Composite)bComp, 0);
        this.fLangDefLabel.setText(Messages.ImpactAnalysisFirstPage_LanguageDefinition);
        this.fLangDefLabel.setEnabled(false);
        this.fLanguageDefinitionField = new Text((Composite)bComp, 2048);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.fLanguageDefinitionField.setLayoutData((Object)data);
        this.fLanguageDefinitionField.setFont(bComp.getFont());
        this.fLanguageDefinitionField.setEditable(false);
        this.fLanguageDefinitionField.setEnabled(false);
        this.fLanguageDefinitionField.setText(this.fLanguageDefinition != null ? this.fLanguageDefinition.getName() : "");
        this.fLangDefButton = new Button((Composite)bComp, 0);
        this.fLangDefButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    if (ImpactAnalysisFirstPage.this.fTeamRepository != null && ImpactAnalysisFirstPage.this.fTeamRepository.loggedIn()) {
                        LanguageDefinitionSelectionDialog dialog;
                        IProjectArea projectArea = null;
                        IItemType itemType = IZosLanguageDefinition.ITEM_TYPE;
                        if (ImpactAnalysisFirstPage.this.fJazzFile.getPlatform() != null && ImpactAnalysisFirstPage.this.fJazzFile.getPlatform().equals(IIBMiPlatformObject.class)) {
                            itemType = IIBMiLanguageDefinition.ITEM_TYPE;
                        }
                        if ((dialog = new LanguageDefinitionSelectionDialog(ImpactAnalysisFirstPage.this.getShell(), ImpactAnalysisFirstPage.this.fTeamRepository, projectArea, ImpactAnalysisFirstPage.this.getLangDefFilter(), itemType)).open() == 0) {
                            final ISystemDefinition systemDefinition = dialog.getSelectedSystemDefinition();
                            ImpactAnalysisFirstPage.this.getWizard().getContainer().run(true, false, new IRunnableWithProgress(){

                                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                                    ImpactAnalysisFirstPage.this.fLanguageDefinition = (ILanguageDefinition)systemDefinition;
                                }
                            });
                            if (ImpactAnalysisFirstPage.this.fLanguageDefinition != null) {
                                ImpactAnalysisFirstPage.this.fLanguageDefinitionField.setText(ImpactAnalysisFirstPage.this.fLanguageDefinition.getName());
                            }
                        }
                    }
                }
                catch (InterruptedException projectArea) {
                }
                catch (InvocationTargetException ex) {
                    Throwable t = ex.getTargetException();
                    if (t == null) {
                        t = ex;
                    }
                    MetadataUIPlugin.log("", t);
                }
                ImpactAnalysisFirstPage.this.setPageComplete(ImpactAnalysisFirstPage.this.validatePage());
            }
        });
        this.fLangDefButton.setText(Messages.ImpactAnalysisFirstPage_SelectionButton);
        this.fLangDefButton.setEnabled(false);
        this.fBuildDefLabel = new Label((Composite)bComp, 0);
        this.fBuildDefLabel.setText(Messages.ImpactAnalysisFirstPage_BuildDefinition);
        this.fBuildDefLabel.setEnabled(false);
        this.fBuildDefinitionField = new Text((Composite)bComp, 2048);
        GridData bddata = new GridData(768);
        bddata.widthHint = 250;
        this.fBuildDefinitionField.setLayoutData((Object)bddata);
        this.fBuildDefinitionField.setFont(bComp.getFont());
        this.fBuildDefinitionField.setEditable(false);
        this.fBuildDefinitionField.setEnabled(false);
        this.fBuildDefButton = new Button((Composite)bComp, 0);
        this.fBuildDefButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DependencyBuildDefinitionSelectionDialog dialog = new DependencyBuildDefinitionSelectionDialog(ImpactAnalysisFirstPage.this.getShell(), false, (IProcessAreaHandle)ImpactAnalysisFirstPage.this.fInitialStream.getOwner(), ImpactAnalysisFirstPage.this.fJazzFile.getPlatform());
                if (dialog.open() == 0) {
                    ImpactAnalysisFirstPage.this.fBuildDefinition = dialog.getFirstSelectedBuildDefinition();
                    if (ImpactAnalysisFirstPage.this.fBuildDefinition != null) {
                        ImpactAnalysisFirstPage.this.fBuildDefinitionField.setText(ImpactAnalysisFirstPage.this.fBuildDefinition.getId());
                    }
                }
                ImpactAnalysisFirstPage.this.setPageComplete(ImpactAnalysisFirstPage.this.validatePage());
            }
        });
        this.fBuildDefButton.setText(Messages.ImpactAnalysisFirstPage_SelectionButton);
        this.fBuildDefButton.setEnabled(false);
    }

    protected void initializeSearchStream() {
        NullProgressMonitor monitor = new NullProgressMonitor();
        try {
            this.fInitialStream = ImpactAnalysisUtils.getWorkspaceStream(SCMPlatform.getWorkspaceManager((ITeamRepository)this.fTeamRepository).getWorkspaceConnection((IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(UUID.valueOf((String)this.fJazzFile.getStreamId()), null), (IProgressMonitor)monitor), (IProgressMonitor)monitor);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected boolean validatePage() {
        if (this.fSearchStreamUUID == null) {
            return false;
        }
        return !this.addSearchPathButton.getSelection() || this.fLanguageDefinition != null && this.fBuildDefinition != null;
    }

    public Button getDependencyAnalysisButton() {
        return this.dependencyAnalysisButton;
    }

    public Button getChangeImpactAnalysisButton() {
        return this.changeImpactAnalysisButton;
    }

    public Button getAddSearchPathButton() {
        return this.addSearchPathButton;
    }

    private ViewerFilter getLangDefFilter() {
        return new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof ILanguageDefinition) {
                    ILanguageDefinition langDef = (ILanguageDefinition)element;
                    return langDef.getTranslators().size() > 0;
                }
                return true;
            }
        };
    }

    public ILanguageDefinition getLanguageDefinition() {
        return this.fLanguageDefinition;
    }

    public IBuildDefinition getBuildDefinition() {
        return this.fBuildDefinition;
    }

    public String getSearchStreamUUID() {
        return this.fSearchStreamUUID;
    }

    public ITeamRepository getTeamRepository() {
        return this.fTeamRepository;
    }

    private void getAvailableStreams(Display display) {
        this.fAvailableStreams = SCMUtil.getAllStreams(this.fTeamRepository);
    }
}

